/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

public class Scale {
    private final double scaleX;
    private final double scaleY;
    public static final Scale One = new Scale(1.0, 1.0);

    public Scale(double x, double y) {
        if (x <= 0.0) {
            throw new IllegalArgumentException("scale " + x + " must be larger than 0);");
        }
        if (y <= 0.0) {
            throw new IllegalArgumentException("scale " + y + " must be larger than 0);");
        }
        this.scaleX = x;
        this.scaleY = y;
    }

    public double getX() {
        return this.scaleX;
    }

    public double getY() {
        return this.scaleY;
    }

    public Scale scale(double f) {
        return new Scale(this.scaleX * f, this.scaleY * f);
    }

    public Scale scaleX(double f) {
        return new Scale(this.scaleX * f, this.scaleY);
    }

    public Scale scaleY(double f) {
        return new Scale(this.scaleX, this.scaleY * f);
    }

    public boolean isOne() {
        return this.scaleX == 1.0 && this.scaleY == 1.0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.scaleX) ^ Double.doubleToLongBits(this.scaleX) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.scaleY) ^ Double.doubleToLongBits(this.scaleY) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scale other = (Scale)obj;
        if (Double.doubleToLongBits(this.scaleX) != Double.doubleToLongBits(other.scaleX)) {
            return false;
        }
        return Double.doubleToLongBits(this.scaleY) == Double.doubleToLongBits(other.scaleY);
    }

    public String toString() {
        return String.format("(%g,%g)", this.scaleX, this.scaleY);
    }
}

