/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.Selection;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public final class TableSelection
extends Selection {
    private int col = -1;
    private JTable table;

    TableSelection(JTable table, MouseEvent e) {
        this(table);
        this.setLeadSelection(e);
    }

    TableSelection(JTable table, int lead, int col) {
        this(table);
        this.setLeadSelection(lead, col);
    }

    TableSelection(JTable table) {
        this.table = table;
    }

    @Override
    protected ListSelectionModel getSelectionModel() {
        return this.table.getSelectionModel();
    }

    void setLeadSelection(MouseEvent e) {
        this.setLeadSelection(this.table.rowAtPoint(e.getPoint()), this.table.columnAtPoint(e.getPoint()));
    }

    void setLeadSelection(int lead, int col) {
        this.col = col < 0 ? -1 : this.table.convertColumnIndexToModel(col);
        super.setLeadSelection(lead);
    }

    @Override
    void setLeadSelection(int lead) {
        this.col = -1;
        super.setLeadSelection(lead);
    }

    public int getCol() {
        return this.col;
    }

    @Override
    protected int convertIndexToModel(int index) {
        return this.table.convertRowIndexToModel(index);
    }

    @Override
    public String toString() {
        return "index " + this.getLeadSelection() + ", col " + this.col + ", " + this.getSelectedIndices();
    }
}

