/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.ThumbnailEvent;
import com.mandelsoft.swing.ThumbnailListModel;
import com.mandelsoft.swing.ThumbnailListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ThumbnailListenerSupport<E> {
    private List<ThumbnailListener<E>> list;

    public void fireThumbnailChanged(ThumbnailListModel<E> model, E elem, BufferedImage image) {
        if (this.list != null && this.list.size() > 0) {
            ThumbnailEvent<E> event = new ThumbnailEvent<E>(model, elem, image);
            for (ThumbnailListener<E> l : this.list) {
                l.thumbnailChanged(event);
            }
        }
    }

    public void addThumbnailListener(ThumbnailListener<E> l) {
        if (this.list == null) {
            this.list = new ArrayList<ThumbnailListener<E>>();
        } else if (this.list.contains(l)) {
            return;
        }
        this.list.add(l);
    }

    public void removeThumbnailListener(ThumbnailListener<E> l) {
        if (this.list != null) {
            this.list.remove(l);
            if (this.list.isEmpty()) {
                this.list = null;
            }
        }
    }
}

