/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing.colorchooser;

import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.swing.FilePanel;
import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.swing.colorchooser.ColorImageModel;
import com.mandelsoft.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JScrollPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ImageChooserPanel
extends AbstractColorChooserPanel {
    private final int SCALE = 4;
    private final int SIZE = 150;
    private FilePanel file;
    private JScrollPane sp;
    private BufferedComponent buffer;
    private ImageListener listener;
    private PropertyChangeListener modellistener;
    private ColorImageModel model;
    private boolean adjusting = false;

    public ImageChooserPanel() {
        this.setInheritsPopupMenu(true);
        this.modellistener = new ModelListener();
        this.listener = new ImageListener();
        this.setColorImageModel(new ColorImageModel());
    }

    public ColorImageModel getColorImageModel() {
        return this.model;
    }

    public void setColorImageModel(ColorImageModel model) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this.modellistener);
        }
        this.model = model;
        this.model.addPropertyChangeListener(this.modellistener);
        if (this.buffer != null) {
            this.buffer.setImage(model.getImage());
        }
        if (this.file != null) {
            this.file.setFilename(model.getFilename());
        }
    }

    private Dimension limit(BufferedImage i, int w, int h) {
        if (w > i.getWidth()) {
            w = i.getWidth();
        }
        if (h > i.getHeight()) {
            h = i.getHeight();
        }
        return new Dimension(w, h);
    }

    @Override
    public String getDisplayName() {
        return "ImageColors";
    }

    @Override
    public int getMnemonic() {
        return -1;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        Color color = this.getColorFromModel();
        GBCPanel panel = new GBCPanel();
        this.buffer = new BufferedComponent(this.model.getImage());
        this.buffer.setScale(4.0);
        this.buffer.setScaleMode(true);
        this.buffer.getContentPane().addMouseListener(this.listener);
        this.buffer.getContentPane().addMouseMotionListener(this.listener);
        this.sp = new JScrollPane(this.buffer);
        this.sp.setVisible(true);
        this.sp.setPreferredSize(new Dimension(150, 150));
        panel.add((Component)this.sp, new GBC(0, 0));
        String n = this.model.getFilename();
        if (Utils.isEmpty(n)) {
            n = "C:/work/Mandelbrot.Test/src/my/mand/resources/splash.png";
        }
        this.file = new FilePanel("Image filename", n, null);
        this.file.addPropertyChangeListener("filename", this.modellistener);
        panel.add((Component)this.file, new GBC(0, 1));
        JButton b = new JButton("Load");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String n = ImageChooserPanel.this.file.getFilename();
                if (Utils.isEmpty(n)) {
                    return;
                }
                File f = new File(n);
                try {
                    BufferedImage image = ImageIO.read(f);
                    ImageChooserPanel.this.model.setImage(image);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        panel.add((Component)b, new GBC(0, 2).setFill(0));
        this.add(panel);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.buffer.removeMouseMotionListener(this.listener);
        this.buffer.removeMouseListener(this.listener);
        this.buffer = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == ImageChooserPanel.this.model) {
                if (evt.getPropertyName().equals("image")) {
                    BufferedImage image = ImageChooserPanel.this.model.getImage();
                    ImageChooserPanel.this.sp.setVisible(true);
                    ImageChooserPanel.this.sp.setPreferredSize(ImageChooserPanel.this.limit(image, 150, 150));
                    ImageChooserPanel.this.buffer.setImage(image);
                    ImageChooserPanel.this.sp.revalidate();
                } else if (evt.getPropertyName().equals("filename") && !ImageChooserPanel.this.adjusting) {
                    ImageChooserPanel.this.adjusting = true;
                    ImageChooserPanel.this.file.setFilename(ImageChooserPanel.this.model.getFilename());
                    ImageChooserPanel.this.adjusting = false;
                }
            } else if (!ImageChooserPanel.this.adjusting) {
                ImageChooserPanel.this.adjusting = true;
                ImageChooserPanel.this.model.setFilename((String)evt.getNewValue());
                ImageChooserPanel.this.adjusting = false;
            }
        }
    }

    private class ImageListener
    extends MouseAdapter {
        private boolean active;

        private ImageListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.active) {
                this.handle(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.active = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.active = true;
                this.handle(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                this.handle(e);
            }
        }

        private Color getColor(MouseEvent e) {
            int x = (int)Math.round((double)e.getX() / ImageChooserPanel.this.buffer.getScaleX());
            int y = (int)Math.round((double)e.getY() / ImageChooserPanel.this.buffer.getScaleY());
            BufferedImage im = ImageChooserPanel.this.buffer.getImage();
            return new Color(im.getRGB(x, y));
        }

        private void handle(MouseEvent e) {
            int x = (int)Math.round(((double)e.getX() - ImageChooserPanel.this.buffer.getScaleX() / 2.0) / ImageChooserPanel.this.buffer.getScaleX());
            int y = (int)Math.round(((double)e.getY() - ImageChooserPanel.this.buffer.getScaleY() / 2.0) / ImageChooserPanel.this.buffer.getScaleY());
            BufferedImage im = ImageChooserPanel.this.buffer.getImage();
            if (im == null || im.getWidth() <= x || im.getHeight() <= y) {
                return;
            }
            ImageChooserPanel.this.getColorSelectionModel().setSelectedColor(new Color(im.getRGB(x, y)));
        }
    }
}

