/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing.colorchooser;

import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.colorchooser.SyntheticImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageConsumer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RGBChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener,
HierarchyListener {
    private transient RGBImage palette;
    private transient RGBImage sliderPalette;
    private transient Image paletteImage;
    private transient Image sliderPaletteImage;
    private JSlider slider;
    private JSpinner redField;
    private JSpinner greenField;
    private JSpinner blueField;
    private JTextField hField;
    private JTextField sField;
    private JTextField bField;
    private boolean isAdjusting = false;
    private Point paletteSelection = new Point();
    private JLabel paletteLabel;
    private JLabel sliderPaletteLabel;
    private JRadioButton redRadio;
    private JRadioButton greenRadio;
    private JRadioButton blueRadio;
    private static final int PALETTE_DIMENSION = 200;
    private static final int MAX_RED_VALUE = 255;
    private static final int MAX_GREEN_VALUE = 255;
    private static final int MAX_BLUE_VALUE = 255;
    private static final int MAX_HUE_VALUE = 359;
    private static final int MAX_SATURATION_VALUE = 100;
    private static final int MAX_BRIGHTNESS_VALUE = 100;
    private int currentMode = 0;
    private static final int RED_MODE = 0;
    private static final int GREEN_MODE = 1;
    private static final int BLUE_MODE = 2;

    private void addPaletteListeners() {
        this.paletteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                float[] rgb = new float[3];
                RGBChooserPanel.this.palette.getRGBForLocation(e.getX(), e.getY(), rgb);
                RGBChooserPanel.this.updateRGB(rgb[0], rgb[1], rgb[2]);
            }
        });
        this.paletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int labelWidth = RGBChooserPanel.this.paletteLabel.getWidth();
                int labelHeight = RGBChooserPanel.this.paletteLabel.getHeight();
                int x = e.getX();
                int y = e.getY();
                if (x >= labelWidth) {
                    x = labelWidth - 1;
                }
                if (y >= labelHeight) {
                    y = labelHeight - 1;
                }
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                float[] rgb = new float[3];
                System.out.println("" + x + "," + y);
                RGBChooserPanel.this.palette.getRGBForLocation(x, y, rgb);
                RGBChooserPanel.this.updateRGB(rgb[0], rgb[1], rgb[2]);
            }
        });
    }

    private void updatePalette(float r, float g, float b) {
        int x = 0;
        int y = 0;
        switch (this.currentMode) {
            case 0: {
                if (r != this.palette.getRed()) {
                    this.palette.setRed(r);
                    this.palette.nextFrame();
                }
                x = (int)(g * 200.0f / 255.0f);
                y = (int)(b * 200.0f / 255.0f);
                break;
            }
            case 1: {
                if (g != this.palette.getGreen()) {
                    this.palette.setGreen(g);
                    this.palette.nextFrame();
                }
                x = (int)(r * 200.0f / 255.0f);
                y = (int)(b * 200.0f / 255.0f);
                break;
            }
            case 2: {
                if (b != this.palette.getBlue()) {
                    this.palette.setBlue(b);
                    this.palette.nextFrame();
                }
                x = (int)(r * 200.0f / 255.0f);
                y = (int)(g * 200.0f / 255.0f);
            }
        }
        this.paletteSelection.setLocation(x, y);
        this.paletteLabel.repaint();
    }

    private void updateSlider(float r, float g, float b) {
        float value = 0.0f;
        switch (this.currentMode) {
            case 0: {
                value = r;
                break;
            }
            case 1: {
                value = g;
                break;
            }
            case 2: {
                value = b;
            }
        }
        this.slider.setValue(Math.round(value * (float)this.slider.getMaximum() / 255.0f));
    }

    private void updateRGBTextFields(float red, float green, float blue) {
        int r = (int)red;
        int g = (int)green;
        int b = (int)blue;
        if ((Integer)this.redField.getValue() != r) {
            this.redField.setValue(new Integer(r));
        }
        if ((Integer)this.greenField.getValue() != g) {
            this.greenField.setValue(new Integer(g));
        }
        if ((Integer)this.blueField.getValue() != b) {
            this.blueField.setValue(new Integer(b));
        }
    }

    private void updateHSBTextFields(Color color) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        int h = Math.round(hsb[0] * 359.0f);
        int s = Math.round(hsb[1] * 100.0f);
        int b = Math.round(hsb[2] * 100.0f);
        this.hField.setText(String.valueOf(h));
        this.sField.setText(String.valueOf(s));
        this.bField.setText(String.valueOf(b));
    }

    private void updateRGB(float r, float g, float b) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.updatePalette(r, g, b);
            this.updateSlider(r, g, b);
            this.updateRGBTextFields(r, g, b);
            Color color = new Color((int)r, (int)g, (int)b);
            this.updateHSBTextFields(color);
            this.getColorSelectionModel().setSelectedColor(color);
            this.isAdjusting = false;
        }
    }

    @Override
    public void updateChooser() {
        if (!this.isAdjusting) {
            float[] rgb = this.getRGBColorFromModel();
            this.updateRGB(rgb[0], rgb[1], rgb[2]);
        }
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
        this.setInheritsPopupMenu(true);
        this.addHierarchyListener(this);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.cleanupPalettesIfNecessary();
        this.removeAll();
        this.removeHierarchyListener(this);
    }

    private float[] getRGBColorFromModel() {
        Color color = this.getColorFromModel();
        float[] rgb = new float[]{color.getRed(), color.getGreen(), color.getBlue()};
        return rgb;
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        JComponent spp = this.buildSliderPalettePanel();
        spp.setInheritsPopupMenu(true);
        this.add((Component)spp, "Before");
        JPanel controlHolder = new JPanel(new GridBagLayout());
        JComponent hsbControls = this.buildHSBControls();
        hsbControls.setInheritsPopupMenu(true);
        controlHolder.add((Component)hsbControls, new GBC(0, 0));
        controlHolder.add((Component)new JLabel(" "), new GBC(1, 0));
        JComponent rgbControls = this.buildRGBControls();
        rgbControls.setInheritsPopupMenu(true);
        controlHolder.add((Component)rgbControls, new GBC(0, 1));
        controlHolder.setInheritsPopupMenu(true);
        controlHolder.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add((Component)controlHolder, "Center");
    }

    private JComponent buildHSBControls() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setInheritsPopupMenu(true);
        Color color = this.getColorFromModel();
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.hField = new JTextField(String.valueOf(hsb[0]), 3);
        this.hField.setEditable(false);
        this.hField.setHorizontalAlignment(4);
        this.hField.setInheritsPopupMenu(true);
        this.sField = new JTextField(String.valueOf(hsb[1]), 3);
        this.sField.setEditable(false);
        this.sField.setHorizontalAlignment(4);
        this.sField.setInheritsPopupMenu(true);
        this.bField = new JTextField(String.valueOf(hsb[2]), 3);
        this.bField.setEditable(false);
        this.bField.setHorizontalAlignment(4);
        this.bField.setInheritsPopupMenu(true);
        String hString = "H";
        String sString = "S";
        String bString = "B";
        panel.add((Component)new JLabel(hString), new GBC(0, 0));
        panel.add((Component)this.hField, new GBC(1, 0));
        panel.add((Component)new JLabel(sString), new GBC(0, 1));
        panel.add((Component)this.sField, new GBC(1, 1));
        panel.add((Component)new JLabel(bString), new GBC(0, 2));
        panel.add((Component)this.bField, new GBC(1, 2));
        return panel;
    }

    private JComponent buildRGBControls() {
        String redString = "R";
        String greenString = "G";
        String blueString = "B";
        RadioButtonHandler handler = new RadioButtonHandler();
        this.redRadio = new JRadioButton(redString);
        this.redRadio.addActionListener(handler);
        this.redRadio.setSelected(true);
        this.redRadio.setInheritsPopupMenu(true);
        this.greenRadio = new JRadioButton(greenString);
        this.greenRadio.addActionListener(handler);
        this.greenRadio.setInheritsPopupMenu(true);
        this.blueRadio = new JRadioButton(blueString);
        this.blueRadio.addActionListener(handler);
        this.blueRadio.setInheritsPopupMenu(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.redRadio);
        group.add(this.greenRadio);
        group.add(this.blueRadio);
        Color c = this.getColorFromModel();
        this.redField = new JSpinner(new SpinnerNumberModel(c.getRed(), 0, 255, 1));
        this.greenField = new JSpinner(new SpinnerNumberModel(c.getGreen(), 0, 255, 1));
        this.blueField = new JSpinner(new SpinnerNumberModel(c.getBlue(), 0, 255, 1));
        this.redField.addChangeListener(this);
        this.greenField.addChangeListener(this);
        this.blueField.addChangeListener(this);
        this.redField.setInheritsPopupMenu(true);
        this.greenField.setInheritsPopupMenu(true);
        this.blueField.setInheritsPopupMenu(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.redRadio, new GBC(0, 0));
        panel.add((Component)this.redField, new GBC(1, 0));
        panel.add((Component)this.greenRadio, new GBC(0, 1));
        panel.add((Component)this.greenField, new GBC(1, 1));
        panel.add((Component)this.blueRadio, new GBC(0, 2));
        panel.add((Component)this.blueField, new GBC(1, 2));
        panel.setInheritsPopupMenu(true);
        return panel;
    }

    private void setMode(int mode) {
        if (this.currentMode == mode) {
            return;
        }
        this.isAdjusting = true;
        this.currentMode = mode;
        Color c = this.getColorFromModel();
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        switch (this.currentMode) {
            case 0: {
                this.slider.setInverted(true);
                this.slider.setMaximum(255);
                this.slider.setValue(r);
                this.palette.setValues(0, r, g, b);
                this.sliderPalette.setValues(3, r, g, b);
                break;
            }
            case 1: {
                this.slider.setInverted(true);
                this.slider.setMaximum(255);
                this.slider.setValue(g);
                this.palette.setValues(1, r, g, b);
                this.sliderPalette.setValues(4, r, g, b);
                break;
            }
            case 2: {
                this.slider.setInverted(true);
                this.slider.setMaximum(255);
                this.slider.setValue(b);
                this.palette.setValues(2, r, g, b);
                this.sliderPalette.setValues(5, r, g, b);
            }
        }
        this.isAdjusting = false;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.updateChooser();
    }

    protected JComponent buildSliderPalettePanel() {
        this.slider = new JSlider(1, 0, 255, 0);
        this.slider.setInverted(true);
        this.slider.setPaintTrack(false);
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width, 215));
        this.slider.addChangeListener(this);
        this.slider.setInheritsPopupMenu(true);
        this.slider.putClientProperty("Slider.paintThumbArrowShape", Boolean.TRUE);
        this.paletteLabel = this.createPaletteLabel();
        this.addPaletteListeners();
        this.sliderPaletteLabel = new JLabel();
        JPanel panel = new JPanel();
        panel.add(this.paletteLabel);
        panel.add(this.slider);
        panel.add(this.sliderPaletteLabel);
        this.initializePalettesIfNecessary();
        return panel;
    }

    private void initializePalettesIfNecessary() {
        if (this.palette != null) {
            return;
        }
        Color c = this.getColorFromModel();
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        switch (this.currentMode) {
            case 0: {
                this.palette = new RGBImage(0, 200, 200, r, g, b);
                this.sliderPalette = new RGBImage(3, 16, 200, r, g, b);
                break;
            }
            case 1: {
                this.palette = new RGBImage(1, 200, 200, r, g, b);
                this.sliderPalette = new RGBImage(4, 16, 200, r, g, b);
                break;
            }
            case 2: {
                this.palette = new RGBImage(2, 200, 200, r, g, b);
                this.sliderPalette = new RGBImage(5, 16, 200, r, g, b);
            }
        }
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderPaletteImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderPaletteImage));
    }

    private void cleanupPalettesIfNecessary() {
        if (this.palette == null) {
            return;
        }
        this.palette.aborted = true;
        this.sliderPalette.aborted = true;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.palette = null;
        this.sliderPalette = null;
        this.paletteImage = null;
        this.sliderPaletteImage = null;
        this.paletteLabel.setIcon(null);
        this.sliderPaletteLabel.setIcon(null);
    }

    protected JLabel createPaletteLabel() {
        return new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.white);
                g.drawOval(((RGBChooserPanel)RGBChooserPanel.this).paletteSelection.x - 4, ((RGBChooserPanel)RGBChooserPanel.this).paletteSelection.y - 4, 8, 8);
            }
        };
    }

    @Override
    public String getDisplayName() {
        return "RGB";
    }

    @Override
    public int getMnemonic() {
        return -1;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.slider) {
            boolean modelIsAdjusting = this.slider.getModel().getValueIsAdjusting();
            int sliderValue = this.slider.getValue();
            int sliderRange = this.slider.getMaximum();
            int value = sliderValue;
            float[] rgb = this.getRGBColorFromModel();
            switch (this.currentMode) {
                case 0: {
                    this.updateRGB(value, rgb[1], rgb[2]);
                    break;
                }
                case 1: {
                    this.updateRGB(rgb[0], value, rgb[2]);
                    break;
                }
                case 2: {
                    this.updateRGB(rgb[0], rgb[1], value);
                }
            }
        } else if (e.getSource() instanceof JSpinner) {
            int red = (Integer)this.redField.getValue();
            int green = (Integer)this.greenField.getValue();
            int blue = (Integer)this.blueField.getValue();
            this.updateRGB(red, green, blue);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent he) {
        if ((he.getChangeFlags() & 2L) != 0L) {
            if (this.isDisplayable()) {
                this.initializePalettesIfNecessary();
            } else {
                this.cleanupPalettesIfNecessary();
            }
        }
    }

    class RGBImage
    extends SyntheticImage {
        protected float r;
        protected float g;
        protected float b;
        protected float[] rgb;
        protected boolean isDirty;
        protected int cachedY;
        protected int cachedColor;
        protected int type;
        private static final int RSQUARE = 0;
        private static final int GSQUARE = 1;
        private static final int BSQUARE = 2;
        private static final int RSLIDER = 3;
        private static final int GSLIDER = 4;
        private static final int BSLIDER = 5;

        protected RGBImage(int type, int width, int height, float r, float g, float b) {
            super(width, height);
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.rgb = new float[3];
            this.isDirty = true;
            this.setValues(type, r, g, b);
        }

        public void setValues(int type, float r, float g, float b) {
            this.type = type;
            this.cachedY = -1;
            this.cachedColor = 0;
            this.setRed(r);
            this.setGreen(g);
            this.setBlue(b);
        }

        public final void setRed(float red) {
            this.r = red;
        }

        public final void setGreen(float green) {
            this.g = green;
        }

        public final void setBlue(float blue) {
            this.b = blue;
        }

        public final float getRed() {
            return this.r;
        }

        public final float getGreen() {
            return this.g;
        }

        public final float getBlue() {
            return this.b;
        }

        @Override
        protected boolean isStatic() {
            return false;
        }

        public synchronized void nextFrame() {
            this.isDirty = true;
            this.notifyAll();
        }

        @Override
        public synchronized void addConsumer(ImageConsumer ic) {
            this.isDirty = true;
            super.addConsumer(ic);
        }

        private int getRGBForLocation(int x, int y) {
            if (this.type >= 3 && y == this.cachedY) {
                return this.cachedColor;
            }
            this.getRGBForLocation(x, y, this.rgb);
            this.cachedY = y;
            this.cachedColor = new Color((int)this.rgb[0], (int)this.rgb[1], (int)this.rgb[2]).getRGB();
            return this.cachedColor;
        }

        public void getRGBForLocation(int x, int y, float[] rgbArray) {
            float xStep = (float)x / (float)(this.width - 1);
            float yStep = (float)y / (float)(this.height - 1);
            switch (this.type) {
                case 0: {
                    rgbArray[0] = this.r;
                    rgbArray[1] = xStep * 255.0f;
                    rgbArray[2] = yStep * 255.0f;
                    break;
                }
                case 1: {
                    rgbArray[0] = xStep * 255.0f;
                    rgbArray[1] = this.g;
                    rgbArray[2] = yStep * 255.0f;
                    break;
                }
                case 2: {
                    rgbArray[0] = xStep * 255.0f;
                    rgbArray[1] = yStep * 255.0f;
                    rgbArray[2] = this.b;
                    break;
                }
                case 3: {
                    rgbArray[0] = (float)y * yStep;
                    rgbArray[1] = 0.0f;
                    rgbArray[2] = 0.0f;
                    break;
                }
                case 4: {
                    rgbArray[0] = 0.0f;
                    rgbArray[1] = (float)y * yStep;
                    rgbArray[2] = 0.0f;
                    break;
                }
                case 5: {
                    rgbArray[0] = 0.0f;
                    rgbArray[1] = 0.0f;
                    rgbArray[2] = (float)y * yStep;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void computeRow(int y, int[] row) {
            if (y == 0) {
                RGBImage rGBImage = this;
                synchronized (rGBImage) {
                    try {
                        while (!this.isDirty) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.isDirty = false;
                }
            }
            if (this.aborted) {
                return;
            }
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.getRGBForLocation(i, y);
            }
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            if (obj instanceof JRadioButton) {
                JRadioButton button = (JRadioButton)obj;
                if (button == RGBChooserPanel.this.redRadio) {
                    RGBChooserPanel.this.setMode(0);
                } else if (button == RGBChooserPanel.this.greenRadio) {
                    RGBChooserPanel.this.setMode(1);
                } else if (button == RGBChooserPanel.this.blueRadio) {
                    RGBChooserPanel.this.setMode(2);
                }
            }
        }
    }
}

