/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class SwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    UserSwatchPanel userSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener userSwatchListener;
    UserColorSource userColorSource;
    private static String userStr = "User";
    private Set<UserColorListener> listeners = new HashSet<UserColorListener>();

    public SwatchChooserPanel() {
        this.setInheritsPopupMenu(true);
    }

    public SwatchChooserPanel(UserColorSource src) {
        this.setInheritsPopupMenu(true);
        this.setUserColorSource(src);
    }

    @Override
    public String getDisplayName() {
        return "Samples";
    }

    @Override
    public int getMnemonic() {
        return -1;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void setUserColorSource(UserColorSource src) {
        this.userColorSource = src;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel superHolder = new JPanel(gb);
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.putClientProperty("AccessibleName", this.getDisplayName());
        this.swatchPanel.setInheritsPopupMenu(true);
        this.userSwatchPanel = new UserSwatchPanel();
        this.userSwatchPanel.putClientProperty("AccessibleName", userStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.userSwatchListener = new UserSwatchListener();
        this.userSwatchPanel.addMouseListener(this.userSwatchListener);
        JPanel mainHolder = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        mainHolder.setBorder(border);
        mainHolder.add((Component)this.swatchPanel, "Center");
        gbc.gridheight = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 0, 10);
        superHolder.add((Component)mainHolder, gbc);
        gbc.insets = oldInsets;
        this.userSwatchPanel.addMouseListener(this.userSwatchListener);
        this.userSwatchPanel.setInheritsPopupMenu(true);
        JPanel userHolder = new JPanel(new BorderLayout());
        userHolder.setBorder(border);
        userHolder.setInheritsPopupMenu(true);
        userHolder.add((Component)this.userSwatchPanel, "Center");
        JLabel l = new JLabel(userStr);
        l.setLabelFor(this.userSwatchPanel);
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        superHolder.add((Component)l, gbc);
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 2);
        superHolder.add((Component)userHolder, gbc);
        JPanel buttonHolder = new JPanel();
        JButton b = new JButton(new SetColorAction());
        buttonHolder.add(b);
        b = new JButton(new RemoveColorAction());
        buttonHolder.add(b);
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(10, 0, 0, 0);
        superHolder.add((Component)buttonHolder, gbc);
        superHolder.setInheritsPopupMenu(true);
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.userSwatchPanel.removeMouseListener(this.userSwatchListener);
        this.swatchPanel = null;
        this.userSwatchPanel = null;
        this.mainSwatchListener = null;
        this.userSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    public void addUserColor(Color color) {
        this.userSwatchPanel.addUserColor(color);
    }

    public void removeUserColor(Color color) {
        this.userSwatchPanel.removeUserColor(color);
    }

    public void addColorListener(UserColorListener h) {
        this.listeners.add(h);
    }

    public void removeColorListener(UserColorListener h) {
        this.listeners.remove(h);
    }

    protected void userColorAdded(Color c) {
        for (UserColorListener h : this.listeners) {
            h.colorAdded(c);
        }
    }

    protected void userColorRemoved(Color c) {
        for (UserColorListener h : this.listeners) {
            h.colorRemoved(c);
        }
    }

    public static interface UserColorSource {
        public Color getUserColor(int var1);
    }

    class MainSwatchPanel
    extends SwatchPanel {
        MainSwatchPanel() {
        }

        @Override
        protected void initValues() {
            this.swatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize");
            this.numSwatches = new Dimension(31, 9);
            this.gap = new Dimension(1, 1);
        }

        @Override
        protected void initColors() {
            int[] rawValues = this.initRawValues();
            int numColors = rawValues.length / 3;
            this.colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                this.colors[i] = new Color(rawValues[i * 3], rawValues[i * 3 + 1], rawValues[i * 3 + 2]);
            }
        }

        private int[] initRawValues() {
            int[] rawValues = new int[]{255, 255, 255, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 255, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 204, 204, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 153, 255, 255, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 204, 204, 204, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 102, 255, 255, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 153, 153, 153, 51, 255, 255, 51, 204, 255, 51, 153, 255, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 51, 255, 255, 51, 255, 255, 51, 204, 255, 51, 153, 255, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 51, 255, 255, 51, 204, 255, 51, 153, 255, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 153, 153, 153, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 0, 255, 255, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 102, 102, 102, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 102, 102, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 51, 51, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 0, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 51, 51, 51};
            return rawValues;
        }
    }

    class SwatchPanel
    extends JPanel {
        protected Color[] colors;
        protected Dimension swatchSize;
        protected Dimension numSwatches;
        protected Dimension gap;

        public SwatchPanel() {
            this.initValues();
            this.initColors();
            this.setToolTipText("");
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setRequestFocusEnabled(false);
            this.setInheritsPopupMenu(true);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        protected void initValues() {
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int row = 0; row < this.numSwatches.height; ++row) {
                int y = row * (this.swatchSize.height + this.gap.height);
                for (int column = 0; column < this.numSwatches.width; ++column) {
                    g.setColor(this.getColorForCell(column, row));
                    int x = !this.getComponentOrientation().isLeftToRight() && this instanceof UserSwatchPanel ? (this.numSwatches.width - column - 1) * (this.swatchSize.width + this.gap.width) : column * (this.swatchSize.width + this.gap.width);
                    g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                    g.setColor(Color.black);
                    g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                    g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
            int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
            return new Dimension(x, y);
        }

        protected void initColors() {
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Color color = this.getColorForLocation(e.getX(), e.getY());
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }

        public Color getColorForLocation(int x, int y) {
            int column = !this.getComponentOrientation().isLeftToRight() && this instanceof UserSwatchPanel ? this.numSwatches.width - x / (this.swatchSize.width + this.gap.width) - 1 : x / (this.swatchSize.width + this.gap.width);
            int row = y / (this.swatchSize.height + this.gap.height);
            return this.getColorForCell(column, row);
        }

        private Color getColorForCell(int column, int row) {
            return this.colors[row * this.numSwatches.width + column];
        }
    }

    class UserSwatchPanel
    extends SwatchPanel {
        UserSwatchPanel() {
        }

        @Override
        protected void initValues() {
            this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize");
            this.numSwatches = new Dimension(7, 7);
            this.gap = new Dimension(1, 1);
        }

        @Override
        protected void initColors() {
            Color defaultUserColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
            int numColors = this.numSwatches.width * this.numSwatches.height;
            this.colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                Color c = null;
                if (SwatchChooserPanel.this.userColorSource != null) {
                    c = SwatchChooserPanel.this.userColorSource.getUserColor(i);
                }
                if (c == null) {
                    c = defaultUserColor;
                }
                this.colors[i] = c;
            }
        }

        public void addUserColor(Color c) {
            for (Color o : this.colors) {
                if (!o.equals(c)) continue;
                return;
            }
            System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
            this.colors[0] = c;
            SwatchChooserPanel.this.userColorAdded(c);
            this.repaint();
        }

        public void removeUserColor(Color c) {
            for (int i = 0; i < this.colors.length; ++i) {
                if (!this.colors[i].equals(c)) continue;
                System.arraycopy(this.colors, i + 1, this.colors, i, this.colors.length - i - 1);
                Color n = null;
                if (SwatchChooserPanel.this.userColorSource != null) {
                    n = SwatchChooserPanel.this.userColorSource.getUserColor(i);
                }
                if (n == null) {
                    n = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
                }
                this.colors[this.colors.length - 1] = n;
                SwatchChooserPanel.this.userColorRemoved(c);
                this.repaint();
            }
        }
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            SwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    class UserSwatchListener
    extends MouseAdapter
    implements Serializable {
        UserSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SwatchChooserPanel.this.userSwatchPanel.getColorForLocation(e.getX(), e.getY());
            SwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    class SetColorAction
    extends AbstractAction {
        public SetColorAction() {
            super("Memorize Color");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwatchChooserPanel.this.addUserColor(SwatchChooserPanel.this.getColorSelectionModel().getSelectedColor());
        }
    }

    class RemoveColorAction
    extends AbstractAction {
        public RemoveColorAction() {
            super("Remove Color");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwatchChooserPanel.this.removeUserColor(SwatchChooserPanel.this.getColorSelectionModel().getSelectedColor());
        }
    }

    public static interface UserColorListener {
        public void colorAdded(Color var1);

        public void colorRemoved(Color var1);
    }
}

