/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing.worker;

import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public class WorkerProgressMonitor
extends ProgressMonitor
implements PropertyChangeListener {
    private NoteFormatter formatter;
    private SwingWorker worker;

    public WorkerProgressMonitor(Component parentComponent, Object message, SwingWorker worker) {
        this(parentComponent, message, new DefaultNoteFormatter(), worker);
    }

    public WorkerProgressMonitor(Component parentComponent, Object message, NoteFormatter formatter, SwingWorker worker) {
        super(parentComponent, message, "Preparing...", 0, 100);
        this.formatter = formatter;
        this.worker = worker;
        worker.addPropertyChangeListener(this);
        this.setProgress(0);
        worker.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            this.setProgress((Integer)evt.getNewValue());
        }
    }

    @Override
    public void setProgress(int progress) {
        String message = this.formatter.format(progress);
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        this.setNote(message);
        super.setProgress(progress);
        if (this.isCanceled() || this.worker.isDone()) {
            Toolkit.getDefaultToolkit().beep();
            if (this.isCanceled()) {
                this.worker.cancel(true);
            }
            this.close();
        }
    }

    public static class DefaultNoteFormatter
    implements NoteFormatter {
        @Override
        public String format(int progress) {
            return String.format("Completed %d%%...", progress);
        }
    }

    public static interface NoteFormatter {
        public String format(int var1);
    }
}

