/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractHashList<T>
implements List<T> {
    private List<T> list = new ArrayList<T>();

    public AbstractHashList() {
    }

    public AbstractHashList(Collection<? extends T> c) {
        this.addAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
        this.clearMap();
    }

    protected abstract void clearMap();

    protected abstract void addMap(T var1);

    protected abstract void removeMap(T var1);

    @Override
    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        boolean b = this.list.add(e);
        if (b) {
            this.addMap(e);
        }
        return b;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = this.list.remove(o);
        if (b) {
            Object e = o;
            this.removeMap(e);
        }
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean added = false;
        for (T e : c) {
            if (!this.add(e)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean added = this.list.addAll(index, c);
        for (T e : c) {
            this.addMap(e);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.list.retainAll(c)) {
            this.clearMap();
            for (T e : this.list) {
                this.addMap(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T e) {
        T old = this.list.set(index, e);
        if (old != null && !old.equals(e)) {
            this.removeMap(old);
            this.addMap(e);
        }
        return old;
    }

    @Override
    public void add(int index, T e) {
        this.list.add(index, e);
        this.addMap(e);
    }

    @Override
    public T remove(int index) {
        T old = this.list.remove(index);
        if (old != null) {
            this.removeMap(old);
        }
        return old;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

