/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.ElementName;

public class DefaultElementName<N extends ElementName<N>>
implements ElementName<N> {
    protected String name;
    protected String label;

    protected DefaultElementName() {
    }

    protected DefaultElementName(String n) {
        this.name = n;
        this.label = DefaultElementName.label(n);
    }

    protected DefaultElementName(String name, String label) {
        String tmp = DefaultElementName.label(name);
        if (tmp != null) {
            throw new IllegalArgumentException("no remote name for explicitly labeled name");
        }
        this.name = DefaultElementName.addLabel(name, label);
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getBasename() {
        return DefaultElementName.base(this.name);
    }

    public boolean isRemoteName() {
        return this.label != null;
    }

    public boolean isLocalName() {
        return !this.isRemoteName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementName other = (ElementName)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(N o) {
        if (o == null) {
            return 1;
        }
        return this.name.compareTo(o.getName());
    }

    static String addLabel(String name, String label) {
        return name + (label == null ? "" : "@" + label);
    }

    static String label(String name) {
        int is;
        int ix = name.lastIndexOf(64);
        if (ix >= 0 && (is = name.indexOf(126, ix + 1)) < 0) {
            return name.substring(ix + 1);
        }
        return null;
    }

    static String base(String name) {
        int is;
        int ix = name.lastIndexOf(64);
        if (ix >= 0 && (is = name.indexOf(126, ix + 1)) < 0) {
            return name.substring(0, ix);
        }
        return name;
    }

    static boolean isRemoteName(String name) {
        int ix = name.lastIndexOf(64);
        if (ix >= 0) {
            int is = name.indexOf(126, ix + 1);
            return is < 0;
        }
        return false;
    }
}

