/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.Coord;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.meth.AbstractPixelIterator;
import com.mandelsoft.mand.meth.DefaultMandIteratorFactory;
import com.mandelsoft.mand.meth.PixelIterator;
import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;
import java.util.Map;

public class MandIter
extends MandArith {
    private static BigDecimal br = new BigDecimal(5.0E-16);
    public static boolean useDLL;
    public static boolean optimized;

    public static PixelIterator createPixelIterator(MandelSpec mi) {
        return MandIter.createPixelIterator(mi, null);
    }

    public static PixelIterator createPixelIterator(MandelInfo mi) {
        return MandIter.createPixelIterator((MandelSpec)mi, mi.getProperties());
    }

    public static PixelIterator createPixelIterator(MandelInfo mi, PixelIterator.PropertySource.PropertyHandler h) {
        PixelIterator pi = MandIter.createPixelIterator((MandelSpec)mi, mi.getProperties());
        PixelIterator.setPropertyHandler(pi, h);
        return pi;
    }

    public static PixelIterator createPixelIterator(MandelSpec mi, Map<String, String> properties) {
        return new DefaultMandIteratorFactory(optimized, useDLL).createPixelIterator(mi, properties);
    }

    public static int buildref(IterationSink sink, Coord c, int limit, BigDecimal bound) {
        BigDecimal x = c.X;
        BigDecimal y = c.Y;
        sink.setValue(0, c);
        BigDecimal x2 = MandIter.mul(x, x);
        BigDecimal y2 = MandIter.mul(y, y);
        int it = 0;
        while (MandIter.add(x2, y2).compareTo(bound) < 0 && ++it <= limit) {
            BigDecimal xn = MandIter.add(MandIter.sub(x2, y2), c.X);
            BigDecimal yn = MandIter.add(MandIter.mul(MandIter.mul(b2, x), y), c.Y);
            x = xn;
            x2 = MandIter.mul(x, x);
            y = yn;
            y2 = MandIter.mul(y, y);
            sink.setValue(it, new Coord(x, y));
        }
        return it;
    }

    public static native int iter(String var0, String var1, String var2, String var3, String var4, int var5);

    public static native int iterP(String var0, String var1, String var2, String var3, String var4, int var5, int var6);

    private static int iter(BigDecimal sx, BigDecimal sy, BigDecimal cx, BigDecimal cy, BigDecimal bound, int limit) {
        if (useDLL) {
            System.out.println("using native(dll) mode");
            return MandIter.iterP(sx.toString(), sy.toString(), cx.toString(), cy.toString(), bound.toString(), limit, 100);
        }
        System.out.println("using BigDecimal mode");
        return new BigDecimalMandIterator(cx, cy).iter(sx, sy, cx, cy, bound, limit);
    }

    public static void main(String[] args) {
        System.out.println("calling iter");
        int i = MandIter.iter(b0, b0, new BigDecimal(0.5), b0, b10, 128000);
        System.out.println("got " + i);
    }

    static {
        optimized = false;
        try {
            System.loadLibrary("gmp");
            System.loadLibrary("Mandelbrot");
            useDLL = true;
        }
        catch (UnsatisfiedLinkError le) {
            System.out.println("failed:" + le);
            useDLL = false;
        }
    }

    public static interface IterationSink {
        public void setValue(int var1, Coord var2);
    }

    private static class BigDecimalMandIterator
    extends BigDecimalIterator {
        protected int cnt;
        protected BigDecimal bound = new BigDecimal(10.0);

        public BigDecimalMandIterator(BigDecimal sx, BigDecimal sy, BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
            super(sx, sy, x0, y0, dx, dy, rx, ry, limit);
        }

        private BigDecimalMandIterator(BigDecimal dx, BigDecimal dy) {
            super(b0, b0, b0, b0, dx, dy, 1, 1, 1);
        }

        @Override
        public int iter() {
            ++this.cnt;
            if (this.cnt % 100 == 0) {
                System.out.print(".");
                System.out.flush();
            }
            return this.iter(this.sx, this.sy, this.cx, this.cy, this.bound, this.limit);
        }

        public int iter(BigDecimal sx, BigDecimal sy, BigDecimal cx, BigDecimal cy, BigDecimal bound, int limit) {
            BigDecimal x = sx;
            BigDecimal y = sy;
            BigDecimal x2 = this.mul(x, x);
            BigDecimal y2 = this.mul(y, y);
            int it = 0;
            while (this.add(x2, y2).compareTo(bound) < 0 && ++it <= limit) {
                BigDecimal xn = this.add(this.sub(x2, y2), cx);
                BigDecimal yn = this.add(this.mul(this.mul(MandArith.b2, x), y), cy);
                x = xn;
                x2 = this.mul(x, x);
                y = yn;
                y2 = this.mul(y, y);
            }
            return it;
        }
    }

    public static abstract class BigDecimalIterator
    extends AbstractPixelIterator {
        protected int x;
        protected int y;
        protected BigDecimal sx;
        protected BigDecimal sy;
        protected BigDecimal dx;
        protected BigDecimal dy;
        protected BigDecimal drx;
        protected BigDecimal dry;
        protected BigDecimal x0;
        protected BigDecimal y0;
        protected BigDecimal cx;
        protected BigDecimal cy;

        public BigDecimalIterator(MandelSpec spec) {
            this(new BigDecimal(0), new BigDecimal(0), spec.getXMin(), spec.getYMax(), spec.getDX(), spec.getDY(), spec.getRX(), spec.getRY(), spec.getLimitIt());
        }

        public BigDecimalIterator(BigDecimal sx, BigDecimal sy, BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
            super(rx, ry, limit, dx, dy);
            this.sx = sx;
            this.sy = sy;
            this.dx = dx;
            this.dy = dy;
            this.drx = new BigDecimal(rx);
            this.dry = new BigDecimal(ry);
            this.x0 = x0;
            this.y0 = y0;
        }

        @Override
        public boolean isFast() {
            return false;
        }

        @Override
        public void setX(int x) {
            this.x = x;
            this.cx = this.add(this.x0, this.div(this.mul(this.dx, x), this.drx));
        }

        @Override
        public void setY(int y) {
            this.y = y;
            this.cy = this.sub(this.y0, this.div(this.mul(this.dy, y), this.dry));
        }

        @Override
        public BigDecimal getCX() {
            return this.cx;
        }

        @Override
        public BigDecimal getCY() {
            return this.cy;
        }

        @Override
        public double getX(BigDecimal x) {
            return this.div(this.mul(this.sub(x, this.x0), this.drx), this.dx).doubleValue();
        }

        @Override
        public double getY(BigDecimal y) {
            return this.div(this.mul(this.sub(this.y0, y), this.dry), this.dy).doubleValue();
        }
    }
}

