/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

public class MandRasterFile
implements Closeable {
    private static final int MAPPING_SIZE = 0x40000000;
    private final RandomAccessFile raf;
    private final int width;
    private final int height;
    private final List<MappedByteBuffer> mappings = new ArrayList<MappedByteBuffer>();

    public MandRasterFile(String filename, int width, int height) throws IOException {
        this.raf = new RandomAccessFile(filename, "rw");
        try {
            this.width = width;
            this.height = height;
            long size = 8L * (long)width * (long)height;
            for (long offset = 0L; offset < size; offset += 0x40000000L) {
                long size2 = Math.min(size - offset, 0x40000000L);
                this.mappings.add(this.raf.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, size2));
            }
        }
        catch (IOException e) {
            this.raf.close();
            throw e;
        }
    }

    protected long position(int x, int y) {
        return (long)y * (long)this.width + (long)x;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public double get(int x, int y) {
        assert (x >= 0 && x < this.width);
        assert (y >= 0 && y < this.height);
        long p = this.position(x, y) * 8L;
        int mapN = (int)(p / 0x40000000L);
        int offN = (int)(p % 0x40000000L);
        return this.mappings.get(mapN).getDouble(offN);
    }

    public void set(int x, int y, double d) {
        assert (x >= 0 && x < this.width);
        assert (y >= 0 && y < this.height);
        long p = this.position(x, y) * 8L;
        int mapN = (int)(p / 0x40000000L);
        int offN = (int)(p % 0x40000000L);
        this.mappings.get(mapN).putDouble(offN, d);
    }

    @Override
    public void close() throws IOException {
        for (MappedByteBuffer mapping : this.mappings) {
            this.clean(mapping);
        }
        this.raf.close();
    }

    private void clean(MappedByteBuffer mapping) {
        if (mapping == null) {
            return;
        }
        Cleaner cleaner = ((DirectBuffer)((Object)mapping)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
    }
}

