/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.MandelConstants;
import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.mapping.Mapping;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.util.MandUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;

public class MandelData
extends Command
implements MandelConstants {
    private AbstractFile file;
    private MandelInfo info;
    private Colormap colormap;
    private Mapping mapping;
    private Mapper mapper;
    private MandelRaster raster;
    private BufferedImage image;
    private boolean incomplete;
    private boolean modified;
    private boolean partial;
    private boolean temporary;
    private int origtype;
    private MandelData origdata;

    public MandelData(Colormap cm) {
        this.colormap = cm;
    }

    public MandelData(MandelInfo info) {
        this.info = info;
    }

    public MandelData(MandelInfo info, MandelHeader h, AbstractFile f) {
        this.info = info;
        if (h.getType() != 1) {
            this.origtype = h.getType();
            this.partial = true;
        }
        this.setFile(f);
    }

    public MandelData(MandelData data) {
        this(data.getInfo());
        if (data.getColormap() != null) {
            this.colormap = new Colormap(data.getColormap());
        }
        this.mapping = data.getMapping();
        this.mapper = data.getMapper();
        this.raster = data.getRaster();
        this.file = data.file;
        this.temporary = true;
        this.origdata = data;
    }

    public MandelData(File f) throws IOException {
        this(false, f);
    }

    public MandelData(File f, boolean verbose) throws IOException {
        this(false, f, verbose);
    }

    public MandelData(boolean infoonly, File f) throws IOException {
        this(infoonly, f, true);
    }

    public MandelData(boolean infoonly, File f, boolean verbose) throws IOException {
        this(infoonly, new FileAbstractFile(f), verbose);
    }

    public MandelData(AbstractFile f) throws IOException {
        this(false, f);
    }

    public MandelData(AbstractFile f, boolean verbose) throws IOException {
        this(false, f, verbose);
    }

    public MandelData(boolean infoonly, AbstractFile f) throws IOException {
        this(infoonly, f, true);
    }

    public MandelData(boolean infoonly, AbstractFile f, boolean verbose) throws IOException {
        this.read(infoonly, f, verbose);
        this.file = f;
    }

    public MandelData(AbstractFile f, int requested) throws IOException {
        this(f, requested, true);
    }

    public MandelData(AbstractFile f, int requested, boolean verbose) throws IOException {
        this.read(f, requested, verbose);
        this.file = f;
    }

    public MandelData(InputStream is) throws IOException {
        this(false, is);
    }

    public MandelData(InputStream is, boolean verbose) throws IOException {
        this(false, is, verbose);
    }

    public MandelData(boolean infoonly, InputStream is) throws IOException {
        this(infoonly, is, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MandelData(boolean infoonly, InputStream is, boolean verbose) throws IOException {
        try (DataInputStream dis = MandelData.getDataInputStream(is);){
            this.read(infoonly, dis, verbose);
        }
    }

    public MandelData(InputStream is, int requested) throws IOException {
        this(is, requested, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MandelData(InputStream is, int requested, boolean verbose) throws IOException {
        try (DataInputStream dis = MandelData.getDataInputStream(is);){
            this.read(dis, requested, verbose);
        }
    }

    public boolean needsVersionUpdate() {
        return this.info != null && this.info.needsVersionUpdate() || this.colormap != null && this.colormap.needsVersionUpdate() || this.mapping != null && this.mapping.needsVersionUpdate() || this.mapper != null && this.mapper.needsVersionUpdate() || this.raster != null && this.raster.needsVersionUpdate();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public MandelData getOriginalData() {
        return this.origdata;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public int getType() {
        return (this.info != null ? 1 : 0) | (this.raster != null ? 2 : 0) | (this.colormap != null ? 4 : 0) | (this.mapping != null ? 8 : 0) | (this.mapper != null ? 16 : 0) | (this.image != null ? 32 : 0) | (this.incomplete ? 512 : 0);
    }

    public MandelHeader getHeader() {
        return new MandelHeader(this.getType());
    }

    public MandelHeader getOrigHeader() {
        if (this.origdata != null) {
            return this.origdata.getOrigHeader();
        }
        if (this.isPartial()) {
            return new MandelHeader(this.origtype);
        }
        return this.getHeader();
    }

    public MandelData getOrigData() {
        return this.origdata;
    }

    public String getTypeDesc() {
        return this.getHeader().getTypeDesc();
    }

    public AbstractFile getFile() {
        return this.file;
    }

    public MandelInfo getInfo() {
        return this.info;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public MandelRaster getRaster() {
        return this.raster;
    }

    public void setFile(AbstractFile f) {
        this.file = f;
    }

    public void setColormap(ColormapModel.ResizeMode mode, Colormap colormap) {
        if (this.colormap == colormap) {
            return;
        }
        if (this.mapping != null && colormap != null && this.mapping.getTargetSize() != colormap.getSize()) {
            if (this.mapper == null) {
                if (this.mapping.getTargetSize() > colormap.getSize()) {
                    throw new MandelException("size does not match: " + colormap.getSize() + "!=" + this.mapping.getTargetSize());
                }
                System.out.println("keep smaller mapping " + this.mapping.getTargetSize() + "<" + colormap.getSize());
            } else {
                System.out.println("create new matching mapping " + colormap.getSize() + "<-" + this.mapping.getTargetSize());
                this.updateMapping(mode, colormap.getSize(), colormap, "size does not match and no new mapping creatable: " + colormap.getSize() + "!=" + this.mapping.getTargetSize());
            }
        }
        this.colormap = colormap;
        this.setModified(true);
    }

    public Colormap resizeColormap(ColormapModel.ResizeMode mode, int size) {
        if (this.colormap == null) {
            return null;
        }
        if (this.colormap.getSize() == size) {
            return this.colormap;
        }
        if (this.mapping == null) {
            this.mapping = this._createMapping(this.colormap.getSize());
        }
        if (this.mapping == null) {
            return null;
        }
        this.updateMapping(mode, size, this.colormap, "cannot resize colormap");
        return this.colormap;
    }

    private void updateMapping(ColormapModel.ResizeMode mode) {
        if (this.colormap != null) {
            this.updateMapping(mode, this.colormap.getSize(), this.colormap, "mapping update failed");
        }
    }

    private Mapping _createMapping(int size) {
        System.out.println("create mapping for size " + size);
        return this.mapper.createMapping(this.raster, size);
    }

    private void updateMapping(ColormapModel.ResizeMode mode, int size, Colormap colormap, String errmsg) {
        Mapping nm = this._createMapping(size);
        if (nm == null) {
            throw new MandelException(errmsg);
        }
        System.out.println("got mapping " + nm.getTargetSize());
        Mapping old = this.mapping;
        this.mapping = nm;
        if (size != nm.getTargetSize()) {
            size = nm.getTargetSize();
            System.out.println("mapping requests different colormap size: " + size);
        }
        if (this.mapping.getTargetSize() != colormap.getSize()) {
            ColormapModel m = new ColormapModel(colormap);
            m.setResizeMode(mode);
            if (old == null || old.getTargetSize() != colormap.getSize()) {
                System.out.println("proportional resize raster colormap to " + size);
                m.resize(size);
            } else {
                System.out.println("resize raster colormap to " + size);
                m.resize(size, old, this.mapping);
            }
            colormap = m.getColormap();
            System.out.println("raster colormap resized");
        }
        this.setColormap(mode, colormap);
        this.setModified(true);
    }

    public void setMapping(Mapping mapping) {
        if (this.colormap != null && mapping != null && mapping.getTargetSize() > this.colormap.getSize()) {
            throw new MandelException("target size: " + mapping.getTargetSize() + ">" + this.colormap.getSize());
        }
        if (this.info != null && mapping != null) {
            String msg;
            if (mapping.getMinIt() > this.info.getMinIt()) {
                msg = "min iteration value does not match: " + mapping.getMinIt() + ">" + this.info.getMinIt();
                System.out.println("*** " + msg);
            }
            if (mapping.getMaxIt() != this.info.getMaxIt()) {
                msg = "max iteration value does not match: " + mapping.getMaxIt() + "!=" + this.info.getMaxIt();
                System.out.println("*** " + msg);
            }
        }
        this.mapping = mapping;
        this.setModified(true);
    }

    public void setMapper(ColormapModel.ResizeMode mode, Mapper m) {
        this.mapper = m;
        if (m != null) {
            this.updateMapping(mode);
        }
        this.setModified(true);
    }

    public void createMapping(ColormapModel.ResizeMode mode) {
        if (this.mapper == null) {
            throw new MandelException("cannot create mapping: no mapper set");
        }
        if (this.raster == null) {
            throw new MandelException("cannot create mapping: no raster set");
        }
        if (this.colormap == null) {
            throw new MandelException("cannot create mapping: no colormap set");
        }
        this.updateMapping(mode);
    }

    public void setRaster(MandelRaster raster) {
        if (raster != null) {
            if (this.info.getRX() != raster.getRX()) {
                throw new MandelException("raster size does not match " + raster.getRX() + " != " + this.info.getRX());
            }
            if (this.info.getRY() != raster.getRY()) {
                throw new MandelException("raster size does not match " + raster.getRY() + " != " + this.info.getRY());
            }
        }
        this.raster = raster;
        this.setModified(true);
    }

    public MandelRaster createRaster() {
        if (this.raster == null) {
            this.raster = new MandelRaster(this.info.getRX(), this.info.getRY());
            this.setModified(true);
        }
        return this.raster;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setModified(true);
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, true);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        int flags = this.getType();
        if (verbose) {
            System.out.println("writing mandel (" + flags + ")...");
        }
        dos.writeInt(0x55555555);
        dos.writeInt(flags);
        if (this.info != null) {
            this.info.write(dos);
        }
        if (this.colormap != null) {
            this.colormap.write(dos);
        }
        if (this.mapping != null) {
            this.mapping.write(dos);
        }
        if (this.raster != null) {
            this.raster.write(dos);
        }
        if (this.mapper != null) {
            Mapper.IO.write(this.mapper, dos);
        }
        if (this.image != null) {
            System.out.println("  writing image...");
            ImageIO.write((RenderedImage)this.image, "png", dos);
        }
    }

    public void write(File f) throws IOException {
        this.write(f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f, boolean verbose) throws IOException {
        File backup = null;
        if (f.exists() && !f.isDirectory()) {
            MandelHeader h = this.getHeader();
            if (h.isRaster()) {
                if (this.info.getRasterCreationTime() == 0L) {
                    this.info.setRasterCreationTime(f.lastModified());
                }
            } else if (h.isImage() && this.info.getImageCreationTime() == 0L) {
                this.info.setImageCreationTime(f.lastModified());
            }
            backup = new File(f.getParentFile(), f.getName() + "~");
            f.renameTo(backup);
        }
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
            this.write(dos, verbose);
            if (backup != null) {
                backup.delete();
                backup = null;
            }
        }
        finally {
            if (backup != null) {
                f.delete();
                backup.renameTo(f);
            } else {
                MandelFolder.Util.add(f);
            }
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    public void read(DataInputStream dis, boolean verbose) throws IOException {
        this.read(false, dis, verbose);
    }

    public void read(boolean infoonly, DataInputStream dis) throws IOException {
        this.read(infoonly, dis, true);
    }

    public void read(boolean infoonly, DataInputStream dis, boolean verbose) throws IOException {
        this.read(dis, infoonly ? 1 : 63, verbose);
    }

    public void read(DataInputStream dis, int requested) throws IOException {
        this.read(dis, requested, true);
    }

    public void read(DataInputStream dis, int requested, boolean verbose) throws IOException {
        int magic;
        if (verbose) {
            System.out.println("reading mandel " + requested + "...");
        }
        if ((magic = dis.readInt()) != 0x55555555) {
            throw new IOException("illegal format " + magic + "!=" + 0x55555555);
        }
        this.origtype = dis.readInt();
        int flags = this.origtype;
        this.partial = (flags & 0xFFFFFCFF & ~requested) != 0;
        boolean bl = this.incomplete = (flags & 0x200) != 0;
        if (requested != 0 && (flags & 1) != 0) {
            this.info = new MandelInfo();
            this.info.read(dis, verbose);
            requested &= 0xFFFFFFFE;
        } else {
            this.info = null;
        }
        if (requested != 0 && (flags & 4) != 0) {
            this.colormap = new Colormap(dis, verbose);
            requested &= 0xFFFFFFFB;
        } else {
            this.colormap = null;
        }
        if (requested != 0 && (flags & 8) != 0) {
            this.mapping = new Mapping();
            this.mapping.read(dis, verbose);
            requested &= 0xFFFFFFF7;
        } else {
            this.mapping = null;
        }
        if (requested != 0 && (flags & 2) != 0) {
            this.raster = new MandelRaster();
            this.raster.read(dis, verbose);
            requested &= 0xFFFFFFFD;
        } else {
            this.raster = null;
        }
        if (requested != 0 && (flags & 0x10) != 0) {
            this.mapper = Mapper.IO.read(dis, verbose);
            requested &= 0xFFFFFFEF;
        } else {
            this.mapper = null;
        }
        if (requested != 0 && (flags & 0x20) != 0) {
            if (verbose) {
                System.out.println("  reading image...");
            }
            this.image = ImageIO.read(dis);
            requested &= 0xFFFFFFDF;
        } else {
            this.image = null;
        }
        if (this.info != null && this.info.needsVersionUpdate()) {
            this.info.updateData(this);
        }
    }

    public void read(AbstractFile f) throws IOException {
        this.read(false, f);
    }

    public void read(AbstractFile f, boolean verbose) throws IOException {
        this.read(false, f, verbose);
    }

    public void read(AbstractFile f, int requested) throws IOException {
        this.read(f, requested, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(AbstractFile f, int requested, boolean verbose) throws IOException {
        try (DataInputStream dis = MandelData.getDataInputStream(f.getInputStream());){
            this.read(dis, requested, verbose);
        }
    }

    public void read(boolean infoonly, AbstractFile f) throws IOException {
        this.read(infoonly, f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(boolean infoonly, AbstractFile f, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("reading " + f);
        }
        try (DataInputStream dis = MandelData.getDataInputStream(f.getInputStream());){
            this.read(infoonly, dis, verbose);
        }
    }

    public void write() throws IOException {
        if (this.getFile() == null) {
            throw new IOException("no file set");
        }
        if (this.isPartial()) {
            throw new IOException("partial data");
        }
        if (this.isTemporary()) {
            throw new IOException("temporary data");
        }
        if (!this.getFile().isFile()) {
            throw new IOException("no file");
        }
        this.write(this.getFile().getFile());
        this.setModified(false);
    }

    public void reset() throws IOException {
        if (this.getFile() == null) {
            throw new IOException("no file set");
        }
        this.read(this.getFile());
        this.setModified(false);
    }

    public static void createRoot(File f) throws IOException {
        System.out.println("Creating root data...");
        MandelData md = new MandelData(MandUtils.createRoot());
        md.write(f);
    }

    private static DataInputStream getDataInputStream(InputStream is) {
        if (is instanceof DataInputStream) {
            return (DataInputStream)is;
        }
        if (is instanceof BufferedInputStream) {
            return new DataInputStream(is);
        }
        return new DataInputStream(new BufferedInputStream(is));
    }

    public static void print(String name, MandelData md) {
        System.out.println(md.getTypeDesc() + ": " + name);
        MandelInfo mi = md.getInfo();
        System.out.println("xm    = " + mi.getXM());
        System.out.println("ym    = " + mi.getYM());
        System.out.println("dx    = " + mi.getDX());
        System.out.println("dy    = " + mi.getDY());
        System.out.println("limit = " + mi.getLimitIt());
        System.out.println("rx    = " + mi.getRX());
        System.out.println("ry    = " + mi.getRY());
        if (mi.getMaxIt() > 0) {
            System.out.println("max it= " + mi.getMaxIt());
            System.out.println("min it= " + mi.getMinIt());
            System.out.println("num it= " + mi.getNumIt());
            System.out.println("time  = " + mi.getTime());
        }
        if (mi.getProperties() != null) {
            for (Map.Entry<String, String> e : mi.getProperties().entrySet()) {
                System.out.println(e.getKey() + " = " + e.getValue());
            }
        }
    }

    public static void print(File f) {
        try {
            MandelData md = new MandelData(new FileAbstractFile(f));
            MandelData.print(f.toString(), md);
        }
        catch (IOException io) {
            io.printStackTrace(System.err);
            MandelData.Error("cannot read " + f + ": " + io);
        }
    }

    public static void print(String s) {
        File f = new File(s);
        MandelData.print(f);
    }

    public static void main(String[] args) {
        int c;
        for (c = 0; args.length > c && args[c].charAt(0) == '-'; ++c) {
            block6: for (int i = 1; i < args[c].length(); ++i) {
                char opt = args[c].charAt(i);
                switch (opt) {
                    case 'r': {
                        try {
                            MandelData.createRoot(new File("0.md"));
                        }
                        catch (IOException io) {
                            MandelData.Error("cannot create root: " + io);
                        }
                        continue block6;
                    }
                    default: {
                        MandelData.Error("illegal option '" + opt + "'");
                    }
                }
            }
        }
        while (args.length > c) {
            MandelData.print(args[c++]);
        }
    }

    public static interface Part {
        public boolean needsVersionUpdate();
    }
}

