/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.applet;

import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelAreaImage;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.tool.History;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.mapper.MapperModel;
import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.util.Utils;
import java.awt.Window;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class MandToolStarter
extends JApplet {
    MandelImagePanel panel;

    @Override
    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"datasource", "URL", "a directory containing the config"}, {"showsub", "boolean", "initially show sub areas"}, {"upstreamcolormap", "boolean", "use upstream colormap as default"}, {"tooltipmode", "String", "initial tool tip mode"}};
        return info;
    }

    @Override
    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MandToolStarter.this.createGUI();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGUI didn't successfully complete: " + e);
            e.printStackTrace(System.err);
        }
    }

    private boolean getBooleanParameter(String name, boolean def) {
        String arg = this.getParameter(name);
        if (!Utils.isEmpty(arg)) {
            return arg.toLowerCase().equals("true");
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGUI() {
        try {
            String data = this.getParameter("datasource");
            String tooltipmode = this.getParameter("tooltipmode");
            URL base = this.getDocumentBase();
            boolean showsub = this.getBooleanParameter("showsub", false);
            boolean showtooltip = this.getBooleanParameter("showtooltip", false);
            boolean upstream = this.getBooleanParameter("upstreamcolormap", false);
            System.out.println("document base is " + base);
            System.out.println("data source is   " + data);
            System.out.println("show sub is      " + showsub);
            System.out.println("show tooltip     " + showtooltip);
            System.out.println("upstream is      " + upstream);
            System.out.println("tooltipmode is   " + tooltipmode);
            if (data == null) {
                data = ".";
            }
            URL dataURL = new URL(base, data);
            ToolEnvironment env = new ToolEnvironment(null, dataURL);
            MandelAreaImage img = env.getMandelImage(env.getInitialName());
            this.showStatus("setup done");
            System.out.println("setup done");
            this.setup(env, img, showsub, showtooltip, upstream, tooltipmode);
        }
        catch (MalformedURLException ex) {
            System.out.println("url failed: " + ex);
            this.showStatus("url failed: " + ex);
        }
        catch (IllegalConfigurationException ic) {
            System.out.println("url failed: " + ic);
            this.showStatus("config failed: " + ic);
        }
        catch (IOException io) {
            System.out.println("initial image failed: " + io);
            this.showStatus("initial image failed: " + io);
        }
    }

    @Override
    public void stop() {
        if (this.panel != null) {
            this.panel.cancel();
        }
    }

    public void setup(ToolEnvironment env, MandelAreaImage img, boolean showsub, boolean showtooltip, boolean upstream, String tooltipmode) throws IOException {
        this.panel = new MandelImagePanel(env, img, this.getWidth());
        this.add(this.panel);
        BufferedComponent bc = this.panel.getImagePane();
        bc.setScaleMode(false);
        bc.setLimitWindowSize(false);
        if (showtooltip) {
            this.panel.getPixelToolTipModel().setState(showtooltip);
        }
        if (tooltipmode != null && !this.panel.getToolTipSelectionModel().setSelectedItemId(tooltipmode)) {
            this.showStatus("unknown tooltip mode " + tooltipmode);
            System.out.println("unknown tooltip mode " + tooltipmode);
        }
        if (showsub) {
            this.panel.showSubRects();
        }
        this.panel.getParentColormapModel().setState(upstream);
    }

    public ColormapModel getColormapModel() {
        return this.panel.getColormapModel();
    }

    public ToolEnvironment getEnvironment() {
        return this.panel.getEnvironment();
    }

    public Window getMandelWindow() {
        return null;
    }

    public MandelData getMandelData() {
        return this.panel.getMandelData();
    }

    public MandelImage getMandelImage() {
        return this.panel.getMandelImage();
    }

    public MandelName getMandelName() {
        return this.panel.getMandelName();
    }

    public MapperModel getMapperModel() {
        return this.panel.getMapperModel();
    }

    public QualifiedMandelName getQualifiedName() {
        return this.panel.getQualifiedName();
    }

    public MandelImagePanel getMandelImagePane() {
        return this.panel;
    }

    public History getHistory() {
        return this.panel.getHistory();
    }
}

