/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.calc;

import com.mandelsoft.mand.calc.AreaCalculator;
import com.mandelsoft.mand.calc.CalculationContext;
import com.mandelsoft.mand.meth.PixelIterator;

public class OptimizedAreaCalculator
extends AreaCalculator {
    @Override
    protected void calc(PixelIterator pi, CalculationContext c) {
        int sy = c.getSY();
        int sx = c.getSX();
        int ny = c.getNY();
        int nx = c.getNX();
        this.calcHLine(pi, c, sx, sy, nx);
        this.calcHLine(pi, c, sx, sy + ny - 1, nx);
        this.calcVLine(pi, c, sx, sy + 1, ny - 2);
        int u = this.calcVLine(pi, c, sx + nx - 1, sy + 1, ny - 2);
        this.calcBox(pi, c, u, sx, sy, nx, ny);
    }

    private int calcHLine(PixelIterator pi, CalculationContext c, int sx, int sy, int n) {
        pi.setX(sx);
        pi.setY(sy);
        int u = this.handle(pi, c, sx, sy);
        for (int x = sx + 1; x < sx + n; ++x) {
            pi.setX(x);
            int it = this.handle(pi, c, x, sy);
            if (it == u) continue;
            u = -1;
        }
        return u;
    }

    private int calcVLine(PixelIterator pi, CalculationContext c, int sx, int sy, int n) {
        pi.setX(sx);
        pi.setY(sy);
        int u = this.handle(pi, c, sx, sy);
        for (int y = sy + 1; y < sy + n; ++y) {
            pi.setY(y);
            int it = this.handle(pi, c, sx, y);
            if (it == u) continue;
            u = -1;
        }
        return u;
    }

    private void calcBox(PixelIterator pi, CalculationContext c, int u, int sx, int sy, int nx, int ny) {
        if (nx <= 2 || ny <= 2) {
            return;
        }
        if (u >= 0) {
            u = this.checkHLine(c, u, sx, sy, nx);
            u = this.checkHLine(c, u, sx, sy + ny - 1, nx);
            u = this.checkVLine(c, u, sx, sy + 1, ny - 2);
            if ((u = this.checkVLine(c, u, sx + nx - 1, sy + 1, ny - 2)) >= 0) {
                this.fillBox(c, sx + 1, sy + 1, nx - 2, ny - 2, u);
                return;
            }
        }
        if (nx > ny) {
            int s = (nx - 1) / 2;
            if (s != 0) {
                u = this.calcVLine(pi, c, sx + s, sy + 1, ny - 2);
                this.calcBox(pi, c, u, sx, sy, s + 1, ny);
                this.calcBox(pi, c, u, sx + s, sy, nx - s, ny);
            }
        } else {
            int s = (ny - 1) / 2;
            if (s != 0) {
                u = this.calcHLine(pi, c, sx + 1, sy + s, nx - 2);
                this.calcBox(pi, c, u, sx, sy, nx, s + 1);
                this.calcBox(pi, c, u, sx, sy + s, nx, ny - s);
            }
        }
    }

    private int checkHLine(CalculationContext c, int u, int sx, int sy, int n) {
        if (u >= 0) {
            for (int x = sx; x < sx + n; ++x) {
                if (c.getDataRel(x, sy) == u) continue;
                return -1;
            }
        }
        return u;
    }

    private int checkVLine(CalculationContext c, int u, int sx, int sy, int n) {
        if (u >= 0) {
            for (int y = sy; y < sy + n; ++y) {
                if (c.getDataRel(sx, y) == u) continue;
                return -1;
            }
        }
        return u;
    }

    private void fillBox(CalculationContext c, int sx, int sy, int nx, int ny, int u) {
        for (int y = sy; y < sy + ny; ++y) {
            for (int x = sx; x < sx + nx; ++x) {
                c.setDataRel(x, y, u);
            }
        }
        if (u == 0) {
            c.addMCnt(nx * ny);
        }
    }
}

