/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.image;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.cm.ColormapSource;
import com.mandelsoft.mand.cm.Colormaps;
import com.mandelsoft.mand.image.ImageListener;
import com.mandelsoft.mand.image.PlainImage;
import com.mandelsoft.mand.image.RasterImage;
import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.mapping.Mapping;
import com.mandelsoft.mand.mapping.StatisticMapper;
import com.mandelsoft.util.ChangeListener;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public interface MandelImage {
    public static final boolean debug = false;

    public BufferedImage getImage();

    public MandelInfo getInfo();

    public Colormap getColormap();

    public Mapping getMapping();

    public Mapper getMapper();

    public MandelRaster getRasterData();

    public MandelData getMandelData();

    public MandelImage getMandelImage();

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public void addImageListener(ImageListener var1);

    public void removeImageListener(ImageListener var1);

    public void setColormap(ColormapModel.ResizeMode var1, Colormap var2);

    public void setMapper(ColormapModel.ResizeMode var1, Mapper var2);

    public int getColormapIndex(int var1, int var2);

    public Colormap resizeColormap(ColormapModel.ResizeMode var1, int var2);

    public boolean isModified();

    public static class Factory
    implements ColormapSource {
        private ColormapSource colormapSource;

        public Factory(ColormapSource cms) {
            this.colormapSource = cms;
        }

        public Factory() {
            this(new Colormaps.Simple(255, Color.BLUE, Color.WHITE));
        }

        @Override
        public Colormap getColormap() {
            Colormap cm = null;
            if (this.colormapSource != null) {
                cm = this.colormapSource.getColormap();
            }
            if (cm == null) {
                cm = new Colormaps.Simple(255, Color.BLUE, Color.WHITE);
            }
            return cm;
        }

        public void setColormapSource(ColormapSource colormap) {
            this.colormapSource = colormap;
        }

        protected final Colormap getDefaultColormap(MandelData data, Colormap defcolmap) {
            if (defcolmap != null) {
                return defcolmap;
            }
            return this.getColormap();
        }

        protected Mapper getDefaultMapper(MandelData data) {
            return new StatisticMapper(0.0);
        }

        public MandelImage getImage(File f) throws IOException {
            return this.getImage(new MandelData(f));
        }

        public MandelImage getImage(File f, ColormapModel defcolmap) throws IOException {
            return this.getImage(f, defcolmap.getResizeMode(), (ColormapSource)defcolmap.getColormap());
        }

        public MandelImage getImage(File f, ColormapModel.ResizeMode mode, ColormapSource defcolmap) throws IOException {
            return this.getImage(new MandelData(f), mode, defcolmap);
        }

        public MandelImage getImage(MandelData data) throws IOException {
            return this.getImage(data, ColormapModel.ResizeMode.RESIZE_PROPORTIONAL, null);
        }

        public MandelImage getImage(MandelData data, ColormapSource defcolmap) throws IOException {
            return this.getImage(data, ColormapModel.ResizeMode.RESIZE_PROPORTIONAL, defcolmap);
        }

        public MandelImage getImage(MandelData data, ColormapModel defcolmap) throws IOException {
            return this.getImage(data, defcolmap.getResizeMode(), (ColormapSource)defcolmap.getColormap());
        }

        public MandelImage getImage(MandelData data, ColormapModel.ResizeMode mode, ColormapSource defcolmap) throws IOException {
            return this.getImage(data, mode, defcolmap, null);
        }

        public MandelImage getImage(MandelData data, ColormapModel defcolmap, Mapper defmapper) throws IOException {
            return this.getImage(data, defcolmap.getResizeMode(), defcolmap.getColormap(), defmapper);
        }

        public MandelImage getImage(MandelData data, ColormapModel.ResizeMode mode, ColormapSource defcolmap, Mapper defmapper) throws IOException {
            MandelHeader h = data.getHeader();
            if (h.hasRaster()) {
                try {
                    MandelData d = new MandelData(data);
                    if (!h.hasColormap()) {
                        Colormap cm = defcolmap == null ? null : defcolmap.getColormap();
                        d.setColormap(mode, this.getDefaultColormap(d, cm));
                        data = d;
                    }
                    if (!h.hasMapping()) {
                        if (!h.hasMapper()) {
                            if (defmapper == null) {
                                d.setMapper(mode, this.getDefaultMapper(d));
                                data = d;
                            } else {
                                d.setMapper(mode, defmapper);
                                data = d;
                            }
                        } else {
                            d.createMapping(mode);
                            data = d;
                        }
                    }
                    return new RasterImage(data);
                }
                catch (MandelException ex) {
                    System.out.println("corrupted image " + data.getFile() + ": " + ex);
                    ex.printStackTrace(System.out);
                    throw new IOException("corrupted image " + data.getFile() + ": " + ex, ex);
                }
            }
            if (data.getImage() != null) {
                return new PlainImage(data);
            }
            throw new IOException("no image available");
        }
    }

    public static interface Updatable {
        public void updateRaster();
    }
}

