/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.image;

import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.image.ColorMapper;
import java.awt.Color;

public class RasterColorMapper {
    private ColorMapper mapper;
    private MandelRaster mraster;

    public RasterColorMapper(ColorMapper mapper, MandelRaster mr) {
        if (mr == null) {
            throw new MandelException("no raster set");
        }
        this.mapper = mapper;
        this.mraster = mr;
    }

    public int getColormapIndex(int x, int y) {
        return this.mapper.mapColormapIndex(this.mraster.getData(x, y));
    }

    public Color getPixelColor(int x, int y) {
        return this.mapper.mapIterationValue(this.mraster.getData(x, y));
    }

    public int getPixelRGB(int x, int y) {
        return this.getPixelColor(x, y).getRGB();
    }

    public Object getPixelDataElements(int x, int y) {
        int it = this.mraster.getData(x, y);
        Object de = this.mapper.mapIterationValueToDataElements(it);
        return de;
    }
}

