/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.meth;

import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.meth.AbstractPixelIterator;
import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;

public abstract class AbstractBigDecimalPixelIterator
extends AbstractPixelIterator {
    protected int x;
    protected int y;
    protected BigDecimal sx;
    protected BigDecimal sy;
    protected BigDecimal dx;
    protected BigDecimal dy;
    protected BigDecimal drx;
    protected BigDecimal dry;
    protected BigDecimal x0;
    protected BigDecimal y0;
    protected BigDecimal cx;
    protected BigDecimal cy;

    public AbstractBigDecimalPixelIterator(MandelSpec spec) {
        this(spec.getXMin(), spec.getYMax(), spec.getDX(), spec.getDY(), spec.getRX(), spec.getRY(), spec.getLimitIt());
    }

    public AbstractBigDecimalPixelIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
        super(rx, ry, limit, dx, dy);
        this.dx = dx;
        this.dy = dy;
        this.drx = new BigDecimal(rx);
        this.dry = new BigDecimal(ry);
        this.x0 = x0;
        this.y0 = y0;
    }

    @Override
    public boolean isFast() {
        return false;
    }

    @Override
    public void setX(int x) {
        this.x = x;
        this.cx = MandArith.add(this.x0, MandArith.div(MandArith.mul(this.dx, x), this.drx));
    }

    @Override
    public void setY(int y) {
        this.y = y;
        this.cy = MandArith.sub(this.y0, MandArith.div(MandArith.mul(this.dy, y), this.dry));
    }

    @Override
    public BigDecimal getCX() {
        return this.cx;
    }

    @Override
    public BigDecimal getCY() {
        return this.cy;
    }

    @Override
    public double getX(BigDecimal x) {
        return MandArith.div(MandArith.mul(MandArith.sub(x, this.x0), this.drx), this.dx).doubleValue();
    }

    @Override
    public double getY(BigDecimal y) {
        return MandArith.div(MandArith.mul(MandArith.sub(this.y0, y), this.dry), this.dy).doubleValue();
    }

    public int iter(BigDecimal sx, BigDecimal sy, BigDecimal cx, BigDecimal cy, BigDecimal bound, int limit) {
        BigDecimal x = sx;
        BigDecimal y = sy;
        BigDecimal x2 = this.mul(x, x);
        BigDecimal y2 = this.mul(y, y);
        int it = 0;
        while (this.add(x2, y2).compareTo(bound) < 0 && ++it <= limit) {
            BigDecimal xn = this.add(this.sub(x2, y2), cx);
            BigDecimal yn = this.add(this.mul(this.mul(MandArith.b2, x), y), cy);
            x = xn;
            x2 = this.mul(x, x);
            y = yn;
            y2 = this.mul(y, y);
        }
        return it;
    }
}

