/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.meth;

import com.mandelsoft.mand.meth.AbstractPixelIterator;
import java.math.BigDecimal;

public abstract class AbstractDoublePixelIterator
extends AbstractPixelIterator {
    protected double bound = 10.0;
    protected double dx;
    protected double dy;
    protected double x0;
    protected double y0;
    protected double drx;
    protected double dry;
    protected double cx;
    protected double cy;

    public AbstractDoublePixelIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
        super(rx, ry, limit, dx, dy);
        this.dx = dx.doubleValue();
        this.dy = dy.doubleValue();
        this.x0 = x0.doubleValue();
        this.y0 = y0.doubleValue();
        this.drx = rx;
        this.dry = ry;
    }

    @Override
    public boolean isFast() {
        return true;
    }

    @Override
    public void setX(int x) {
        this.cx = this.x0 + (double)x * this.dx / this.drx;
    }

    @Override
    public void setY(int y) {
        this.cy = this.y0 - (double)y * this.dy / this.dry;
    }

    @Override
    public BigDecimal getCX() {
        return new BigDecimal(this.cx);
    }

    @Override
    public BigDecimal getCY() {
        return new BigDecimal(this.cy);
    }

    @Override
    public double getX(BigDecimal x) {
        double xd = x.doubleValue();
        return (xd - this.x0) * this.drx / this.dx;
    }

    @Override
    public double getY(BigDecimal y) {
        double yd = y.doubleValue();
        return (this.y0 - yd) * this.dry / this.dy;
    }

    protected static int iter(double x, double y, double px, double py, double bound, int limit) {
        double x2 = x * x;
        double y2 = y * y;
        int it = 0;
        while (x2 + y2 < bound && ++it <= limit) {
            double xn = x2 - y2 + px;
            double yn = 2.0 * x * y + py;
            x = xn;
            x2 = x * x;
            y = yn;
            y2 = y * y;
        }
        return it;
    }
}

