/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.meth;

import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.PixelIteratorFactory;
import com.mandelsoft.mand.meth.BigDecimalMandIterator;
import com.mandelsoft.mand.meth.DoubleMandIterator;
import com.mandelsoft.mand.meth.LongDoubleMandIterator;
import com.mandelsoft.mand.meth.OptimizedBigDecimalMandIterator;
import com.mandelsoft.mand.meth.OptimizedLongBigDecimalMandIterator;
import com.mandelsoft.mand.meth.PixelIterator;
import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;
import java.util.Map;

public class DefaultMandIteratorFactory
extends MandArith
implements PixelIteratorFactory {
    private static BigDecimal br = new BigDecimal(5.0E-16, MC);
    private static BigDecimal br2 = new BigDecimal(1.0E-310, MC);
    private boolean optimized;
    private boolean useDLL;

    public DefaultMandIteratorFactory(boolean optimized, boolean useDLL) {
        this.optimized = optimized;
        this.useDLL = useDLL;
    }

    @Override
    public PixelIterator createPixelIterator(MandelInfo mi) {
        return this.createPixelIterator((MandelSpec)mi, mi.getProperties());
    }

    public PixelIterator createPixelIterator(MandelInfo mi, PixelIterator.PropertySource.PropertyHandler h) {
        PixelIterator pi = this.createPixelIterator((MandelSpec)mi, mi.getProperties());
        PixelIterator.setPropertyHandler(pi, h);
        return pi;
    }

    public PixelIterator createPixelIterator(MandelSpec mi, Map<String, String> properties) {
        BigDecimal x0 = mi.getXMin();
        BigDecimal y0 = mi.getYMax();
        BigDecimal dx = mi.getDX();
        BigDecimal dy = mi.getDY();
        int rx = mi.getRX();
        int ry = mi.getRY();
        int limit = mi.getLimitIt();
        if (MandArith.div(dx, (double)rx).compareTo(br) > 0 && MandArith.div(dy, (double)ry).compareTo(br) > 0) {
            System.out.println("double iteration mode");
            return new DoubleMandIterator(x0, y0, dx, dy, rx, ry, limit);
        }
        if (this.optimized) {
            if (MandArith.div(dx, (double)rx).compareTo(br2) > 0 && MandArith.div(dy, (double)ry).compareTo(br2) > 0) {
                System.out.println("optimized iteration mode");
                return new OptimizedBigDecimalMandIterator(x0, y0, dx, dy, rx, ry, limit, properties);
            }
            System.out.println("long optimized iteration mode");
            return new OptimizedLongBigDecimalMandIterator(x0, y0, dx, dy, rx, ry, limit, properties);
        }
        if (this.useDLL) {
            System.out.println("long double iteration mode");
            return new LongDoubleMandIterator(x0, y0, dx, dy, rx, ry, limit);
        }
        System.out.println("big decimal iteration mode");
        return new BigDecimalMandIterator(x0, y0, dx, dy, rx, ry, limit);
    }
}

