/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.movie;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandIter;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.calc.AreaCalculator;
import com.mandelsoft.mand.calc.MandelRasterCalculationContext;
import com.mandelsoft.mand.calc.OptimizedAreaCalculator;
import com.mandelsoft.mand.calc.SimpleAreaCalculator;
import com.mandelsoft.mand.meth.PixelIterator;
import com.mandelsoft.mand.movie.MandelAccess;
import com.mandelsoft.mand.scan.FolderMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.util.MandArith;
import com.mandelsoft.mand.util.MandUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;

public class AreaInterpolation
extends MandArith {
    public static final double zoombase = 0.1;
    static boolean debug = false;
    static final AreaCalculator calc_opt = new OptimizedAreaCalculator();
    static final AreaCalculator calc_simple = new SimpleAreaCalculator();
    private BigDecimal dx;
    private Area top;
    private MandelInfo info;
    private Area bottom;
    private int intercnt;
    private MandelData current;
    private File intermediate_dir;
    private MandelScanner intermediate_scanner;
    private ZoomHandler handler;
    private Area intermediate_start;
    private Area intermediate_end;
    private double intermediate_factor;
    private int intermediate_count;
    private int intermediate_current;
    private BigDecimal end_zoom;
    private BigDecimal threshold;
    private double sdt;
    private double sd;
    private double sda;
    private double limit;
    private MandelName target;
    private MandelScanner scanner;
    private BigDecimal zoom;
    private int count = 0;
    private double total_zoom;
    private double total_frames;

    public AreaInterpolation(MandelName target, Double zoom, MandelScanner scanner, ZoomHandler handler) throws IOException {
        this.setup(target, zoom, scanner, handler);
    }

    private void setup(MandelName target, Double zoom, MandelScanner scanner, ZoomHandler handler) {
        this.target = target;
        this.scanner = scanner;
        this.handler = handler;
        this.zoom = new BigDecimal(zoom);
    }

    public AreaInterpolation(MandelName target, Double zoom, MandelScanner scanner, ZoomHandler handler, double limit, File intermediate) throws IOException {
        this.limit = limit;
        this.intermediate_dir = intermediate;
        if (intermediate != null) {
            this.intermediate_scanner = new FolderMandelScanner(intermediate);
        }
        System.out.println("intermediate " + limit + " (" + this.intermediate_dir + ")");
        this.setup(target, zoom, scanner, handler);
    }

    public void check() throws IOException {
        MandelHandle h = this.scanner.getMandelInfo(MandelName.ROOT);
        if (h == null) {
            throw new IOException("no root area found");
        }
        MandelData start = h.getInfo();
        h = this.scanner.getMandelInfo(this.target);
        if (h == null) {
            throw new IOException("target area not found");
        }
        MandelData end = h.getInfo();
        this.end_zoom = end.getInfo().getDX();
        this.threshold = this.sdt > 0.0 ? AreaInterpolation.div(this.end_zoom, this.sdt) : BigDecimal.ZERO;
        this.total_zoom = AreaInterpolation.div(end.getInfo().getDX(), start.getInfo().getDX()).doubleValue();
        this.total_frames = Math.log(this.total_zoom) / Math.log(this.zoom.doubleValue());
    }

    public void setSlowDownThreshold(double sdt) {
        this.sdt = sdt;
    }

    public void setFinalSpeedFactor(double sd) {
        this.sd = sd;
    }

    public double getTotalFrames() {
        return this.total_frames;
    }

    public double getTotalZoom() {
        return this.total_zoom;
    }

    private boolean isIntermediateRoot() {
        return this.intermediate_end != null;
    }

    private void finishIntermediate() {
        this.intermediate_end = null;
    }

    private boolean continueWithNextSubArea(Area next) throws IOException {
        System.out.println("start next interpolation root " + next.getName());
        this.top = next;
        this.intercnt = 0;
        this.info = new MandelInfo(this.top.getInfo());
        this.bottom = this.createIntermediate();
        if (this.bottom != null) {
            System.out.println("next sub is " + this.bottom.getName());
            return true;
        }
        if (this.isIntermediateRoot()) {
            System.out.println("reuse intermediate target area " + this.intermediate_end.getName() + " as next sub area for " + next.getName());
            this.bottom = this.intermediate_end;
            this.finishIntermediate();
            return true;
        }
        System.out.println("next original main area is " + next.getName());
        if (next.getMandelName().equals(this.target)) {
            this.bottom = null;
            System.out.println("target reached");
            return false;
        }
        MandelName n = next.getMandelName().sub(this.target);
        QualifiedMandelName qn = new QualifiedMandelName(n, "adjust");
        MandelHandle h = this.scanner.getMandelData(qn);
        if (h == null) {
            qn = new QualifiedMandelName(n, "zoom");
            h = this.scanner.getMandelData(qn);
        }
        if (h == null) {
            qn = new QualifiedMandelName(n);
            h = this.scanner.getMandelData(n);
        }
        if (h == null) {
            throw new IOException("cannot find " + n);
        }
        this.bottom = new Area(qn, new MandelAccess(h.getData()));
        double z = AreaInterpolation.div(this.bottom.getInfo().getDX(), this.info.getDX()).doubleValue();
        if (z < this.limit) {
            next = this.bottom;
            double num = Math.ceil(Math.log(z) / Math.log(this.limit));
            System.out.println("requires " + (int)(num - 1.0) + " intermedite zooms to meet limit of " + this.limit);
            double t = Math.pow(z, 1.0 / num);
            this.intermediate_start = this.top;
            this.intermediate_end = this.bottom;
            this.intermediate_factor = t;
            this.intermediate_count = (int)num - 1;
            this.intermediate_current = 0;
            this.bottom = this.createIntermediate();
        }
        return true;
    }

    private Area createIntermediate() {
        MandelHandle h;
        if (this.intermediate_current == this.intermediate_count) {
            return null;
        }
        ++this.intermediate_current;
        String label = "zoom-" + this.intermediate_start.getMandelName().sub(this.target).getSubAreaName() + "-" + this.intermediate_current;
        QualifiedMandelName iname = new QualifiedMandelName(this.intermediate_start.getMandelName(), label);
        BigDecimal dx = AreaInterpolation.mul(this.info.getDX(), this.intermediate_factor);
        MandelData md = this.createZoom(this.intermediate_start.getInfo(), this.intermediate_end.getInfo(), dx);
        if (this.intermediate_scanner != null && (h = this.intermediate_scanner.getMandelData(iname)) != null) {
            try {
                MandelData me = h.getData();
                if (me.getInfo().getDX().equals(md.getInfo().getDX())) {
                    System.out.println("reusing intermediate " + iname + "...");
                    return new Area(iname, new MandelAccess(me));
                }
                System.out.println("existing intermediate " + iname + " does not match: dx " + me.getInfo().getDX() + " differs from expected " + md.getInfo().getDX());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("calculating intermediate " + iname + "...");
        this.calc(md, null, calc_opt);
        if (this.intermediate_dir != null) {
            System.out.println("saving " + iname);
            md.getInfo().setLocation("intermediate zoom " + iname + " for interpolation limit " + this.limit);
            AreaInterpolation.save(this.intermediate_dir, iname, md);
        }
        return new Area(iname, new MandelAccess(md));
    }

    private void calc(MandelData md, PixelIterator pi, AreaCalculator calc) {
        MandelRasterCalculationContext ctx = new MandelRasterCalculationContext(md.getInfo());
        if (pi != null) {
            ctx.setPixelIterator(pi);
        }
        calc.calc(ctx);
        ctx.setInfoTo(md.getInfo());
        md.getInfo().setRasterCreationTime(System.currentTimeMillis());
        md.setRaster(ctx.getRaster());
    }

    private MandelData createZoom(MandelInfo start, MandelInfo end, BigDecimal dx) {
        MandelSpec spec = new MandelSpec(start.getSpec());
        BigDecimal f = AreaInterpolation.div(AreaInterpolation.sub(dx, start.getDX()), AreaInterpolation.sub(end.getDX(), start.getDX()));
        spec.setXM(this.approach(start.getXM(), end.getXM(), f));
        spec.setYM(this.approach(start.getYM(), end.getYM(), f));
        spec.setDX(dx);
        spec.setDY(AreaInterpolation.div(AreaInterpolation.mul(dx, start.getRY()), (double)start.getRX()));
        spec.setLimitIt(Math.max(start.getLimitIt(), end.getLimitIt()));
        MandelInfo next = new MandelInfo(spec, start);
        MandUtils.round(next);
        return new MandelData(next);
    }

    private boolean prepareNext() throws IOException {
        System.out.println("using zoom factor " + this.zoom);
        this.dx = AreaInterpolation.mul(this.dx, this.zoom);
        if (this.dx.compareTo(this.threshold) < 0) {
            BigDecimal next;
            if (this.sda == 0.0) {
                SlowDown s = new SlowDown(this.zoom.doubleValue(), AreaInterpolation.div(this.end_zoom, this.dx).doubleValue(), this.sd);
                s.print("starting slow down");
                this.sda = s.sda;
            }
            if ((next = AreaInterpolation.div(this.zoom, this.sda)).compareTo(BigDecimal.ONE) < 0) {
                this.zoom = next;
            } else {
                System.out.println("stop slow down");
            }
        }
        while (this.dx.compareTo(this.bottom.getInfo().getDX()) <= 0) {
            if (this.continueWithNextSubArea(this.bottom)) continue;
            return false;
        }
        this.current = this.createZoom(this.info, this.bottom.getInfo(), this.dx);
        ++this.intercnt;
        return true;
    }

    private BigDecimal approach(BigDecimal s, BigDecimal d, BigDecimal f) {
        return AreaInterpolation.add(s, AreaInterpolation.mul(AreaInterpolation.sub(d, s), f));
    }

    public MandelName getTarget() {
        return this.target;
    }

    public MandelName getTopAreaName() {
        return this.top.getMandelName();
    }

    public QualifiedMandelName getTopName() {
        return this.top.getName();
    }

    public MandelAccess getTopAccess() {
        return this.top.getAccess();
    }

    public MandelAccess getBottomAccess() {
        if (this.bottom == null) {
            return null;
        }
        return this.bottom.getAccess();
    }

    public int getInterpolationCount() {
        return this.intercnt;
    }

    public MandelData getCurrent() {
        return this.current;
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasNext() {
        return this.top == null || !this.top.getMandelName().equals(this.target);
    }

    public MandelData getNext() throws IOException {
        if (!this.hasNext()) {
            return null;
        }
        if (this.top == null) {
            MandelHandle h = this.scanner.getMandelData(MandelName.ROOT);
            Area root = new Area(QualifiedMandelName.ROOT, new MandelAccess(h.getData()));
            this.continueWithNextSubArea(root);
            this.dx = this.info.getDX();
            this.current = this.top.getMandelData();
        } else if (!this.prepareNext()) {
            this.current = this.top.getMandelData();
        } else {
            Interpolator i = new Interpolator(this.current.getInfo());
            if (this.handler != null) {
                if (this.handler.isSimulate()) {
                    return this.current;
                }
                MandelData md = this.handler.getNext(this);
                if (md != null) {
                    this.current = md;
                }
            }
            if (this.current.getRaster() == null) {
                System.out.println("interpolating " + this.top.getName() + "(" + this.intercnt + ") ...");
                this.calc(this.current, i, calc_simple);
                this.current.getInfo().setLocation("interpolation " + this.intercnt + " for " + this.top.getName());
            }
        }
        ++this.count;
        return this.current;
    }

    public static void print(int cnt, AreaInterpolation i) {
        MandelInfo info = i.getCurrent().getInfo();
        System.out.println("" + cnt + ": " + i.getTopName() + "(" + i.getInterpolationCount() + "); " + i.getTopAccess().getInfo().getXM() + " -> " + (i.getBottomAccess() == null ? "end" : i.getBottomAccess().getInfo().getXM()) + " = " + info.getXM() + " (" + info.getDX() + ")");
    }

    public static void save(File dir, MandelName n, MandelData md) {
        AreaInterpolation.save(dir, new QualifiedMandelName(n), md);
    }

    public static void save(File dir, QualifiedMandelName n, MandelData md) {
        File file = new File(dir, n.toString() + ".mr");
        try {
            System.out.println("writing " + file);
            md.write(file);
        }
        catch (IOException ex) {
            System.out.println("cannot write " + file + ": " + ex);
        }
    }

    public static double getDoubleArg(String arg, String name) {
        double d = 0.0;
        try {
            d = Double.valueOf(arg);
        }
        catch (NumberFormatException nfe) {
            Command.Error("double value as " + name + " expected");
        }
        return d;
    }

    public static void main(String[] args) {
        double fpz;
        int c = 0;
        double fps = 25.0;
        double speed = 0.0;
        double limit = 0.5;
        double zpf = 0.0;
        double sd = 0.1;
        double sdt = 0.1;
        MandelName target = null;
        File dbroot = new File(".");
        File dir = new File("movies");
        boolean vflag = false;
        boolean iflag = false;
        if (args.length == 0) {
            System.out.println("interpolation sequence [<options>] <target area>");
            System.out.println("  -i           show info only");
            System.out.println("  -v           verbose/simulate only");
            System.out.println("  -s <speed>   time per zoom factor 0.1");
            System.out.println("     -f <fps>  frames per second");
            System.out.println("  -z <zpf>     zoom per frame");
            System.out.println("  -n           no intermediate area calculation");
            System.out.println("  -l <limit>   interpolation limit (default " + limit + ")");
            System.out.println("  -r <dbroot>  image database (default " + dbroot + ")");
            System.out.println("  -d <dir>     target root folder (default " + dir + ")");
            System.exit(0);
        }
        while (args.length > c && args[c].charAt(0) == '-') {
            String arg = args[c++];
            block17: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'v': {
                        vflag = true;
                        continue block17;
                    }
                    case 'i': {
                        iflag = true;
                        continue block17;
                    }
                    case 'n': {
                        limit = 0.0;
                        continue block17;
                    }
                    case 'f': {
                        if (args.length > c) {
                            fps = AreaInterpolation.getDoubleArg(args[c++], "frames per seconds");
                            continue block17;
                        }
                        Command.Error("frames per second missing");
                        continue block17;
                    }
                    case 's': {
                        if (zpf != 0.0) {
                            Command.Error("only zoom or speed");
                        }
                        if (args.length > c) {
                            speed = AreaInterpolation.getDoubleArg(args[c++], "seconds per zoom");
                            continue block17;
                        }
                        Command.Error("seconds per zoom missing");
                        continue block17;
                    }
                    case 'z': {
                        if (speed != 0.0) {
                            Command.Error("only zoom or speed");
                        }
                        if (args.length > c) {
                            zpf = AreaInterpolation.getDoubleArg(args[c++], "zoom factor");
                            continue block17;
                        }
                        Command.Error("zoom factor missing");
                        continue block17;
                    }
                    case 'l': {
                        if (args.length > c) {
                            limit = AreaInterpolation.getDoubleArg(args[c++], "limit");
                            continue block17;
                        }
                        Command.Error("interpolation limit missing");
                        continue block17;
                    }
                    case 'r': {
                        if (args.length > c) {
                            if ((dbroot = new File(args[c++])).isDirectory()) continue block17;
                            Command.Error("root does not exist");
                            continue block17;
                        }
                        Command.Error("root folder missing");
                        continue block17;
                    }
                    case 'd': {
                        if (args.length > c) {
                            dir = new File(args[c++]);
                            continue block17;
                        }
                        Command.Error("target folder missing");
                        continue block17;
                    }
                    default: {
                        Command.Error("illegal option '" + opt + "'");
                    }
                }
            }
        }
        if (args.length <= c) {
            Command.Error("target area missing");
        }
        try {
            target = MandelName.create(args[c++]);
        }
        catch (IllegalArgumentException iae) {
            Command.Error("illegal area name " + args[c - 1]);
        }
        if (speed != 0.0) {
            fpz = speed * fps;
            zpf = Math.pow(0.1, 1.0 / fpz);
        } else {
            if (zpf == 0.0) {
                zpf = 0.98;
            }
            fpz = Math.log(0.1) / Math.log(zpf);
            speed = fpz / fps;
        }
        try {
            Environment env = new Environment("interpol", args, dbroot);
            dir = new File(dir, target.getName());
            File intermediate = new File(dir, "intermediate");
            intermediate.mkdirs();
            Handler handler = new Handler(vflag, dir);
            AreaInterpolation i = new AreaInterpolation(target, zpf, env.getImageDataScanner(), handler, limit, intermediate);
            i.setFinalSpeedFactor(sd);
            i.setSlowDownThreshold(sdt);
            i.check();
            double time = i.getTotalFrames() / fps;
            System.out.println("target area:                         " + target);
            System.out.println("target folder:                       " + dir);
            System.out.println("interpolation limit:                 " + limit);
            System.out.println("frame rate (frames per second):      " + fps);
            System.out.println("zoom per frame:                      " + zpf + " (" + 1.0 / fpz + ")");
            System.out.println("speed (seconds per zoom factor 0.1): " + speed);
            System.out.println("speed (frames per zoom factor 0.1):  " + fpz);
            System.out.println("total zoom:                          " + i.getTotalZoom());
            System.out.println("total frames:                        " + i.getTotalFrames());
            System.out.println("total movie length (seconds):        " + time);
            if (sdt > 0.0) {
                SlowDown s = new SlowDown(zpf, sdt, sd);
                s.print("slow down mode info");
            }
            if (!iflag) {
                System.out.println("starting interpolation...............");
                int cnt = 0;
                while (i.getNext() != null) {
                    AreaInterpolation.print(cnt++, i);
                    handler.save(i);
                    handler.prepareNext();
                }
            }
        }
        catch (IOException io) {
            System.out.println("illegal intrpolation: " + io);
        }
        catch (IllegalConfigurationException ex) {
            System.out.println("illegal configuration: " + ex);
        }
    }

    public static class Area {
        private QualifiedMandelName name;
        private MandelAccess access;

        public Area(QualifiedMandelName name, MandelAccess access) {
            this.name = name;
            this.access = access;
        }

        public MandelAccess getAccess() {
            return this.access;
        }

        public QualifiedMandelName getName() {
            return this.name;
        }

        public MandelName getMandelName() {
            return this.name.getMandelName();
        }

        public MandelData getMandelData() {
            return this.access.getMandelData();
        }

        public MandelInfo getInfo() {
            return this.access.getInfo();
        }

        public int getIter() {
            return this.access.getIter();
        }

        public void setY(BigDecimal y) {
            this.access.setY(y);
        }

        public void setX(BigDecimal x) {
            this.access.setX(x);
        }

        public double getY(BigDecimal y) {
            return this.access.getY(y);
        }

        public double getX(BigDecimal x) {
            return this.access.getX(x);
        }

        public boolean containsY(BigDecimal y) {
            return this.access.containsY(y);
        }

        public boolean containsX(BigDecimal x) {
            return this.access.containsX(x);
        }

        public boolean contains(BigDecimal x, BigDecimal y) {
            return this.access.contains(x, y);
        }
    }

    public static class ZoomHandler {
        private boolean simulate;
        private MandelScanner scanner;
        private MandelName next;
        private boolean matched;

        public ZoomHandler(boolean simulate, MandelScanner scanner) {
            this.simulate = simulate;
            this.scanner = scanner;
        }

        public boolean hasMatched() {
            return this.matched;
        }

        public boolean isSimulate() {
            return this.simulate;
        }

        public void setNext(MandelName next) {
            this.next = next;
            this.matched = false;
        }

        public MandelName getNext() {
            return this.next;
        }

        public MandelScanner getScanner() {
            return this.scanner;
        }

        public MandelData getNext(AreaInterpolation i) {
            if (this.next == null || this.scanner == null) {
                return null;
            }
            MandelHandle h = this.scanner.getMandelData(this.next);
            if (h == null) {
                return null;
            }
            try {
                MandelData md = h.getData();
                if (md != null) {
                    if (i.getCurrent().getInfo().getDX().equals(md.getInfo().getDX())) {
                        System.out.println("found " + this.getNext());
                        this.matched = true;
                    } else {
                        System.out.println("found " + this.getNext() + " does not match current zoom");
                        md = null;
                    }
                }
                return md;
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    public static class SlowDown {
        public double sdt;
        public double sd;
        public double z1;
        public double v1;
        public double ve;
        public double a;
        public double t;
        public double c;
        public double orig;
        public double sda;

        public SlowDown(double zpf, double sdt, double sd) {
            this.sdt = sdt;
            this.sd = sd;
            this.z1 = Math.log(sdt) / Math.log(0.1);
            this.v1 = Math.log(zpf) / Math.log(0.1);
            this.ve = sd * this.v1;
            this.a = this.v1 * this.v1 * (1.0 - sd * sd) / 2.0 / this.z1;
            this.t = 2.0 * this.z1 / this.v1 / (1.0 + sd);
            this.orig = Math.log(sdt) / Math.log(zpf);
            this.sda = Math.pow(0.1, this.a);
            this.c = Math.pow(0.1, Math.sqrt(this.a));
        }

        public void print(String msg) {
            System.out.println("*** " + msg);
            System.out.println("slow down threashold:                " + this.sdt + " (" + this.z1 + ")");
            System.out.println("zoom speed:                          " + this.v1);
            System.out.println("final speed:                         " + this.ve);
            System.out.println("a:                                   " + this.a);
            System.out.println("slow down factor:                    " + 1.0 / this.sda);
            System.out.println("correction factor:                   " + this.c);
            System.out.println("number of frames:                    " + this.t);
            System.out.println("number of original frames:           " + this.orig);
            System.out.println("additional frames:                   " + (this.t - this.orig));
        }
    }

    private class Interpolator
    implements PixelIterator {
        private PixelIterator pi;
        private int limit;
        private BigDecimal cx;
        private BigDecimal cy;
        private boolean subx;
        private boolean suby;
        private int x;
        private int y;

        public Interpolator(MandelSpec spec) {
            this.pi = MandIter.createPixelIterator(spec);
            this.limit = spec.getLimitIt() + 1;
            if (debug) {
                System.out.println(" start: x=" + spec.getXMin() + "<->" + spec.getXMax());
                System.out.println("        y=" + spec.getYMin() + "<->" + spec.getYMax());
                System.out.println("  main: x=" + AreaInterpolation.this.info.getXMin() + "<->" + AreaInterpolation.this.info.getXMax());
                System.out.println("        y=" + AreaInterpolation.this.info.getYMin() + "<->" + AreaInterpolation.this.info.getYMax());
                System.out.println("   sub: x=" + AreaInterpolation.this.bottom.getInfo().getXMin() + "<->" + AreaInterpolation.this.bottom.getInfo().getXMax());
                System.out.println("        y=" + AreaInterpolation.this.bottom.getInfo().getYMin() + "<->" + AreaInterpolation.this.bottom.getInfo().getYMax());
            }
        }

        @Override
        public int iter() {
            int it;
            if (this.subx && this.suby) {
                it = AreaInterpolation.this.bottom.getIter();
                if (it > AreaInterpolation.this.bottom.getInfo().getLimitIt()) {
                    it = this.limit;
                }
            } else {
                it = AreaInterpolation.this.top.getIter();
                if (it > AreaInterpolation.this.top.getInfo().getLimitIt()) {
                    it = this.limit;
                }
            }
            return it;
        }

        @Override
        public void setY(int y) {
            this.pi.setY(y);
            this.cy = this.pi.getCY();
            AreaInterpolation.this.top.setY(this.cy);
            AreaInterpolation.this.bottom.setY(this.cy);
            this.suby = AreaInterpolation.this.bottom.containsY(this.cy);
            this.x = this.x;
            this.y = y;
        }

        @Override
        public void setX(int x) {
            this.pi.setX(x);
            this.cx = this.pi.getCX();
            AreaInterpolation.this.top.setX(this.cx);
            AreaInterpolation.this.bottom.setX(this.cx);
            this.subx = AreaInterpolation.this.bottom.containsX(this.cx);
        }

        @Override
        public BigDecimal getCY() {
            return this.cy;
        }

        @Override
        public BigDecimal getCX() {
            return this.cx;
        }

        @Override
        public boolean isFast() {
            return this.pi.isFast();
        }

        @Override
        public double getY(BigDecimal y) {
            return this.pi.getY(y);
        }

        @Override
        public double getX(BigDecimal x) {
            return this.pi.getX(x);
        }

        @Override
        public int getPrecision() {
            return this.pi.getPrecision();
        }

        @Override
        public int getMagnification() {
            return this.pi.getMagnification();
        }
    }

    private static class Handler
    extends ZoomHandler {
        private MandelName name = MandelName.ROOT;
        private MandelName last;
        private File dir;

        public Handler(boolean simulate, File dir) throws IOException {
            super(simulate, new FolderMandelScanner(dir));
            this.setNext(this.name);
            this.dir = dir;
        }

        public void prepareNext() {
            this.last = this.name;
            this.name = this.name.sub('z');
            this.setNext(this.name);
        }

        public MandelName getLast() {
            return this.last;
        }

        public void save(AreaInterpolation i) {
            if (!this.isSimulate() && !this.hasMatched()) {
                AreaInterpolation.save(this.dir, this.getNext(), i.getCurrent());
            }
        }
    }
}

