/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.movie;

import com.mandelsoft.mand.movie.MovieDecoration;
import java.awt.Graphics;

public abstract class FadedMovieDecoration
implements MovieDecoration {
    public static final boolean debug = false;
    private long start;
    private long fadein;
    private long show;
    private long fadeout;
    private long end;

    public FadedMovieDecoration(long start, long fadein, long show, long fadeout) {
        this.start = start;
        this.fadein = fadein;
        this.show = show;
        this.fadeout = fadeout;
        this.setup();
    }

    protected void setup() {
        this.end = this.show == Long.MAX_VALUE ? Long.MAX_VALUE : this.start + this.fadein + this.show + this.fadeout;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public long getFadeInTime() {
        return this.fadein;
    }

    public long getFadeOutTime() {
        return this.fadeout;
    }

    public long getShowTime() {
        return this.show;
    }

    public void setFadeInTime(long fadein) {
        this.fadein = fadein;
        this.setup();
    }

    public void setFadeOutTime(long fadeout) {
        this.fadeout = fadeout;
        this.setup();
    }

    public void setShowTime(long show) {
        this.show = show;
        this.setup();
    }

    public void setStart(long start) {
        this.start = start;
        this.setup();
    }

    protected abstract boolean decoValid();

    @Override
    public boolean isActive(long time) {
        if (time >= this.start && time < this.end) {
            return this.decoValid();
        }
        return false;
    }

    @Override
    public void paintDecoration(long time, Graphics g, int w, int h) {
        if (this.isActive(time)) {
            this.prepareDecoration(time);
            this.decoPaint(g, w, h);
        }
    }

    protected abstract void decoPaint(Graphics var1, int var2, int var3);

    private void prepareDecoration(long time) {
        int alpha = time < this.start + this.fadein ? (int)((time - this.start) * 256L / this.fadein) : (this.end == Long.MAX_VALUE || time < this.start + this.fadein + this.show ? 255 : 255 - (int)((time - (this.start + this.fadein + this.show)) * 256L / this.fadeout));
        this.decoSetAlpha(alpha);
    }

    protected abstract void decoSetAlpha(int var1);
}

