/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelImageDB;
import com.mandelsoft.mand.MandelImageDBContext;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.CompoundMandelScannerSupport;
import com.mandelsoft.mand.scan.ContextMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.scan.MappedMandelScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributedMandelScanner
extends CompoundMandelScannerSupport
implements ContextMandelScanner {
    private MandelImageDBContext root;
    private MandelScanner scanner;
    private Map<MandelImageDB, MandelScanner> nested;
    private Map<String, List<MandelScanner>> scanners;
    private ScannerAccess access;

    public DistributedMandelScanner(MandelImageDBContext ctx, ScannerAccess acc2) {
        this.root = ctx;
        this.access = acc2;
        this.scanner = this.access.getScanner(ctx.getDatabase());
        if (this.scanner != null) {
            this.addScanner(this.scanner);
        }
        this.nested = new HashMap<MandelImageDB, MandelScanner>();
        this.scanners = new HashMap<String, List<MandelScanner>>();
        for (MandelImageDBContext.ContextMapping m : this.root.mappings()) {
            MandelImageDBContext sctx = m.getContext();
            MandelImageDB sdb = sctx.getDatabase();
            MandelScanner s = this.access.getScanner(sdb);
            if (s == null) continue;
            s = new MappedMandelScanner(s, ctx.getContextMapping(sctx));
            this.nested.put(sdb, s);
            this.addScanner(s);
        }
        for (MandelImageDBContext.ContextMapping m : this.root.mappings()) {
            String label = m.getLabel();
            MandelImageDBContext sub = m.getContext();
            ArrayList<MandelScanner> subs = new ArrayList<MandelScanner>();
            if (this.scanner != null) {
                subs.add(this.scanner);
            }
            for (MandelImageDBContext c : sub.containers()) {
                MandelScanner s;
                if (sub == ctx || (s = this.nested.get(sub.getDatabase())) == null) continue;
                subs.add(s);
            }
            this.scanners.put(label, subs);
        }
    }

    @Override
    protected Set<MandelHandle> _getMandelHandles(MandelName name) {
        String label = name.getLabel();
        if (label == null) {
            Set<MandelHandle> set = this.scanner.getMandelHandles(name);
            if (name.isRoot()) {
                for (String l : this.scanners.keySet()) {
                    this.add(set, this._getMandelHandles((Collection<MandelScanner>)this.scanners.get(l), MandelName.ROOT));
                }
            }
            return set;
        }
        return this._getMandelHandles((Collection<MandelScanner>)this.scanners.get(label), name);
    }

    @Override
    protected Set<ColormapHandle> _getColormapHandles(ColormapName name) {
        String label = name.getLabel();
        if (label == null) {
            return this.scanner.getColormapHandles(name);
        }
        return this._getColormapHandles((Collection<MandelScanner>)this.scanners.get(label), name);
    }

    @Override
    public MandelHandle getMandelData(MandelName name) {
        String label = name.getLabel();
        if (label == null) {
            MandelHandle h = this.scanner.getMandelData(name);
            if (h == null && name.isRoot()) {
                String l;
                Iterator<String> iterator = this.scanners.keySet().iterator();
                while (iterator.hasNext() && (h = this._getMandelData((Collection<MandelScanner>)this.scanners.get(l = iterator.next()), MandelName.ROOT)) == null) {
                }
            }
            return h;
        }
        return this._getMandelData((Collection<MandelScanner>)this.scanners.get(label), name);
    }

    @Override
    public MandelHandle getMandelData(QualifiedMandelName name) {
        String label = name.getLabel();
        if (label == null) {
            MandelHandle h = this.scanner.getMandelData(name);
            if (h == null && name.isRoot()) {
                String l;
                Iterator<String> iterator = this.scanners.keySet().iterator();
                while (iterator.hasNext() && (h = this._getMandelData((Collection<MandelScanner>)this.scanners.get(l = iterator.next()), QualifiedMandelName.ROOT)) == null) {
                }
            }
            return h;
        }
        return this._getMandelData((Collection<MandelScanner>)this.scanners.get(label), name);
    }

    @Override
    public MandelHandle getMandelHandle(QualifiedMandelName name) {
        String label = name.getLabel();
        if (label == null) {
            MandelHandle h = this.scanner.getMandelHandle(name);
            if (h == null && name.isRoot()) {
                String l;
                Iterator<String> iterator = this.scanners.keySet().iterator();
                while (iterator.hasNext() && (h = this._getMandelHandle((Collection<MandelScanner>)this.scanners.get(l = iterator.next()), QualifiedMandelName.ROOT)) == null) {
                }
            }
            return h;
        }
        return this._getMandelHandle((Collection<MandelScanner>)this.scanners.get(label), name);
    }

    @Override
    public synchronized Set<MandelHandle> getMandelHandles(MandelName name) {
        return this._getMandelHandles(name);
    }

    @Override
    public Set<MandelHandle> getMandelHandles(QualifiedMandelName name) {
        return super.getMandelHandles(name);
    }

    @Override
    public MandelHandle getMandelInfo(MandelName name) {
        String label = name.getLabel();
        if (label == null) {
            MandelHandle h = this.scanner.getMandelInfo(name);
            if (h == null && name.isRoot()) {
                String l;
                Iterator<String> iterator = this.scanners.keySet().iterator();
                while (iterator.hasNext() && (h = this._getMandelInfo((Collection<MandelScanner>)this.scanners.get(l = iterator.next()), MandelName.ROOT)) == null) {
                }
            }
            return h;
        }
        return this._getMandelInfo((Collection<MandelScanner>)this.scanners.get(label), name);
    }

    @Override
    public MandelHandle getMandelInfo(QualifiedMandelName name) {
        String label = name.getLabel();
        if (label == null) {
            MandelHandle h = this.scanner.getMandelInfo(name);
            if (h == null && name.isRoot()) {
                String l;
                Iterator<String> iterator = this.scanners.keySet().iterator();
                while (iterator.hasNext() && (h = this._getMandelInfo((Collection<MandelScanner>)this.scanners.get(l = iterator.next()), QualifiedMandelName.ROOT)) == null) {
                }
            }
            return h;
        }
        return this._getMandelInfo((Collection<MandelScanner>)this.scanners.get(label), name);
    }

    @Override
    public synchronized Set<ColormapHandle> getColormapHandles(ColormapName name) {
        String label = name.getLabel();
        if (label == null) {
            return this.scanner.getColormapHandles(name);
        }
        MandelImageDBContext ctx = this.root.getContext(label);
        if (ctx != null) {
            return this.nested.get(ctx.getDatabase()).getColormapHandles(name);
        }
        return new HashSet<ColormapHandle>();
    }

    @Override
    public synchronized boolean hasColormap(ColormapName name) {
        String label = name.getLabel();
        if (label == null) {
            return this.scanner.hasColormap(name);
        }
        MandelImageDBContext ctx = this.root.getContext(label);
        if (ctx != null) {
            return this.nested.get(ctx.getDatabase()).hasColormap(name);
        }
        return false;
    }

    @Override
    public MandelImageDBContext getContext() {
        return this.root;
    }

    @Override
    public Set<MandelName> getSubNames(MandelName n) {
        return MandelScannerUtils.getSubNames(n, this.root, this);
    }

    @Override
    public Set<MandelName> getSubNames(MandelName n, MandelScanner.Filter f) {
        return MandelScannerUtils.getSubNames(n, this.root, this, f);
    }

    @Override
    public boolean hasSubNames(MandelName n) {
        return MandelScannerUtils.hasSubNames(n, this.root, this);
    }

    @Override
    public boolean hasSubNames(MandelName n, MandelScanner.Filter f) {
        return MandelScannerUtils.hasSubNames(n, this.root, (MandelScanner)this, f);
    }

    public static interface ScannerAccess {
        public MandelScanner getScanner(MandelImageDB var1);
    }
}

