/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.MandelConstants;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class MandelInventory
implements MandelConstants,
Iterable<Entry> {
    private static final int MAGIC = 7745944;
    protected HashMap<String, Entry> cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream is, String src) throws IOException {
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(is));){
            this.read(dis, src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream os, String dest) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));){
            this.write(dos, dest);
        }
    }

    public boolean remove(String name) {
        return this.cache.remove(name) != null;
    }

    public Entry get(String name) {
        return this.cache.get(name);
    }

    public Entry add(String filename, MandelData md, long modified) {
        MandelHeader h = md.getOrigHeader();
        return this.add(filename, h.getType(), md.getInfo(), modified);
    }

    public Entry add(String filename, int flags, MandelInfo info, long lm) {
        Entry e = new Entry(filename, flags, info, lm);
        this.cache.put(filename, e);
        return e;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.cache.values().iterator();
    }

    private void read(DataInputStream dis, String msg) throws IOException {
        System.out.println("reading cache ... (" + msg + ")");
        int magic = dis.readInt();
        if (magic != 7745944) {
            throw new IOException("illegal format " + magic + "!=" + 7745944);
        }
        while (true) {
            int flags;
            MandelInfo info = null;
            try {
                flags = dis.readInt();
            }
            catch (EOFException eof) {
                dis.close();
                return;
            }
            String filename = dis.readUTF();
            long lm = dis.readLong();
            if ((flags & 0x100) == 0 && (flags & 1) != 0) {
                info = new MandelInfo();
                info.read(dis, false);
            }
            this.cache.put(filename, new Entry(filename, flags, info, lm));
        }
    }

    private void write(DataOutputStream dos, String msg) throws IOException {
        System.out.println("writing cache ...(" + msg + ")");
        dos.writeInt(7745944);
        for (Entry e : this) {
            if (e.info == null && (e.flags & 1) != 0) {
                e.flags |= 256;
            }
            dos.writeInt(e.flags);
            dos.writeUTF(e.filename);
            dos.writeLong(e.getLastModified());
            if ((e.flags & 1) == 0 || (e.flags & 0x100) != 0) continue;
            e.info.write(dos, false);
        }
        System.out.println("done.");
    }

    public static class Entry {
        private String filename;
        private int flags;
        private MandelInfo info;
        private long lastmod;

        public Entry(String filename, int flags, MandelInfo info, long lm) {
            this.filename = filename;
            this.flags = flags;
            this.info = info;
            this.lastmod = lm;
        }

        public String getFilename() {
            return this.filename;
        }

        public MandelInfo getInfo() {
            return this.info;
        }

        public int getType() {
            return this.flags & 0xFFFFFCFF;
        }

        public int getCacheType() {
            return this.flags & 0x300;
        }

        public long getLastModified() {
            return this.lastmod;
        }
    }
}

