/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelImageDBContext;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MandelScannerUtils {
    public static MandelData getMandelData(MandelScanner s, MandelName n) {
        return MandelScannerUtils.getMandelData(s.getMandelData(n));
    }

    public static MandelData getMandelData(MandelHandle h) {
        if (h != null) {
            try {
                return h.getData();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static MandelData getMandelInfo(MandelScanner s, MandelName n) {
        return MandelScannerUtils.getMandelInfo(s.getMandelInfo(n));
    }

    public static MandelData getMandelInfo(MandelHandle h) {
        if (h != null) {
            try {
                return h.getInfo();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isInfo(MandelHandle h) {
        return h != null && h.getHeader().isInfo();
    }

    public static boolean isInfo(Set<MandelHandle> set) {
        if (set.isEmpty()) {
            return false;
        }
        for (MandelHandle h : set) {
            if (h.getHeader().isInfo()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasImageData(Set<MandelHandle> set) {
        for (MandelHandle h : set) {
            if (!h.getHeader().hasImageData()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAreaColormap(Set<MandelHandle> set) {
        for (MandelHandle h : set) {
            if (!h.getHeader().isAreaColormap()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNone(Set<MandelHandle> set, MandelScanner.Filter f) {
        for (MandelHandle h : set) {
            if (!f.filter(h.getHeader())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAtLeastOne(Set<MandelHandle> set, MandelScanner.Filter f) {
        for (MandelHandle h : set) {
            if (!f.filter(h.getHeader())) continue;
            return true;
        }
        return false;
    }

    public static Colormap getColormap(MandelScanner s, ColormapName n) {
        return MandelScannerUtils.getColormap(s.getColormap(n));
    }

    public static Colormap getColormap(ColormapHandle h) {
        if (h != null) {
            try {
                return h.getColormap();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void addSubNames(Set<MandelName> set, String label, MandelName n, MandelScanner scan, MandelScanner.Filter f) {
        for (MandelName s = n.subAt(label); s != null; s = s.next()) {
            Set<MandelHandle> subs = scan.getMandelHandles(s);
            if (subs.isEmpty() || f != null && !MandelScannerUtils.hasAtLeastOne(subs, f)) continue;
            set.add(s);
        }
    }

    public static Set<MandelName> getSubNames(MandelName n, MandelImageDBContext ctx, MandelScanner scan) {
        return MandelScannerUtils.getSubNames(n, ctx, scan, null);
    }

    public static Set<MandelName> getSubNames(MandelName n, MandelImageDBContext ctx, MandelScanner scan, MandelScanner.Filter f) {
        HashSet<MandelName> set;
        block2: {
            block3: {
                set = new HashSet<MandelName>();
                MandelScannerUtils.addSubNames(set, n.getLabel(), n, scan, f);
                if (ctx == null) break block2;
                if (!n.isRoot()) break block3;
                for (MandelImageDBContext.ContextMapping m : ctx.mappings()) {
                    MandelScannerUtils.addSubNames(set, m.getLabel(), n, scan, f);
                }
                break block2;
            }
            if (!n.isRemoteName()) break block2;
            MandelImageDBContext.ContextMapping sub = ctx.getContextMapping(n.getLabel());
            for (MandelImageDBContext subctx : sub.getContext().containers()) {
                MandelScannerUtils.addSubNames(set, ctx.getLabel(subctx), n, scan, f);
            }
        }
        return set;
    }

    private static boolean hasSubNames(String label, MandelName n, MandelScanner scan, MandelScanner.Filter f) {
        for (MandelName s = n.subAt(label); s != null; s = s.next()) {
            Set<MandelHandle> set = scan.getMandelHandles(s);
            if (set.isEmpty() || f != null && !MandelScannerUtils.hasAtLeastOne(set, f)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSubNames(MandelName n, MandelImageDBContext ctx, MandelScanner scan) {
        return MandelScannerUtils.hasSubNames(n, ctx, scan, null);
    }

    public static boolean hasSubNames(MandelName n, MandelImageDBContext ctx, MandelScanner scan, MandelScanner.Filter f) {
        block3: {
            block4: {
                if (MandelScannerUtils.hasSubNames(n.getLabel(), n, scan, f)) {
                    return true;
                }
                if (ctx == null) break block3;
                if (!n.isRoot()) break block4;
                for (MandelImageDBContext.ContextMapping m : ctx.mappings()) {
                    if (!MandelScannerUtils.hasSubNames(m.getLabel(), n, scan, f)) continue;
                    return true;
                }
                break block3;
            }
            if (!n.isRemoteName()) break block3;
            MandelImageDBContext.ContextMapping sub = ctx.getContextMapping(n.getLabel());
            for (MandelImageDBContext subctx : sub.getContext().containers()) {
                if (!MandelScannerUtils.hasSubNames(ctx.getLabel(subctx), n, scan, f)) continue;
                return true;
            }
        }
        return false;
    }
}

