/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.ElementNameMapper;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerProxy;
import com.mandelsoft.mand.scan.ProxyColormapHandle;
import com.mandelsoft.mand.scan.ProxyMandelHandle;
import java.util.HashSet;
import java.util.Set;

public class MappedMandelScanner
extends MandelScannerProxy {
    private ElementNameMapper mapper;

    public MappedMandelScanner(MandelScanner s, ElementNameMapper mapper) {
        super(s);
        this.mapper = mapper;
    }

    @Override
    protected MandelHandle mapOut(MandelHandle h) {
        QualifiedMandelName n = this.mapper.mapOut((QualifiedMandelName)h.getName());
        if (n == h.getName()) {
            return h;
        }
        return new ProxyMandelHandle(h, n);
    }

    @Override
    protected ColormapHandle mapOut(ColormapHandle h) {
        ColormapName n = this.mapper.mapOut((ColormapName)h.getName());
        if (n == h.getName()) {
            return h;
        }
        return new ProxyColormapHandle(h, n);
    }

    private Set<MandelHandle> mapOutMH(Set<MandelHandle> set) {
        HashSet<MandelHandle> nset = new HashSet<MandelHandle>();
        boolean mapped = false;
        for (MandelHandle h : set) {
            MandelHandle n = this.mapOut(h);
            nset.add(n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    private Set<QualifiedMandelName> mapOutQN(Set<QualifiedMandelName> set) {
        HashSet<QualifiedMandelName> nset = new HashSet<QualifiedMandelName>();
        boolean mapped = false;
        for (QualifiedMandelName h : set) {
            QualifiedMandelName n = this.mapper.mapOut(h);
            nset.add(n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    private Set<MandelName> mapOutMN(Set<MandelName> set) {
        HashSet<MandelName> nset = new HashSet<MandelName>();
        boolean mapped = false;
        for (MandelName h : set) {
            MandelName n = this.mapper.mapOut(h);
            nset.add(n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    private Set<ColormapHandle> mapOutC(Set<ColormapHandle> set) {
        HashSet<ColormapHandle> nset = new HashSet<ColormapHandle>();
        boolean mapped = false;
        for (ColormapHandle h : set) {
            ColormapHandle n = this.mapOut(h);
            nset.add(n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    private Set<ColormapName> mapOutCN(Set<ColormapName> set) {
        HashSet<ColormapName> nset = new HashSet<ColormapName>();
        boolean mapped = false;
        for (ColormapName h : set) {
            ColormapName n = this.mapper.mapOut(h);
            nset.add(n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    @Override
    public Set<ElementHandle<?>> getAllHandles() {
        HashSet<MandelHandle> nset = new HashSet<MandelHandle>();
        Set<ElementHandle<?>> set = super.getAllHandles();
        boolean mapped = false;
        for (ElementHandle<?> h : set) {
            ElementHandle<QualifiedMandelName> n = h instanceof MandelHandle ? this.mapOut((MandelHandle)h) : this.mapOut((ColormapHandle)h);
            nset.add((MandelHandle)n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    @Override
    public Set<MandelHandle> getMandelHandles() {
        return this.mapOutMH(super.getMandelHandles());
    }

    @Override
    public Set<QualifiedMandelName> getQualifiedMandelNames(MandelName name) {
        return this.mapOutQN(super.getQualifiedMandelNames(this.mapper.mapIn(name)));
    }

    @Override
    public Set<QualifiedMandelName> getQualifiedMandelNames() {
        return this.mapOutQN(super.getQualifiedMandelNames());
    }

    @Override
    public Set<MandelName> getMandelNames() {
        return this.mapOutMN(super.getMandelNames());
    }

    @Override
    public Set<MandelHandle> getMandelHandles(QualifiedMandelName name) {
        return this.mapOutMH(super.getMandelHandles(this.mapper.mapIn(name)));
    }

    @Override
    public Set<MandelHandle> getMandelHandles(MandelName name) {
        return this.mapOutMH(super.getMandelHandles(this.mapper.mapIn(name)));
    }

    @Override
    public MandelHandle getMandelHandle(QualifiedMandelName name) {
        return this.mapOut(super.getMandelHandle(this.mapper.mapIn(name)));
    }

    @Override
    public MandelHandle getMandelInfo(QualifiedMandelName name) {
        return this.mapOut(super.getMandelInfo(this.mapper.mapIn(name)));
    }

    @Override
    public MandelHandle getMandelInfo(MandelName name) {
        return this.mapOut(super.getMandelInfo(this.mapper.mapIn(name)));
    }

    @Override
    public MandelHandle getMandelData(QualifiedMandelName name) {
        return this.mapOut(super.getMandelData(this.mapper.mapIn(name)));
    }

    @Override
    public MandelHandle getMandelData(MandelName name) {
        return this.mapOut(super.getMandelData(this.mapper.mapIn(name)));
    }

    @Override
    public synchronized Set<ColormapName> getColormapNames() {
        return this.mapOutCN(super.getColormapNames());
    }

    @Override
    public boolean hasColormap(ColormapName name) {
        return super.hasColormap(this.mapper.mapIn(name));
    }

    @Override
    public Set<ColormapHandle> getColormapHandles(ColormapName name) {
        return this.mapOutC(super.getColormapHandles(this.mapper.mapIn(name)));
    }

    @Override
    public ColormapHandle getColormap(ColormapName name) {
        return this.mapOut(super.getColormap(this.mapper.mapIn(name)));
    }
}

