/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv.tcp;

import com.mandelsoft.mand.srv.ImageData;
import com.mandelsoft.mand.srv.tcp.ClientData;
import com.mandelsoft.mand.srv.tcp.ServerData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ServerInfo {
    public static final int VERSION = 1;
    private ServerData server;
    private List<ClientData> clients;
    private List<ImageData> images;
    private int weight;
    private int timeout;

    public ServerInfo() {
        this.server = new ServerData();
    }

    public ServerInfo(ServerData server) {
        this.server = server;
    }

    protected synchronized void setWeight(int w) {
        this.weight = w;
    }

    protected synchronized void setTimeout(int t) {
        this.timeout = t;
    }

    protected synchronized void addClientData(ClientData c) {
        if (this.clients == null) {
            this.clients = new ArrayList<ClientData>();
        }
        this.clients.add(c);
    }

    protected synchronized void addImageData(ImageData i) {
        if (this.images == null) {
            this.images = new ArrayList<ImageData>();
        }
        this.images.add(i);
    }

    public synchronized ServerData getServer() {
        return this.server;
    }

    public Collection<ClientData> getClients() {
        if (this.clients == null) {
            return new ArrayList<ClientData>();
        }
        return Collections.unmodifiableCollection(this.clients);
    }

    public Collection<ImageData> getActiveImages() {
        if (this.images == null) {
            return new ArrayList<ImageData>();
        }
        return Collections.unmodifiableCollection(this.images);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getWeight() {
        return this.weight;
    }

    protected synchronized void addRequest(ClientData client) {
        this.server.addRequest(client);
    }

    protected synchronized void addConnection(ClientData client) {
        this.server.addConnection(client);
    }

    public synchronized void write(DataOutputStream dos) throws IOException {
        this.write(dos, 1);
    }

    public synchronized void write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown host info version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        this.server.write(dos);
        dos.writeInt(this.weight);
        dos.writeInt(this.timeout);
        if (this.clients == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.clients.size());
            for (ClientData clientData : this.clients) {
                clientData.write(dos);
            }
        }
        if (this.images == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.images.size());
            for (ImageData imageData : this.images) {
                imageData.write(dos);
            }
        }
    }

    public void read(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        switch (version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown host data version " + version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        Object c;
        this.server.read(dis);
        this.weight = dis.readInt();
        this.timeout = dis.readInt();
        int n = dis.readInt();
        if (n == 0) {
            this.clients = null;
        } else {
            if (this.clients != null) {
                this.clients.clear();
            }
            while (n-- > 0) {
                c = new ClientData(dis);
                this.addClientData((ClientData)c);
            }
        }
        n = dis.readInt();
        if (n == 0) {
            this.images = null;
        } else {
            if (this.images != null) {
                this.images.clear();
            }
            while (n-- > 0) {
                c = new ImageData(dis);
                this.addImageData((ImageData)c);
            }
        }
    }
}

