/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Statistic {
    public static final int VERSION = 1;
    private long totcon;
    private long concnt;
    private long lastcon;
    private long reqcnt;
    private long lastreq;
    private long pending;
    private long lastcontact;
    private long timeouts;
    private long lasttimeout;
    private long errors;
    private long lasterror;

    protected synchronized void addConnection() {
        ++this.concnt;
        ++this.totcon;
        this.lastcon = this.notifyContact();
    }

    protected synchronized void removeConnection() {
        --this.concnt;
    }

    protected synchronized void addRequest() {
        ++this.reqcnt;
        ++this.pending;
        this.lastreq = this.notifyContact();
    }

    protected synchronized void addTimeout() {
        --this.pending;
        ++this.timeouts;
        this.lasttimeout = System.currentTimeMillis();
    }

    protected synchronized void requestDone() {
        --this.pending;
        this.notifyContact();
    }

    protected synchronized void addError() {
        ++this.errors;
        this.lasterror = System.currentTimeMillis();
    }

    protected synchronized long notifyContact() {
        this.lastcontact = System.currentTimeMillis();
        return this.lastcontact;
    }

    public synchronized long getTotalConCnt() {
        return this.totcon;
    }

    public synchronized long getConCnt() {
        return this.concnt;
    }

    public synchronized long getLastConnected() {
        return this.lastcon;
    }

    public synchronized long getPending() {
        return this.pending;
    }

    public synchronized long getRequestCnt() {
        return this.reqcnt;
    }

    public synchronized long getLastRequest() {
        return this.lastreq;
    }

    public synchronized long getTimeouts() {
        return this.timeouts;
    }

    public synchronized long getLastTimeout() {
        return this.lasttimeout;
    }

    public synchronized long getErrors() {
        return this.errors;
    }

    public synchronized long getLastError() {
        return this.lasterror;
    }

    public synchronized long getLastContact() {
        return this.lastcontact;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, 1);
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown host info version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        dos.writeLong(this.totcon);
        dos.writeLong(this.concnt);
        dos.writeLong(this.lastcon);
        dos.writeLong(this.reqcnt);
        dos.writeLong(this.lastreq);
        dos.writeLong(this.pending);
        dos.writeLong(this.lastcontact);
        dos.writeLong(this.timeouts);
        dos.writeLong(this.lasttimeout);
        dos.writeLong(this.errors);
        dos.writeLong(this.lasterror);
    }

    public void read(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        switch (version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown host data version " + version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        this.totcon = dis.readLong();
        this.concnt = dis.readLong();
        this.lastcon = dis.readLong();
        this.reqcnt = dis.readLong();
        this.lastreq = dis.readLong();
        this.pending = dis.readLong();
        this.lastcontact = dis.readLong();
        this.timeouts = dis.readLong();
        this.lasttimeout = dis.readLong();
        this.errors = dis.readLong();
        this.lasterror = dis.readLong();
    }
}

