/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.tool.History;
import com.mandelsoft.mand.tool.MandelAreaCreationDialog;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.mapper.MapperModel;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.swing.IntegerField;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InitialStartupFrame
extends JFrame
implements MandelWindowAccess {
    private ToolEnvironment env;
    private MandelAreaCreationDialog create;
    private JLabel screensize;
    private JButton setimagesize;
    private IntegerField sizex;
    private IntegerField sizey;
    private JTextField rootfolder;

    public InitialStartupFrame(ToolEnvironment env) {
        this.env = env;
        this.setTitle("Control Panel");
        ControlPanel p = new ControlPanel();
        this.add(p);
        this.pack();
        this.setResizable(false);
        this.create = new MandelAreaCreationDialog(this, "Mandel Area Creation");
    }

    @Override
    public JFrame getMandelWindow() {
        return this;
    }

    @Override
    public ToolEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public MandelName getMandelName() {
        QualifiedMandelName n = this.getQualifiedName();
        return n == null ? null : n.getMandelName();
    }

    @Override
    public QualifiedMandelName getQualifiedName() {
        return this.getEnvironment().getInitialName();
    }

    @Override
    public MandelData getMandelData() {
        MandelName name = this.getMandelName();
        if (name != null) {
            MandelHandle h = this.getEnvironment().getMetaScanner().getMandelData(name);
            try {
                return h.getData();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public MandelImage getMandelImage() {
        return null;
    }

    @Override
    public MapperModel getMapperModel() {
        return null;
    }

    @Override
    public ColormapModel getColormapModel() {
        return null;
    }

    @Override
    public MandelImagePanel getMandelImagePane() {
        return null;
    }

    @Override
    public History getHistory() {
        return null;
    }

    public Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public void setScreenSize() {
        Dimension d = this.getScreenSize();
        this.screensize.setText("" + (int)d.getWidth() + "x" + (int)d.getHeight());
    }

    protected ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        ImageIcon im = new ImageIcon(imgURL);
        return im;
    }

    public static void main(String[] args) {
        try {
            ToolEnvironment env = new ToolEnvironment(args);
            env.startup();
        }
        catch (IllegalConfigurationException ex) {
            System.out.println("failed: " + ex);
        }
    }

    private class ControlPanel
    extends GBCPanel {
        ControlPanel() {
            int row = 0;
            this.add((Component)new JLabel("Default Root Image Size"), this.GBC(3, row).setSpanW(3).setInsets(0, 10, 10, 10));
            this.add((Component)new JLabel("Screen size"), this.GBC(0, ++row).setSpanH(2).setRightInset(10));
            this.add((Component)(InitialStartupFrame.this.screensize = new JLabel("")), this.GBC(1, row).setSpanH(2));
            InitialStartupFrame.this.setScreenSize();
            this.add((Component)(InitialStartupFrame.this.setimagesize = new JButton(InitialStartupFrame.this.createImageIcon("/com/mandelsoft/mand/resc/rightarrow.gif"))), this.GBC(2, row).setSpanH(2).setInsets(10));
            InitialStartupFrame.this.setimagesize.setFocusable(false);
            InitialStartupFrame.this.setimagesize.setIconTextGap(0);
            InitialStartupFrame.this.setimagesize.setHorizontalAlignment(0);
            InitialStartupFrame.this.setimagesize.setMargin(new Insets(0, 0, 0, 0));
            InitialStartupFrame.this.setimagesize.addActionListener(new ActionListener(){
                final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$1.setDefaultSize();
                }
            });
            this.add((Component)new JLabel("Width"), this.GBC(3, row).setRightInset(10));
            this.add((Component)new JLabel("Height"), this.GBC(3, row + 1).setRightInset(10));
            this.add((Component)(InitialStartupFrame.this.sizex = new IntegerField()), this.GBC(4, row).setSpanW(2));
            this.add((Component)(InitialStartupFrame.this.sizey = new IntegerField()), this.GBC(4, row + 1).setSpanW(2));
            InitialStartupFrame.this.sizex.setColumns(10);
            InitialStartupFrame.this.sizey.setColumns(10);
            this.add((Component)new JLabel(""), this.GBC(4, row).setWeight(200.0, 0.0));
            this.setDefaultSize();
            this.addBorder(3, (row += 2) - 3, 3, 3, false);
            this.add((Component)(InitialStartupFrame.this.rootfolder = new JTextField()), this.GBC(0, row).setSpanW(5).setFill(2).setInsets(10, 0, 0, 0).setWeight(200.0, 0.0));
            InitialStartupFrame.this.rootfolder.setText(InitialStartupFrame.this.env.getProperty("path.info.save"));
            JButton b = new JButton("select");
            this.add((Component)b, this.GBC(5, row).setInsets(10, 0, 0, 0));
            b.setMargin(new Insets(0, 0, 0, 0));
            b.addActionListener(new FileChooserAction());
            JPanel buttons = new JPanel();
            this.add((Component)buttons, this.GBC(0, ++row).setSpanW(6));
            b = new JButton("Rescan");
            b.setToolTipText("Rescan the file system");
            b.addActionListener(new RescanAction());
            buttons.add(b);
            b = new JButton("Load");
            b.addActionListener(new LoadAction());
            buttons.add(b);
            b = new JButton("Create root");
            b.addActionListener(new CreateRootAction());
            buttons.add(b);
            b = new JButton("AdjustX");
            b.addActionListener(new AdjustXAction());
            b.setToolTipText("Adjust image size according to proportion of the screen");
            buttons.add(b);
            b = new JButton("AdjustY");
            b.setToolTipText("Adjust image size according to proportion of the screen");
            b.addActionListener(new AdjustYAction());
            buttons.add(b);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        public void setDefaultSize() {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            InitialStartupFrame.this.sizex.setValue(d.getWidth());
            InitialStartupFrame.this.sizey.setValue(d.getHeight());
        }

        private class FileChooserAction
        implements ActionListener {
            private FileChooserAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File f;
                JFileChooser c = InitialStartupFrame.this.env.getFileChooser();
                String cur = InitialStartupFrame.this.rootfolder.getText();
                if (cur == null || cur.equals("")) {
                    cur = ".";
                }
                if ((f = new File(cur)).isDirectory()) {
                    c.setCurrentDirectory(f);
                } else {
                    c.setSelectedFile(f);
                }
                c.setFileSelectionMode(2);
                int result = c.showDialog(InitialStartupFrame.this, "select");
                if (result == 0) {
                    InitialStartupFrame.this.rootfolder.setText(c.getSelectedFile().getPath());
                }
            }
        }

        private class RescanAction
        implements ActionListener {
            private RescanAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                InitialStartupFrame.this.env.rescan();
            }
        }

        private class LoadAction
        implements ActionListener {
            private LoadAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String n = InitialStartupFrame.this.rootfolder.getText();
                try {
                    if (Utils.isEmpty(n)) {
                        MandelName mn = MandelName.ROOT;
                        InitialStartupFrame.this.env.createMandelImageFrame(mn);
                    } else {
                        InitialStartupFrame.this.env.createMandelImageFrame(n);
                    }
                }
                catch (IOException ex) {
                    ControlPanel.this.Error("Cannot show image", ex.toString());
                }
            }
        }

        private class CreateRootAction
        implements ActionListener {
            private CreateRootAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(InitialStartupFrame.this.rootfolder.getText())) {
                    return;
                }
                File f = new File(InitialStartupFrame.this.rootfolder.getText());
                if (f.isDirectory()) {
                    f = new File(f, "0.md");
                } else {
                    if (!f.getParentFile().isDirectory()) {
                        ControlPanel.this.Error("Root Creation", f.getParentFile() + " is no directory.");
                        return;
                    }
                    String n = f.getName();
                    if (MandelName.isMandelName(n)) {
                        n = n + ".md";
                        f = new File(f.getParentFile(), n);
                    }
                }
                MandelInfo info = MandUtils.createRoot();
                Dimension d = new Dimension(InitialStartupFrame.this.sizex.getValue().intValue(), InitialStartupFrame.this.sizey.getValue().intValue());
                System.out.println("root dimension " + d);
                MandUtils.adjustMandelInfo(info, d);
                System.out.println("root dimension " + info.getRX() + "x" + info.getRY());
                InitialStartupFrame.this.create.setInfo("Mandel Root", info);
                InitialStartupFrame.this.create.setFilename(f.getPath());
                InitialStartupFrame.this.create.setVisible(true);
            }
        }

        private class AdjustXAction
        implements ActionListener {
            private AdjustXAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension d = InitialStartupFrame.this.getScreenSize();
                InitialStartupFrame.this.sizex.setValue(d.getWidth() / d.getHeight() * InitialStartupFrame.this.sizey.getValue().doubleValue());
            }
        }

        private class AdjustYAction
        implements ActionListener {
            private AdjustYAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension d = InitialStartupFrame.this.getScreenSize();
                InitialStartupFrame.this.sizey.setValue(d.getHeight() / d.getWidth() * InitialStartupFrame.this.sizex.getValue().doubleValue());
            }
        }
    }
}

