/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.swing.BufferedComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class JuliaDialog
extends MandelDialog {
    private BufferedComponent bc;
    private BufferedImage image;
    private JPanel panel;
    private Colormap colormap;
    private double BOUND = 10.0;
    private double jx;
    private double jy;
    private double xm;
    private double ym;
    private double dx;
    private double dy;
    private int rx;
    private int ry;
    private double x0;
    private double y0;
    private int limit;
    private double drx;
    private double dry;

    public JuliaDialog(MandelWindowAccess frame, int w, int h) {
        super(frame);
        this.setTitle("Julia Test");
        this.panel = new JuliaPanel();
        this.image = new BufferedImage(w, h, 1);
        this.panel.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        this.add(this.panel);
        this.pack();
        this.setResizable(true);
    }

    public void update(double x, double y) {
        this.colormap = this.getMandelWindowAccess().getMandelImage().getColormap();
        this.jx = x;
        this.jy = y;
        this.updateImage();
    }

    private void updateImage() {
        this.setupContext();
        this.calc();
        this.repaint();
    }

    private void setupContext() {
        this.xm = 0.0;
        this.ym = 0.0;
        this.dx = 4.5;
        this.limit = 30000;
        this.rx = this.image.getWidth();
        this.ry = this.image.getHeight();
        this.dy = this.dx * (double)this.ry / (double)this.rx;
        this.drx = this.rx;
        this.dry = this.ry;
        this.x0 = this.xm - this.dx / 2.0;
        this.y0 = this.ym + this.dy / 2.0;
    }

    private void calc() {
        for (int y = 0; y < this.ry; ++y) {
            double cy = this.y0 - (double)y * this.dy / this.dry;
            for (int x = 0; x < this.rx; ++x) {
                double cx = this.x0 + (double)x * this.dx / this.drx;
                int i = this.iter(cx, cy, this.jx, this.jy);
                this.image.setRGB(x, y, this.colormap.getColor(this.map(i)).getRGB());
            }
        }
    }

    private int map(int i) {
        if (i > this.limit) {
            return 0;
        }
        return 1 + i % (this.colormap.getSize() - 1);
    }

    private int iter(double x, double y, double px, double py) {
        double x2 = x * x;
        double y2 = y * y;
        int it = 0;
        while (x2 + y2 < this.BOUND && ++it <= this.limit) {
            double xn = x2 - y2 + px;
            double yn = 2.0 * x * y + py;
            x = xn;
            x2 = x * x;
            y = yn;
            y2 = y * y;
        }
        return it;
    }

    private class JuliaPanel
    extends JPanel {
        private JuliaPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle r = this.getVisibleRect();
            if (r.getWidth() != (double)JuliaDialog.this.image.getWidth() || r.getHeight() != (double)JuliaDialog.this.image.getHeight()) {
                JuliaDialog.this.image = new BufferedImage((int)r.getWidth(), (int)r.getHeight(), 1);
                JuliaDialog.this.updateImage();
            }
            g.drawImage(JuliaDialog.this.image, 0, 0, null);
        }
    }
}

