/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.DefaultMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.LinkListener;
import com.mandelsoft.mand.tool.MandelListModel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.util.DefaultMandelList;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.util.HashList;
import java.util.HashSet;
import java.util.Set;

public class LinkFolderTreeModel
extends DefaultMandelListFolderTreeModel {
    private boolean mod;
    private Set<LinkListener> llisteners = new HashSet<LinkListener>();

    public LinkFolderTreeModel(MandelListFolderTree tree, MandelScanner all, boolean readonly) {
        super(tree, all);
        this.setModifiable(false);
        this.mod = !readonly;
    }

    @Override
    protected boolean isListModifiable(MandelListFolder f) {
        return this.mod;
    }

    public Set<MandelName> getLinkSources() {
        HashSet<MandelName> set = new HashSet<MandelName>();
        for (MandelListFolder f : this.getRoot()) {
            MandelName mn = MandelName.create(f.getName());
            if (mn == null) continue;
            set.add(mn);
        }
        return null;
    }

    public MandelListFolder getLinkFolder(MandelName n) {
        return this.getChild(this.getRoot(), n.getName());
    }

    public MandelList getLinks(MandelName n) {
        MandelListFolder f = this.getLinkFolder(n);
        if (f == null) {
            return new DefaultMandelList();
        }
        return f.getMandelList();
    }

    public MandelList getLinkClosure(MandelName n) {
        DefaultMandelList list = new DefaultMandelList();
        HashList<MandelName> pending = new HashList<MandelName>();
        HashSet<MandelName> closure = new HashSet<MandelName>();
        closure.add(n);
        pending.add(n);
        while (!pending.isEmpty()) {
            MandelName next = (MandelName)pending.get(0);
            pending.remove(next);
            MandelListFolder f = this.getLinkFolder(next);
            if (f == null) continue;
            for (QualifiedMandelName qmn : f.getMandelList()) {
                MandelName mn = qmn.getMandelName();
                if (closure.contains(mn)) continue;
                closure.add(mn);
                pending.add(mn);
                list.add(new QualifiedMandelName(mn));
            }
        }
        return list;
    }

    public MandelListModel getLinkModel(MandelName n) {
        MandelListFolder f = this.getLinkFolder(n);
        if (f == null) {
            return null;
        }
        return this.getMandelListModel(f);
    }

    public void addLink(MandelName src, MandelName dst) {
        boolean done = false;
        if (!this.mod) {
            return;
        }
        done |= this._addLink(src, dst);
        if (done |= this._addLink(dst, src)) {
            this.handleAddLink(src, dst);
        }
    }

    public void removeLink(MandelName src, MandelName dst) {
        boolean done = false;
        if (!this.mod) {
            return;
        }
        done |= this._removeLink(src, dst);
        if (done |= this._removeLink(dst, src)) {
            this.handleRemoveLink(src, dst);
        }
    }

    private boolean _removeLink(MandelName src, MandelName dst) {
        boolean done = false;
        if (!this.mod) {
            return done;
        }
        MandelListFolder f = this.getLinkFolder(src);
        if (f != null) {
            MandelListTableModel m = this.getMandelListModel(f);
            QualifiedMandelName qn = new QualifiedMandelName(dst);
            done = f.contains(qn);
            m.remove(qn);
            if (m.getList().isEmpty()) {
                this.removeFolder(f);
            }
        }
        return done;
    }

    private boolean _addLink(MandelName src, MandelName dst) {
        QualifiedMandelName qn;
        boolean done = false;
        if (!this.mod) {
            return done;
        }
        MandelListFolder f = this.getLinkFolder(src);
        if (f == null) {
            f = this.insertFolder(src.getName(), this.getRoot());
            f.setThumbnailName(new QualifiedMandelName(src));
        }
        done = !f.contains(qn = new QualifiedMandelName(dst));
        this.add(f, qn);
        return done;
    }

    public void addLinkListener(LinkListener h) {
        this.llisteners.add(h);
    }

    public void removeLinkListener(LinkListener h) {
        this.llisteners.remove(h);
    }

    private void handleAddLink(MandelName src, MandelName dst) {
        for (LinkListener h : this.llisteners) {
            h.linkAdded(src, dst);
        }
    }

    private void handleRemoveLink(MandelName src, MandelName dst) {
        for (LinkListener h : this.llisteners) {
            h.linkRemoved(src, dst);
        }
    }
}

