/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.ComposedMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.DefaultMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderBrowserModel;
import com.mandelsoft.mand.tool.MandelListFolderPanel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelSupport;
import com.mandelsoft.mand.tool.MandelListPanel;
import com.mandelsoft.mand.util.FileMandelListFolderTree;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.swing.GBCPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class MandelListFolderBrowserPanel
extends GBCPanel {
    public static boolean debug = false;
    private ModelChangedListener listener;
    private MandelListFolderBrowserModel model;
    private MandelListFolderPanel fpanel;
    private MandelListPanel lpanel;
    private boolean extmodel;

    public MandelListFolderBrowserPanel(String header, MandelListFolderTree ftree, MandelScanner scanner) {
        this(header, new DefaultMandelListFolderTreeModel(ftree, scanner), scanner);
    }

    public MandelListFolderBrowserPanel(String header, MandelListFolderTreeModel model, MandelScanner scanner) {
        this(header, new MandelListFolderBrowserModel(model), scanner);
        this.extmodel = false;
    }

    public MandelListFolderBrowserPanel(String header, MandelListFolderBrowserModel model, MandelScanner scanner) {
        this.model = model;
        this.extmodel = true;
        this.fpanel = new MandelListFolderPanel(model, scanner);
        this.fpanel.addActionListener(new ListSelectionListener());
        this.listener = new ModelChangedListener();
        this.lpanel = new MandelListPanel(model.getRoot().getName(), model.getActiveListModel(), null);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.5);
        splitPane.setLeftComponent(this.fpanel);
        splitPane.setRightComponent(this.lpanel);
        this.add((Component)splitPane, this.GBC(0, 0, 1));
        this.handleModifiable(model.isModifiable());
    }

    @Override
    protected void panelBound() {
        super.panelBound();
        System.out.println("setup tree listener");
        this.model.addTreeModelListener(this.listener);
        this.model.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void panelUnbound() {
        super.panelUnbound();
        System.out.println("cleanup tree listener");
        this.model.removeTreeModelListener(this.listener);
        this.model.removePropertyChangeListener(this.listener);
        if (!this.extmodel) {
            this.model.setFolderTreeModel(null);
        }
    }

    public boolean isModifiable() {
        return this.model.isModifiable();
    }

    public void setModifiable(boolean modifiable) {
        this.handleModifiable(modifiable);
        this.model.setModifiable(modifiable);
    }

    protected void handleModifiable(boolean b) {
        System.out.println("handle browser panel modifiable " + b);
        this.fpanel.setModifiable(b);
        if (b) {
            this.lpanel.setModifiable(this.model.getActiveListModel().isModifiable());
        } else {
            this.lpanel.setModifiable(b);
        }
    }

    public void setRootVisible(boolean b) {
        this.fpanel.setRootVisible(b);
    }

    private String folderSpec(Object o) {
        MandelListFolder f = (MandelListFolder)o;
        return f.toString();
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        FileMandelListFolderTree f = new FileMandelListFolderTree(file);
        DefaultMandelListFolderTreeModel m1 = new DefaultMandelListFolderTreeModel(f, null);
        m1.setModifiable(true);
        final MandelListFolderTreeModel m2 = ComposedMandelListFolderTreeModel.createDemo(f);
        m2.setModifiable(true);
        System.out.println("folder setup done");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                this.create(2);
                this.create(3);
            }

            private void create(int mode) {
                TestFrame frame = new TestFrame(m2);
                frame.setDefaultCloseOperation(mode);
                frame.setVisible(true);
            }
        });
    }

    private class ListSelectionListener
    implements ActionListener {
        private ListSelectionListener() {
        }

        private void dump(String msg, TreePath p) {
            if (debug) {
                System.out.println(msg + ":");
                while (p != null) {
                    System.out.println("  " + MandelListFolderBrowserPanel.this.folderSpec(p.getLastPathComponent()));
                    p = p.getParentPath();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("selection event");
            TreePath p = MandelListFolderBrowserPanel.this.fpanel.getSelectedPath();
            if (p != null && ((MandelListFolder)p.getLastPathComponent()).getMandelList() != null) {
                this.dump("active path", p);
                MandelListFolderBrowserPanel.this.model.setActivePath(p);
            }
        }
    }

    private class ModelChangedListener
    implements TreeModelListener,
    PropertyChangeListener {
        private ModelChangedListener() {
        }

        private void dump(String msg, TreeModelEvent e) {
            if (debug) {
                Object[] oa;
                System.out.println(msg + ":");
                for (Object o : oa = e.getPath()) {
                    System.out.println("  " + MandelListFolderBrowserPanel.this.folderSpec(o));
                }
                oa = e.getChildren();
                if (oa != null && oa.length > 0) {
                    System.out.println("  children:");
                    for (Object o : oa) {
                        System.out.println("  " + MandelListFolderBrowserPanel.this.folderSpec(o));
                    }
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.dump("tree node changed", e);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.dump("tree node inserted", e);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            MandelListFolder f;
            this.dump("tree node removed", e);
            if (f != null) {
                MandelListFolder l = (MandelListFolder)e.getTreePath().getLastPathComponent();
                for (f = MandelListFolderBrowserPanel.this.model.getActiveFolder(); f != null; f = f.getParent()) {
                    if (f != l) continue;
                    MandelListFolderBrowserPanel.this.model.setActivePath(MandelListFolderTreeModelSupport.getPathToRoot(MandelListFolderBrowserPanel.this.model.getActiveFolder()));
                    break;
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.dump("tree structure", e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("modifiable")) {
                MandelListFolderBrowserPanel.this.handleModifiable((Boolean)evt.getNewValue());
            } else if (prop.equals("activeName")) {
                System.out.println("set active name " + MandelListFolderBrowserPanel.this.model.getActivePathName());
                MandelListFolderBrowserPanel.this.lpanel.setTitle(MandelListFolderBrowserPanel.this.model.getActivePathName());
            } else if (prop.equals("activeFolder")) {
                System.out.println("set active list model");
                MandelListFolderBrowserPanel.this.lpanel.setModel(MandelListFolderBrowserPanel.this.model.getActiveListModel());
                MandelListFolderBrowserPanel.this.fpanel.setActiveFolder(MandelListFolderBrowserPanel.this.model.getActiveFolder());
                MandelListFolderBrowserPanel.this.revalidate();
            }
        }
    }

    static class TestFrame
    extends JFrame {
        TestFrame(MandelListFolderTree folder) {
            MandelListFolderBrowserPanel panel = new MandelListFolderBrowserPanel("Test", folder, null);
            this.add(panel);
            panel.setModifiable(true);
            this.pack();
            this.setMinimumSize(this.getSize());
        }

        TestFrame(MandelListFolderTreeModel model) {
            MandelListFolderBrowserPanel panel = new MandelListFolderBrowserPanel("Test", model, null);
            this.add(panel);
            this.pack();
            this.setMinimumSize(this.getSize());
        }
    }
}

