/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.DefaultMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelSource;
import com.mandelsoft.mand.tool.ctx.ContextProvider;
import com.mandelsoft.mand.tool.ctx.DeleteFolderAction;
import com.mandelsoft.mand.tool.ctx.MandelListFolderContextMenuHandler;
import com.mandelsoft.mand.tool.ctx.NewFolderAction;
import com.mandelsoft.mand.util.FileMandelListFolderTree;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.swing.ActionPanel;
import com.mandelsoft.swing.DnDJTree;
import com.mandelsoft.swing.GBC;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class MandelListFolderPanel
extends ActionPanel
implements MandelListFolderTreeModelSource {
    private static final boolean debug = false;
    private MandelListFolderTreeModel model;
    private DnDJTree tree;
    private JScrollPane view;
    private boolean modifiable;
    private JButton add;
    private JButton remove;
    private MandelListFolder active;
    private ContextHandler contextHandler;
    private ContextProvider<MandelListFolder, TreePath, MandelListFolderTreeModel> prov = new ContextProvider<MandelListFolder, TreePath, MandelListFolderTreeModel>(){

        @Override
        public TreePath getSelectionSpec() {
            return null;
        }

        @Override
        public MandelListFolder getSelectedItem() {
            return MandelListFolderPanel.this.getSelectedFolder();
        }

        @Override
        public Window getWindow() {
            return MandelListFolderPanel.this.getWindow();
        }

        @Override
        public MandelListFolderTreeModel getModel() {
            return MandelListFolderPanel.this.getModel();
        }
    };
    public static final ImageIcon listIcon = MandelListFolderPanel.createImageIcon("resc/list2.gif");
    public static final ImageIcon activeListIcon = MandelListFolderPanel.createImageIcon("resc/alist2.gif");
    public static final ImageIcon folderIcon = MandelListFolderPanel.createImageIcon("resc/folder2.gif");
    public static final ImageIcon folderlistIcon = MandelListFolderPanel.createImageIcon("resc/folderlist2.gif");
    public static final ImageIcon activeFolderlistIcon = MandelListFolderPanel.createImageIcon("resc/afolderlist2.gif");

    public MandelListFolderPanel(MandelListFolderTree ftree, MandelScanner scanner) {
        this(new DefaultMandelListFolderTreeModel(ftree, scanner), scanner);
    }

    public MandelListFolderPanel(MandelListFolderTreeModel model, MandelScanner scanner) {
        Dimension minimumSize = new Dimension(10, 10);
        this.model = model;
        this.modifiable = model.isModifiable();
        this.tree = new DnDJTree(this.model);
        this.tree.setCellRenderer(new FolderTreeRenderer());
        this.tree.setEditable(true);
        this.tree.addTreeSelectionListener(new TSL());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.view = new JScrollPane(this.tree);
        this.view.setMinimumSize(minimumSize);
        JLabel c = new JLabel("height");
        FontMetrics m = c.getFontMetrics(c.getFont());
        this.view.setPreferredSize(new Dimension(m.charWidth('W') * 10, m.getHeight() * 6));
        this.addContent(this.view, new GBC(0, 0).setWeight(10.0, 10.0).setFill(1));
        this.tree.setToggleClickCount(3);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                TreePath p = MandelListFolderPanel.this.tree.getPathForLocation(event.getX(), event.getY());
                if (p != null) {
                    MandelListFolderPanel.this.fireActionPerformed(1001, null);
                }
            }
        });
        this.contextHandler = new ContextHandler();
        this.tree.setContextMenuHandler(this.contextHandler);
        this.add = this.addButton("new folder", new AddActionListener());
        this.remove = this.addButton("delete folder", new DeleteActionListener());
        this.add.setEnabled(false);
        this.remove.setEnabled(false);
        this.handleModifiable(this.modifiable);
    }

    @Override
    protected void panelBound() {
        super.panelBound();
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    @Override
    protected void panelUnbound() {
        super.panelUnbound();
        ToolTipManager.sharedInstance().unregisterComponent(this.tree);
    }

    @Override
    public MandelListFolderTreeModel getModel() {
        return this.model;
    }

    public void setModel(MandelListFolderTreeModel model) {
        this.model = model;
        this.tree.setModel(model);
    }

    public void setActiveFolder(MandelListFolder folder) {
        if (this.active != folder) {
            MandelListFolder old = this.active;
            this.active = folder;
            this.firePropertyChange("activeFolder", old, this.active);
        }
    }

    public MandelListFolder getActiveFolder() {
        return this.active;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean modifiable) {
        if (this.modifiable != modifiable) {
            this.modifiable = modifiable;
            this.handleModifiable(this.modifiable);
            this.firePropertyChange("modifiable", !modifiable, modifiable);
        }
    }

    protected void handleModifiable(boolean modifiable) {
        this.remove.setVisible(modifiable);
        this.add.setVisible(modifiable);
        this.tree.setEditable(modifiable);
        this.model.setModifiable(modifiable);
    }

    public TreePath getSelectedPath() {
        return this.tree.getSelectionPath();
    }

    public MandelListFolder getSelectedFolder() {
        TreePath p = this.tree.getSelectionPath();
        if (p == null) {
            return null;
        }
        return (MandelListFolder)p.getLastPathComponent();
    }

    public void setRootVisible(boolean b) {
        this.tree.setRootVisible(b);
    }

    private boolean folderMetaModifiable(TreePath p) {
        return MandelListFolderTreeModel.Util.folderMetaModifiable(this.getModel(), p);
    }

    private boolean folderModifiable(TreePath p) {
        return MandelListFolderTreeModel.Util.folderModifiable(this.getModel(), p);
    }

    private boolean folderContentModifiable(TreePath p) {
        return MandelListFolderTreeModel.Util.folderContentModifiable(this.getModel(), p);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(int id, String cmd) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, id, cmd);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = MandelListFolderPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        final FileMandelListFolderTree f = new FileMandelListFolderTree(file);
        FileMandelListFolderTree.print("", f.getRoot());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestFrame frame = new TestFrame(f);
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    private class FolderTreeRenderer
    extends DefaultTreeCellRenderer {
        private String desc;

        public FolderTreeRenderer() {
            this.setIcon(folderIcon);
            this.setLeafIcon(listIcon);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MandelListFolder f = (MandelListFolder)value;
            this.desc = f.getProperty("description");
            if (!f.isLeaf()) {
                if (f.getMandelList() == null) {
                    this.setInfo(folderIcon, "This folder has no list.");
                } else if (MandelListFolderPanel.this.active == value) {
                    this.setInfo(activeFolderlistIcon, "this folder has a list, which is displayed");
                } else {
                    this.setInfo(folderlistIcon, "this folder has a list");
                }
            } else if (MandelListFolderPanel.this.active == value) {
                this.setInfo(activeListIcon, "this is a plain list, which is displayed");
            } else {
                this.setInfo(listIcon, "this is a plain list");
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        private String desc(String desc, String def) {
            if (desc == null || desc.length() == 0) {
                return def;
            }
            return desc;
        }

        private void setInfo(Icon icon, String tooltip) {
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
            this.setToolTipText(this.desc(this.desc, tooltip));
        }
    }

    private class TSL
    implements TreeSelectionListener {
        private TSL() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            boolean mod2 = false;
            MandelListFolderTreeModel m = null;
            TreePath p = e.getNewLeadSelectionPath();
            if (p != null) {
                m = MandelListFolderPanel.this.getModel();
                mod2 = m.isPathModifiable(p) && !((MandelListFolder)p.getLastPathComponent()).isLeaf();
            }
            MandelListFolderPanel.this.add.setEnabled(MandelListFolderPanel.this.folderModifiable(p));
            MandelListFolderPanel.this.remove.setEnabled(MandelListFolderPanel.this.folderModifiable(p) && MandelListFolderPanel.this.folderMetaModifiable(p));
        }
    }

    private class ContextHandler
    extends MandelListFolderContextMenuHandler
    implements DnDJTree.ContextMenuHandler {
        private ContextHandler() {
        }

        @Override
        public MandelList getSelectedMandelList() {
            return this.getSelectedItem().getMandelList();
        }

        @Override
        public void handleContextMenu(DnDJTree table, MouseEvent evt, TreePath path) {
            this.handleContextMenu((JComponent)table, evt, path);
        }
    }

    private class AddActionListener
    extends NewFolderAction {
        public AddActionListener() {
            super(MandelListFolderPanel.this.prov);
        }
    }

    private class DeleteActionListener
    extends DeleteFolderAction {
        public DeleteActionListener() {
            super(MandelListFolderPanel.this.prov);
        }
    }

    static class TestFrame
    extends JFrame {
        TestFrame(MandelListFolderTree ftree) {
            MandelListFolderPanel panel = new MandelListFolderPanel(ftree, null);
            panel.setModifiable(true);
            this.add(panel);
            this.pack();
        }
    }
}

