/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.ControlDialog;
import com.mandelsoft.mand.tool.History;
import com.mandelsoft.mand.tool.MandelListModelSource;
import com.mandelsoft.mand.tool.MandelListPanel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ctx.MandelListContextMenuHandler;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.swing.TablePanel;
import com.mandelsoft.swing.TableSelection;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;

public class MandelListsDialog
extends ControlDialog {
    public MandelListsDialog(MandelWindowAccess owner) {
        super(owner, "Mandel Lists");
        Dimension d = new Dimension((int)this.getSize().getWidth() + 60, (int)this.getSize().getHeight());
        this.setSize(d);
        this.setMinimumSize(d);
        System.out.println("minimal size is " + this.getMinimumSize());
        this.setResizable(true);
    }

    @Override
    protected void setup() {
        if (this.getEnvironment().getUnseenRastersModel() != null) {
            this.addTab("Unseen", new UnseenRasterPanel(), "Images not seen according to local seen file");
        }
        this.addTab("Variants", new VariantsPanel(), "Mandel areas with variants");
        if (this.getEnvironment().getFavoritesModel() != null) {
            this.addTab("Favorites", new FavoritesPanel(), "Images according local favorites file");
        }
        if (this.getEnvironment().getTodosModel() != null) {
            this.addTab("Todos", new TodosPanel(), "Images according local todo file");
        }
        this.addTab("History", new HistoryPanel(), "Display history of images");
        if (this.getEnvironment().getAreasModel() != null) {
            this.addTab("Key Areas", new AreasPanel(), "Marked root areas for backward navigation");
        }
        if (this.getEnvironment().getUnseenRefinementsModel() != null) {
            this.addTab("Refinements", new RefinementsPanel(), "Available refinements");
        }
        if (this.getEnvironment().getRefinementRequestsModel() != null) {
            this.addTab("RefineReq", new RefinementRequestsPanel(), "Refinement requests");
        }
        if (this.getEnvironment().getRequestsModel() != null) {
            this.addTab("Requests", new RequestsPanel(), "Requests");
        }
    }

    private class UnseenRasterPanel
    extends RefreshingPanel {
        public UnseenRasterPanel() {
            super(MandelListsDialog.this.getEnvironment().getUnseenRastersModel());
        }

        private class NewAction
        implements ActionListener {
            private NewAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MandelList unseen = ((MandelListTableModel)UnseenRasterPanel.this.getModel()).getList();
                MandelList n = MandelListsDialog.this.getEnvironment().getNewRasters();
                n.refresh(false);
                MandelListsDialog.this.getEnvironment().refresh(unseen);
                unseen.retainAll(n);
                try {
                    unseen.save();
                }
                catch (IOException ex) {
                    System.err.println("cannot write seen: " + ex);
                }
                ((MandelListTableModel)UnseenRasterPanel.this.getModel()).fireTableDataChanged();
            }
        }
    }

    private class VariantsPanel
    extends MandelListPanel {
        public VariantsPanel() {
            super((String)null, MandelListsDialog.this.getEnvironment().getVariantsModel(), (ActionListener)null);
        }
    }

    private class FavoritesPanel
    extends MandelListPanel {
        public FavoritesPanel() {
            super(null, MandelListsDialog.this.getEnvironment().getFavoritesModel(), null, !MandelListsDialog.this.getEnvironment().isReadonly());
        }
    }

    private class TodosPanel
    extends MandelListPanel {
        public TodosPanel() {
            super(null, MandelListsDialog.this.getEnvironment().getTodosModel(), null, !MandelListsDialog.this.getEnvironment().isReadonly());
        }
    }

    private class HistoryPanel
    extends TablePanel<MandelListTableModel>
    implements MandelListModelSource {
        private History history;
        private QualifiedMandelName mandelname;
        private int index;
        private JButton back;
        private JButton forth;

        public HistoryPanel() {
            super(null, MandelListsDialog.this.getMandelWindowAccess().getHistory(), null);
            this.setSortOrder(0, SortOrder.DESCENDING);
            LoadAction load = new LoadAction();
            this.addActionListener(load);
            this.back = this.addButton("Back", new BackAction());
            this.forth = this.addButton("Forth", new ForthAction());
            this.addButton("Load", load);
            this.addButton("Clear", new ClearAction());
            this.history = MandelListsDialog.this.getMandelWindowAccess().getHistory();
            this.setContextMenuHandler(new ContextHandler());
        }

        @Override
        protected void setSelection(TableSelection sel) {
            this.index = sel.getLeadSelection();
            this.mandelname = ((MandelListTableModel)this.getModel()).getQualifiedName(this.index);
            System.out.println("model index: " + this.index + "(" + this.getTable().getSelectionModel().getMaxSelectionIndex() + "): " + this.mandelname);
        }

        @Override
        protected void modelUpdated() {
            super.modelUpdated();
            int cur = this.history.getCurrent();
            this.back.setEnabled(cur > 0);
            this.forth.setEnabled(cur < this.history.getList().size() - 1);
            this.setSelectedRow(cur);
        }

        private class LoadAction
        implements ActionListener {
            private LoadAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("*** load history entry " + HistoryPanel.this.mandelname);
                if (HistoryPanel.this.mandelname == null) {
                    return;
                }
                HistoryPanel.this.setBusy(true);
                int cur = HistoryPanel.this.history.setCurrent(HistoryPanel.this.index);
                if (!MandelListsDialog.this.getMandelWindowAccess().getMandelImagePane().setImage(HistoryPanel.this.mandelname)) {
                    HistoryPanel.this.history.setCurrent(cur);
                    JOptionPane.showMessageDialog(HistoryPanel.this.getOwner(), "Cannot load image: " + HistoryPanel.this.mandelname, "Mandel IO", 2);
                }
                HistoryPanel.this.setBusy(false);
            }
        }

        private class BackAction
        extends LoadAction {
            private BackAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoryPanel.this.history.getCurrent() <= 0) {
                    return;
                }
                HistoryPanel.this.index = HistoryPanel.this.history.getCurrent() - 1;
                HistoryPanel.this.mandelname = HistoryPanel.this.history.getQualifiedName(HistoryPanel.this.index);
                super.actionPerformed(e);
            }
        }

        private class ForthAction
        extends LoadAction {
            private ForthAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoryPanel.this.history.getCurrent() >= HistoryPanel.this.history.getList().size()) {
                    return;
                }
                HistoryPanel.this.index = HistoryPanel.this.history.getCurrent() + 1;
                HistoryPanel.this.mandelname = HistoryPanel.this.history.getQualifiedName(HistoryPanel.this.index);
                super.actionPerformed(e);
            }
        }

        private class ClearAction
        implements ActionListener {
            private ClearAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryPanel.this.mandelname = null;
                ((MandelListTableModel)HistoryPanel.this.getModel()).clear();
            }
        }

        private class ContextHandler
        extends MandelListContextMenuHandler
        implements TablePanel.ContextMenuHandler {
            private ContextHandler() {
            }
        }
    }

    private class AreasPanel
    extends MandelListPanel {
        public AreasPanel() {
            super(null, MandelListsDialog.this.getEnvironment().getAreasModel(), null, !MandelListsDialog.this.getEnvironment().isReadonly());
        }
    }

    private class RefinementsPanel
    extends MandelListPanel {
        public RefinementsPanel() {
            super((String)null, MandelListsDialog.this.getEnvironment().getUnseenRefinementsModel(), (ActionListener)null);
        }
    }

    private class RefinementRequestsPanel
    extends MandelListPanel {
        public RefinementRequestsPanel() {
            super((String)null, MandelListsDialog.this.getEnvironment().getRefinementRequestsModel(), (ActionListener)null);
        }
    }

    private class RequestsPanel
    extends MandelListPanel {
        public RequestsPanel() {
            super((String)null, MandelListsDialog.this.getEnvironment().getRequestsModel(), (ActionListener)null);
            this.enableGalery(false);
            this.enableSlideShow(false);
        }
    }

    private class NewRasterPanel
    extends RefreshingPanel {
        public NewRasterPanel() {
            super(MandelListsDialog.this.getEnvironment().getNewRastersModel());
        }
    }

    private class RefreshingPanel
    extends MandelListPanel {
        public RefreshingPanel(MandelListTableModel model) {
            super((String)null, model, (ActionListener)null);
        }

        @Override
        protected void setup(ActionListener action) {
            super.setup(new RefreshLoadAction());
        }

        protected class RefreshLoadAction
        extends MandelListPanel.LoadAction {
            protected RefreshLoadAction() {
            }

            @Override
            protected void handleLoaded(QualifiedMandelName name) {
            }
        }
    }
}

