/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelAreaCreationDialog;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.swing.BufferedComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;

public class MandelSubAreaCreationDialog
extends MandelAreaCreationDialog {
    public MandelSubAreaCreationDialog(MandelWindowAccess owner, String title) {
        super(owner, title);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.handleClose();
        }
    }

    @Override
    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        return new SubAreaView(name, (MandelInfo)info);
    }

    public void setRect(BufferedComponent.VisibleRect rect) {
        ((SubAreaView)this.getView()).setRect(rect);
    }

    public void setRectHandled() {
        ((SubAreaView)this.getView()).setRectHandled();
    }

    protected class SubAreaView
    extends MandelAreaCreationDialog.CreationView {
        private JButton namebutton;
        private JButton nextnamebutton;
        private JButton registerrangebutton;

        public SubAreaView(QualifiedMandelName name, MandelInfo info) {
            super(name, info);
        }

        @Override
        protected void setupButtons() {
            super.setupButtons();
            this.namebutton = this.createButton("Name", "Determine next free sub area name", new NameAction());
            this.nextnamebutton = this.createButton("Next", "Determine next free area name for given name", new NextNameAction());
            this.registerrangebutton = this.createButton("Set Range", "Register effective range at actual image", new RegisterRangeAction());
            this.addShowButton("Show sub area", true);
        }

        @Override
        public void setFilename(String n, boolean modifiable) {
            super.setFilename(n, modifiable);
            this.namebutton.setEnabled(modifiable);
            this.nextnamebutton.setEnabled(modifiable);
        }

        protected final void determineNextFilename() {
            ToolEnvironment env = MandelSubAreaCreationDialog.this.getMandelFrame().getEnvironment();
            System.out.println("env=" + env);
            MandelFileName n = MandelFileName.create(new File(this.getFilename()));
            if (n == null) {
                this.Error("Sub Area Creation Problem", "Filename is no mandel file name");
                return;
            }
            MandelName sub = MandUtils.getNextName(n.getName(), env.getAutoMetaScanner());
            if (sub == null) {
                this.Error("Sub Area Creation Problem", "No further names available.");
            } else {
                File path = env.getInfoFolder(null);
                if (path == null) {
                    path = new File(".");
                }
                this.setFilename(new File(path, sub.getName() + ".md").getPath());
            }
        }

        protected final void determineFilename() {
            MandelName sub;
            ToolEnvironment env = MandelSubAreaCreationDialog.this.getMandelFrame().getEnvironment();
            System.out.println("env=" + env);
            MandelName parent = MandelSubAreaCreationDialog.this.getMandelFrame().getMandelName();
            MandelInfo info = this.getInfo();
            MandelName root = MandUtils.lookupRoot(env.getMetaScanner(), parent, info.getSpec());
            if (root == null) {
                root = parent;
            }
            if ((sub = MandUtils.getNextSubName(root, env.getAutoMetaScanner())) == null) {
                this.Error("Sub Area Creation Problem", "No further names available.");
            } else {
                File path = env.getInfoFolder(null);
                if (path == null) {
                    path = new File(".");
                }
                this.setFilename(new File(path, sub.getName() + ".md").getPath());
            }
        }

        public void setRectHandled() {
            if (this.rect != null) {
                this.rect.setProportionProvider(null);
            }
            this.rect = null;
        }

        public void setRect(BufferedComponent.VisibleRect rect) {
            if (this.rect != null && rect != this.rect) {
                this.handleClose();
            }
            if (rect == null) {
                this.setRectHandled();
                return;
            }
            MandelInfo info = (MandelInfo)rect.getOwner();
            if (rect.getName() != null) {
                if (rect == this.rect) {
                    MandUtils.round(info);
                }
                this.setInfo("Subarea " + rect.getName(), info);
            } else {
                MandUtils.round(info);
                this.setInfo("New Subarea", info);
            }
            if (this.automode && rect != this.rect) {
                this.determineFilename();
            }
            this._setRect(rect);
        }

        @Override
        protected void _setRect(BufferedComponent.VisibleRect rect) {
            this.rect = rect;
        }

        @Override
        protected BufferedComponent.VisibleRect getSelectedRect() {
            return this.rect;
        }

        private class NameAction
        implements ActionListener {
            private NameAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SubAreaView.this.determineFilename();
            }
        }

        private class NextNameAction
        implements ActionListener {
            private NextNameAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SubAreaView.this.determineNextFilename();
            }
        }

        private class RegisterRangeAction
        implements ActionListener {
            private RegisterRangeAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MandelInfo info = SubAreaView.this.getInfo();
                String range = String.format("[x=%d,y=%d,w=%d,h=%d]", SubAreaView.this.rect.getCenterX(), SubAreaView.this.rect.getCenterY(), SubAreaView.this.rect.getWidth(), SubAreaView.this.rect.getHeight());
                System.out.printf("selected range %s\n", range);
                MandelData data = MandelSubAreaCreationDialog.this.getMandelWindowAccess().getMandelData();
                try {
                    MandelData orig = new MandelData(data.getFile());
                    String cur = data.getInfo().getProperty("merge-range");
                    if (cur != null && cur.equals(range)) {
                        MandelSubAreaCreationDialog.this.mandelInfo("data not changed");
                    } else {
                        try {
                            orig.getInfo().setProperty("merge-range", range);
                            orig.write();
                        }
                        catch (IOException ex) {
                            MandelSubAreaCreationDialog.this.mandelError("cannot write " + data.getFile() + ": " + ex);
                        }
                    }
                }
                catch (IOException ex) {
                    MandelSubAreaCreationDialog.this.mandelError("cannot read " + data.getFile() + ": " + ex);
                }
            }
        }
    }
}

