/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.swing.ChangeListenerSupport;
import com.mandelsoft.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeListener;

public class MandelVariantModel
extends AbstractListModel
implements ComboBoxModel {
    private ChangeListenerSupport listeners = new ChangeListenerSupport();
    protected MandelName name;
    protected MandelScanner scanner;
    protected List<MandelHandle> list;
    protected String selected;

    public MandelVariantModel(MandelScanner scanner) {
        this.scanner = scanner;
        this.list = new ArrayList<MandelHandle>();
    }

    public MandelName getName() {
        return this.name;
    }

    public void refresh(MandelHandle h) {
        if (h == null) {
            return;
        }
        this.name = ((QualifiedMandelName)h.getName()).getMandelName();
        this.refresh(this.getLabel(h));
    }

    public void refresh(QualifiedMandelName n, MandelHeader h) {
        System.out.println("refresh variants for " + n + "/" + h);
        if (h == null || n == null) {
            return;
        }
        this.name = n.getMandelName();
        this.refresh(this.getLabel(n, h));
    }

    private int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    protected String getLabel(MandelHandle h) {
        return this.getLabel((QualifiedMandelName)h.getName(), h.getHeader());
    }

    protected String getLabel(QualifiedMandelName n, MandelHeader h) {
        String q = n.getQualifier();
        if (Utils.isEmpty(q)) {
            q = "<default>";
        }
        return q + " (" + h.getTypeDesc() + ")";
    }

    private void refresh(String sel) {
        int old = this.list.size();
        this.list.clear();
        Set<MandelHandle> n = this.scanner.getMandelHandles(this.name);
        System.out.println("*** update variants: " + n + " (" + sel + ")");
        this.selected = null;
        if (n != null) {
            for (MandelHandle h : n) {
                String v = this.getLabel(h);
                System.out.println("found " + v + ": " + h.getFile());
                if (v.equals(sel)) {
                    this.selected = sel;
                }
                for (int i = 0; h != null && i < this.list.size(); ++i) {
                    if (this.compare(this.list.get(i).getQualifier(), h.getQualifier()) < 0) continue;
                    this.list.add(i, h);
                    h = null;
                }
                if (h == null) continue;
                this.list.add(h);
            }
        }
        System.out.println("Selected: " + this.selected);
        this.fireContentsChanged(this, 0, Math.max(old, this.list.size()) - 1);
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= this.list.size()) {
            return "<none>";
        }
        MandelHandle h = this.list.get(index);
        if (h == null) {
            return "<unknown>";
        }
        return this.getLabel(h);
    }

    public MandelHandle getElement(Object item) {
        for (MandelHandle h : this.list) {
            if (!this.getLabel(h).equals(item)) continue;
            return h;
        }
        return null;
    }

    public QualifiedMandelName getVariantName() {
        if (this.selected == null) {
            return null;
        }
        MandelHandle h = this.getElement(this.selected);
        if (h == null) {
            return null;
        }
        return (QualifiedMandelName)h.getName();
    }

    public MandelHandle getVariantHandle() {
        if (this.selected == null) {
            return null;
        }
        return this.getElement(this.selected);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = (String)anItem;
        this.fireContentsChanged(this, 0, this.list.size() - 1);
        this.fireChangeEvent();
    }

    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    private void fireChangeEvent() {
        this.listeners.fireChangeEvent();
    }
}

