/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.cm.ColormapSource;
import com.mandelsoft.mand.cm.ColormapSourceFactory;
import com.mandelsoft.mand.image.MandelAreaImage;
import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.Decoration;
import com.mandelsoft.mand.tool.DynamicColor;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.PictureSavePanel;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.util.CachedUpstreamColormapSourceFactory;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.SimpleColormapSourceFactory;
import com.mandelsoft.swing.worker.CallbackWorker;
import com.mandelsoft.swing.worker.ErrorNotification;
import com.mandelsoft.swing.worker.UIExecution;
import com.mandelsoft.swing.worker.UIFunction;
import com.mandelsoft.swing.worker.WorkerProgressMonitor;
import com.mandelsoft.util.Utils;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class PictureSaveDialog
extends MandelDialog {
    private PictureSavePanel panel = this.createPictureSavePanel();
    private List<MandelHandle> list;

    private PictureSaveDialog(MandelWindowAccess owner, String name) {
        super(owner, name);
        this.panel.updateState();
        this.setDefaultCloseOperation(2);
        this.setup();
        this.add(this.panel);
        this.pack();
    }

    public PictureSaveDialog(MandelWindowAccess owner, String name, List<MandelHandle> list) {
        this(owner, name);
        this.list = list;
    }

    public PictureSaveDialog(MandelWindowAccess owner, String name, MandelList list) {
        this(owner, name);
        this.list = new ArrayList<MandelHandle>();
        MandelScanner s = this.getEnvironment().getImageDataScanner();
        for (QualifiedMandelName n : list) {
            MandelHandle h = s.getMandelHandle(n);
            if (h == null) continue;
            this.list.add(h);
        }
    }

    protected PictureSavePanel createPictureSavePanel() {
        return new PicturePanel();
    }

    protected void setup() {
    }

    public class PicturePanel
    extends PictureSavePanel {
        private JButton save;

        public PicturePanel() {
            super("Image directory", 1);
            this.save = this.addButton("Save", new SaveImageAction(), "Save picture file");
            this.addButton("Clear", new PictureSavePanel.ClearAction(this), "Clear file name");
            ResetAction reset = new ResetAction();
            this.addButton("Reset", reset, "Generate picture path name");
            reset.actionPerformed(null);
        }

        @Override
        public MandelWindowAccess getMandelWindowAccess() {
            return PictureSaveDialog.this.getMandelWindowAccess();
        }

        private class SaveImageAction
        implements ActionListener {
            private Worker task;

            private SaveImageAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int width;
                String path = PicturePanel.this.imagefile.getFilename();
                File file = new File(path);
                if (!file.exists()) {
                    int o = JOptionPane.showOptionDialog(PicturePanel.this.getOwner(), "Create Directory", path, 2, 3, null, null, null);
                    if (o != 0) {
                        return;
                    }
                    if (!file.mkdirs()) {
                        JOptionPane.showMessageDialog(PicturePanel.this.getOwner(), "cannot create directoty", "Image IO", 0);
                        return;
                    }
                }
                if (!file.isDirectory()) {
                    JOptionPane.showMessageDialog(PicturePanel.this.getOwner(), path + " is no directory", "Image IO", 0);
                    return;
                }
                PicturePanel.this.save.setEnabled(false);
                try {
                    width = PicturePanel.this.width.getValue().intValue();
                }
                catch (Exception ex) {
                    width = 0;
                }
                this.task = new Worker(PictureSaveDialog.this.list, PicturePanel.this.getMandelWindowAccess(), PicturePanel.this.imagefile.getFilename(), (String)PicturePanel.this.formats.getSelectedItem(), width, PicturePanel.this.decorationButton.isSelected());
                new WorkerProgressMonitor(PictureSaveDialog.this, "Writing Images", this.task);
            }
        }

        private class ResetAction
        implements ActionListener {
            private ResetAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolEnvironment env = PicturePanel.this.getEnvironment();
                QualifiedMandelName mn = PicturePanel.this.getMandelWindowAccess().getQualifiedName();
                String n = env.getProperty("path.bitmap.save");
                if (n == null) {
                    n = ".";
                }
                PicturePanel.this.imagefile.setFilename(n);
            }
        }

        private class PathAction
        implements ActionListener {
            private PathAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolEnvironment env = PicturePanel.this.getEnvironment();
                QualifiedMandelName mn = PicturePanel.this.getMandelWindowAccess().getQualifiedName();
                String n = env.getProperty("path.bitmap.save");
                if (n == null) {
                    n = "";
                }
                PicturePanel.this.imagefile.setFilename(n);
            }
        }
    }

    private class Worker
    extends CallbackWorker<Void, UIExecution, PictureSaveDialog> {
        private List<MandelHandle> list;
        private ColormapSourceFactory cmfac;
        private Mapper mapper;
        private ColormapModel.ResizeMode mode;
        private ToolEnvironment env;
        private String path;
        private String fmt;
        private int width;
        private boolean showDecoration;

        public Worker(List<MandelHandle> list, MandelWindowAccess acc2, String path, String fmt, int width, boolean showDecoration) {
            super(PictureSaveDialog.this);
            this.list = list;
            this.env = acc2.getEnvironment();
            ColormapModel cmm = acc2.getColormapModel();
            Colormap cm = cmm.getColormap();
            this.mode = cmm.getResizeMode();
            this.mapper = acc2.getMapperModel().getMapper();
            MandelImagePanel mp = acc2.getMandelImagePane();
            if (mp != null && mp.getParentColormapModel().isSet()) {
                this.cmfac = new CachedUpstreamColormapSourceFactory(this.env.getImageDataScanner(), mp.getColormapModel(), this.env.getColormapCache());
                System.out.println("-> save with upstream colormap");
            } else {
                System.out.println("-> save with main colormap");
                this.cmfac = new SimpleColormapSourceFactory(cm);
            }
            this.path = path;
            this.fmt = fmt;
            this.width = width;
            this.showDecoration = showDecoration;
        }

        public Decoration getDecoration(MandelInfo info) {
            String deco = info.getProperty("title");
            String copyright = this.env.getCopyright(info);
            if (!Utils.isEmpty(copyright)) {
                deco = Utils.isEmpty(deco) ? copyright : deco + " " + copyright;
            }
            Decoration decoration = new Decoration();
            decoration.setShowDecoration(this.showDecoration);
            decoration.setDecoration(deco);
            System.out.println("*** decoration is " + decoration);
            return decoration;
        }

        public MandelAreaImage getMandelImage(MandelHandle h) throws IOException {
            ColormapSource cm = this.cmfac.getColormapSource((QualifiedMandelName)h.getName());
            return this.env.getMandelImage(h, this.mode, cm, this.mapper, null);
        }

        @Override
        protected void done() {
            this.setProgress(100);
            PictureSaveDialog.this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            int c = 0;
            boolean overwrite = false;
            boolean oset = false;
            for (MandelHandle handle : this.list) {
                String name = this.path + "/" + handle.getName() + "." + this.fmt;
                if (this.isCancelled()) break;
                try {
                    Decoration decoration;
                    File f = new File(name);
                    if (f.exists()) {
                        if (!oset) {
                            int r = this.call(new OverwriteQuestion(f));
                            if (r == 4) break;
                            overwrite = r % 2 == 0;
                            boolean bl = oset = r > 1;
                        }
                        if (!overwrite) {
                            System.out.println("cancel " + name);
                            continue;
                        }
                    }
                    MandelAreaImage mai = this.getMandelImage(handle);
                    BufferedImage im = mai.getImage();
                    BufferedImage tmp = null;
                    Graphics g = null;
                    int w = this.width;
                    if (w != 0) {
                        int h = w * im.getHeight() / im.getWidth();
                        tmp = new BufferedImage(w, h, 1);
                        g = tmp.getGraphics();
                        g.drawImage(im, 0, 0, w, h, null);
                        im = tmp;
                    }
                    if ((decoration = this.getDecoration(mai.getInfo())) != null && decoration.showDecoration()) {
                        if (tmp == null) {
                            tmp = new BufferedImage(im.getWidth(), im.getHeight(), 1);
                            g = tmp.getGraphics();
                            g.drawImage(im, 0, 0, null);
                            im = tmp;
                        }
                        decoration.setColorHandler(new DynamicColor(new DynamicColor.StaticImage(im)));
                        if (g == null) {
                            g = im.getGraphics();
                        }
                        decoration.paintDecoration(g, im.getWidth(), im.getHeight());
                    }
                    try {
                        ImageIO.write((RenderedImage)im, this.fmt, f);
                    }
                    catch (Exception ex) {
                        this.call(new ErrorNotification("Image IO", "Cannot write image: " + ex.toString()));
                    }
                }
                catch (IOException ex) {
                    this.call(new ErrorNotification("Image IO", "Cannot find area image: " + ex.toString()));
                }
                finally {
                    this.setProgress(++c * 100 / this.list.size());
                    System.out.println("written " + name + " (" + c + "/" + this.list.size() + ")");
                }
            }
            this.setProgress(100);
            return null;
        }
    }

    private static class OverwriteQuestion
    extends UIFunction<PictureSaveDialog, Integer> {
        private File file;

        public OverwriteQuestion(File file) {
            this.file = file;
        }

        @Override
        public synchronized void execute(PictureSaveDialog d) {
            Object[] options = new Object[]{"Replace", "Ignore", "Replace all", "Ignore all", "Cancel"};
            int o = JOptionPane.showOptionDialog(d, this.file.getName() + " already exists.\nDo you want to replace it?", "Warning", -1, 2, null, options, options[1]);
            this.setResult(o);
        }
    }
}

