/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.tool.MandelSpecDialog;
import com.mandelsoft.mand.tool.TagListModel;
import com.mandelsoft.swing.GBC;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TagSpec
extends MandelSpecDialog<TagPanel> {
    public TagSpec(Window parent, String name, boolean change) {
        super(parent, "Tag Specification", name, change);
    }

    @Override
    protected TagPanel createPanel(String name, boolean change) {
        return new TagPanel(name, change);
    }

    public class TagPanel
    extends MandelSpecDialog.Panel {
        private JList<String> tags;
        private DefaultListModel model;
        private JComboBox input;
        private JPanel buttons;
        private JButton add;
        private JButton remove;
        private JButton clear;

        public TagPanel(String name, boolean change) {
            super(name, change);
            this.model = new DefaultListModel();
            this.tags = new JList(this.model);
            this.tags.setPrototypeCellValue("InitialTagValueForMandelArea");
            this.tags.setVisibleRowCount(10);
            this.tags.setSelectionMode(0);
            this.tags.setLayoutOrientation(0);
            this.tags.setFixedCellWidth(200);
            this.tags.addListSelectionListener(new Listener());
            JScrollPane sp = new JScrollPane(this.tags);
            this.add((Component)sp, new GBC(0, 1));
            this.input = new JComboBox();
            this.input.setEditable(true);
            this.add((Component)this.input, this.GBC(0, 2, 2).setTopInset(10));
            this.buttons = new JPanel();
            this.buttons.setLayout(new FlowLayout());
            this.add((Component)this.buttons, this.GBC(0, 3).setWeight(100.0, 0.0));
            this.add = new JButton(new AddAction());
            this.buttons.add(this.add);
            this.remove = new JButton(new RemoveAction());
            this.buttons.add(this.remove);
            this.clear = new JButton(new ClearAction());
            this.buttons.add(this.clear);
            this.setEditable(change);
        }

        @Override
        protected void panelBound() {
            super.panelBound();
            TagListModel cbm = TagSpec.this.getMandelWindowAccess().getEnvironment().getTagsModel();
            this.input.setModel(cbm);
        }

        @Override
        protected void panelUnbound() {
            super.panelUnbound();
            DefaultComboBoxModel cbm = new DefaultComboBoxModel();
            this.input.setModel(cbm);
        }

        @Override
        protected void _setInfo(MandelInfo info) {
            this.model.clear();
            for (String tag : info.getKeywords()) {
                this.model.addElement(tag);
            }
        }

        @Override
        public boolean updateInfo(MandelInfo info) {
            super.updateInfo(info);
            HashSet<String> tmp = new HashSet<String>();
            for (Object o : this.model.toArray()) {
                String s = o.toString();
                if (Utils.isEmpty(s)) continue;
                tmp.add(s);
            }
            Set<String> old = info.getKeywords();
            if (Utils.equals(old, tmp)) {
                return false;
            }
            info.setKeywords(tmp);
            return true;
        }

        @Override
        public void setEditable(boolean b) {
            super.setEnabled(b);
            this.input.setVisible(b);
            this.add.setVisible(b);
            this.remove.setVisible(b);
            this.clear.setVisible(b);
        }

        private class Listener
        implements ListSelectionListener {
            private Listener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String s = (String)TagPanel.this.tags.getSelectedValue();
                if (s != null) {
                    TagPanel.this.input.setSelectedItem(s);
                }
            }
        }

        private class AddAction
        extends AbstractAction {
            public AddAction() {
                super("Add");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = (String)TagPanel.this.input.getSelectedItem();
                if (!Utils.isEmpty(s) && !TagPanel.this.model.contains(s)) {
                    TagPanel.this.model.addElement(s);
                    TagSpec.this.getMandelWindowAccess().getEnvironment().getTagsModel().addElement(s);
                    TagSpec.this.fireChangeEvent();
                }
            }
        }

        private class RemoveAction
        extends AbstractAction {
            public RemoveAction() {
                super("Remove");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List values = TagPanel.this.tags.getSelectedValuesList();
                if (values != null && values.size() > 0) {
                    for (String v : values) {
                        TagPanel.this.model.removeElement(v);
                    }
                    TagSpec.this.fireChangeEvent();
                }
            }
        }

        private class ClearAction
        extends AbstractAction {
            public ClearAction() {
                super("Clear");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TagPanel.this.model.clear();
                TagSpec.this.fireChangeEvent();
            }
        }
    }
}

