/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelAreaImage;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerListenerAdapter;
import com.mandelsoft.mand.tool.AbstractMandelListTableModel;
import com.mandelsoft.mand.tool.ColorListModel;
import com.mandelsoft.mand.tool.ColormapListModel;
import com.mandelsoft.mand.tool.ComposedMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.DefaultColormapListModel;
import com.mandelsoft.mand.tool.DefaultMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.DefaultMandelListTableModel;
import com.mandelsoft.mand.tool.ExtendedColormapListModel;
import com.mandelsoft.mand.tool.ImageBaseModel;
import com.mandelsoft.mand.tool.InitialStartupFrame;
import com.mandelsoft.mand.tool.LinkFolderTreeModel;
import com.mandelsoft.mand.tool.LinkListener;
import com.mandelsoft.mand.tool.MandelImageFrame;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListModel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.TagListModel;
import com.mandelsoft.mand.tool.ToolControlFrame;
import com.mandelsoft.mand.tool.lists.MandelListsMenuFactory;
import com.mandelsoft.mand.util.MandelColormapCache;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.swing.WindowControlAction;
import java.awt.SplashScreen;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class ToolEnvironment
extends Environment {
    private JFileChooser fileChooser;
    private InitialStartupFrame control;
    private ToolControlAction toolControl;
    private int windowcnt;
    private boolean doexit = false;
    private ColorListModel colors;
    private TagListModel tags;
    private TagListModel attrs;
    private MandelListFolderTreeModel tfavorites;
    private MandelListFolderTreeModel memory;
    private MandelListTableModel favorites;
    private MandelListFolderTreeModel ttodos;
    private MandelListTableModel todos;
    private LinkFolderTreeModel tlinks;
    private AreasModel areas;
    private NewRasterModel newrasters;
    private UnseenRasterModel unseenrasters;
    private MandelListTableModel variants;
    private MandelListTableModel leafs;
    private MandelListTableModel pending;
    private MandelListTableModel unseenrefinements;
    private MandelListTableModel refinerequests;
    private MandelListTableModel requests;
    private ComposedMandelListFolderTreeModel lists;
    private ColormapListModel colormaps;
    private ColormapListModel areacolormaps;
    private MandelListsMenuFactory listactions;
    private ImageBaseModel imagebase_model;
    private MandelColormapCache colormap_cache;
    private DefaultListModel frames = new DefaultListModel();
    private Map<MandelListTableModel, Boolean> refresh_pending;
    private List<MandelListTableModel> refresh_order;
    private Set<Listener> listeners = new HashSet<Listener>();
    private boolean listenerActive;

    public ToolEnvironment(String[] args) throws IllegalConfigurationException {
        super("mandtool", args);
        this.setup();
    }

    public ToolEnvironment(String[] args, File dir) throws IllegalConfigurationException {
        super("mandtool", args, dir);
        this.setup();
    }

    public ToolEnvironment(String[] args, URL dir) throws IllegalConfigurationException {
        super("mandtool", args, dir);
        this.setup();
    }

    private void setup() {
        List<MandelListFolderTree> tmp;
        int size = 80;
        String v = this.getProperty("cache.colormaps");
        if (v != null) {
            try {
                size = Integer.parseInt(v);
                if (size <= 0) {
                    size = 80;
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("illegal colormap cache size " + v + ": " + nfe);
            }
        }
        this.colormap_cache = new MandelColormapCache(size);
        Colormap cm = this.getDefaultColormap();
        if (cm != null) {
            this.colormap_cache.lock(QualifiedMandelName.ROOT, cm);
        }
        this.refresh_pending = new HashMap<MandelListTableModel, Boolean>();
        this.refresh_order = new ArrayList<MandelListTableModel>();
        this.toolControl = new ToolControlAction();
        int hires = 2000;
        v = this.getProperty("default.highres");
        if (v != null) {
            try {
                hires = Integer.parseInt(v);
                if (hires <= 0) {
                    hires = 2000;
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("illegal hig resolution minimum " + v + ": " + nfe);
            }
        }
        this.listactions = new MandelListsMenuFactory(this.isReadonly(), hires);
        if (!this.isReadonly()) {
            this.fileChooser = new JFileChooser();
        }
        if (this.getColors() != null) {
            this.colors = new ColorListModel(this.getColors());
            this.colors.setAutosave(!this.isReadonly());
        }
        if (this.getTags() != null) {
            this.tags = new TagListModel(this.getTags());
            this.tags.setAutosave(!this.isReadonly());
        }
        if (this.getAttrs() != null) {
            this.attrs = new TagListModel(this.getAttrs());
            this.attrs.addUniqueElement("reference-redo");
            this.attrs.addUniqueElement("title");
            this.attrs.addUniqueElement("pixel-iteration-method");
            this.attrs.addUniqueElement("reference-coordinates");
            this.attrs.addUniqueElement("reference-pixel");
            this.attrs.setAutosave(!this.isReadonly());
        }
        if (this.getAreas() != null) {
            this.areas = new AreasModel();
        }
        if (this.getFavorites() != null) {
            this.tfavorites = this.getMandelListFolderTreeModel(this.getFavorites());
            this.favorites = this.tfavorites.getMandelListModel(this.tfavorites.getRoot());
        }
        this.memory = new GeneralFolderTreeModel(this.getMemory(), true);
        if (this.getTodos() != null) {
            this.ttodos = this.getMandelListFolderTreeModel(this.getTodos());
            this.todos = this.ttodos.getMandelListModel(this.ttodos.getRoot());
        }
        if (this.getLinks() != null) {
            this.tlinks = new LinkFolderTreeModel(this.getLinks(), this.getAllScanner(), this.isReadonly());
        }
        if (this.getNewRasters() != null) {
            this.newrasters = new NewRasterModel();
        }
        if (this.getUnseenRasters() != null) {
            this.unseenrasters = new UnseenRasterModel();
        }
        this.variants = new VariantsModel();
        this.leafs = new LeafModel();
        this.pending = new PendingModel();
        if (this.getRefinementRequests() != null) {
            this.refinerequests = new RefinementRequestsModel();
        }
        if (this.getUnseenRefinements() != null) {
            this.unseenrefinements = new UnseenRefinementModel();
        }
        if (this.getRequests() != null) {
            this.requests = new RequestsModel();
        }
        this.lists = new ComposedMandelListFolderTreeModel("lists", this.getAllScanner());
        this.lists.setModifiable(!this.isReadonly());
        if (this.unseenrasters != null) {
            this.lists.addListModel((MandelListTableModel)this.unseenrasters, "unseen", "list of image areas not yet seen");
        }
        this.lists.addFolderTreeModel(this.memory, this.memory.getRoot().getName());
        this.lists.addListModel(this.variants, "variants");
        if (this.tfavorites != null) {
            this.lists.addFolderTreeModel(this.tfavorites, "favorites");
        }
        if (this.ttodos != null) {
            this.lists.addFolderTreeModel(this.ttodos, "todo");
        }
        if (this.tlinks != null) {
            this.lists.addFolderTreeModel(this.tlinks, "links");
        }
        if (this.areas != null) {
            this.lists.addListModel((MandelListTableModel)this.areas, "areas", "list of marked area roots for backward navigation");
        }
        if (this.newrasters != null) {
            this.lists.addListModel((MandelListTableModel)this.newrasters, "new", "list of finished areas not yet examined");
        }
        if (this.leafs != null) {
            this.lists.addListModel(this.leafs, "leafs", "list of areas without further sub areas");
        }
        if (this.pending != null) {
            this.lists.addListModel(this.pending, "pending", "list of areas with pending sub area calculations");
        }
        if (!(tmp = this.getUserLists()).isEmpty()) {
            ComposedMandelListFolderTreeModel userlists = new ComposedMandelListFolderTreeModel("misc", this.getAllScanner());
            for (MandelListFolderTree t : tmp) {
                userlists.addFolderTreeModel(this.getMandelListFolderTreeModel(t), t.getRoot().getName());
            }
            this.lists.addFolderTreeModel(userlists, "misc");
        }
        this.colormaps = new ExtendedColormapListModel(this.getColormaps());
        this.areacolormaps = new DefaultColormapListModel(this.getAreaColormaps());
        this.imagebase_model = new ImageBaseModel(this);
    }

    public ImageBaseModel getImagebaseModel() {
        return this.imagebase_model;
    }

    public void addLink(MandelName src, MandelName dst) {
        if (this.tlinks == null || this.isReadonly()) {
            return;
        }
        this.tlinks.addLink(src, dst);
    }

    public void removeLink(MandelName src, MandelName dst) {
        if (this.tlinks == null || this.isReadonly()) {
            return;
        }
        this.tlinks.removeLink(src, dst);
    }

    public LinkFolderTreeModel getLinkModel() {
        return this.tlinks;
    }

    public MandelListModel getLinkModel(MandelName n) {
        if (this.tlinks == null) {
            return null;
        }
        return this.tlinks.getLinkModel(n);
    }

    public void addLinkListener(LinkListener h) {
        if (this.tlinks != null) {
            this.tlinks.addLinkListener(h);
        }
    }

    public void removeLinkListener(LinkListener h) {
        if (this.tlinks != null) {
            this.tlinks.removeLinkListener(h);
        }
    }

    public synchronized MandelColormapCache getColormapCache() {
        return this.colormap_cache;
    }

    public WindowControlAction getToolControlAction() {
        return this.toolControl;
    }

    public MandelListsMenuFactory getListActions() {
        return this.listactions;
    }

    public synchronized JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public MandelListFolderTreeModel getMandelListFolderTreeModel() {
        return this.lists;
    }

    public ColorListModel getColorsModel() {
        return this.colors;
    }

    public TagListModel getTagsModel() {
        return this.tags;
    }

    public TagListModel getAttributeModel() {
        return this.attrs;
    }

    public MandelListTableModel getFavoritesModel() {
        return this.favorites;
    }

    public MandelListTableModel getTodosModel() {
        return this.todos;
    }

    public MandelListTableModel getMemoryModel() {
        return this.memory.getMandelListModel(this.memory.getRoot());
    }

    public MandelListTableModel getAreasModel() {
        return this.areas;
    }

    public MandelListTableModel getNewRastersModel() {
        return this.newrasters;
    }

    public MandelListTableModel getUnseenRastersModel() {
        return this.unseenrasters;
    }

    public MandelListTableModel getPendingModel() {
        return this.pending;
    }

    public MandelListTableModel getVariantsModel() {
        return this.variants;
    }

    public MandelListTableModel getUnseenRefinementsModel() {
        return this.unseenrefinements;
    }

    public MandelListTableModel getRefinementRequestsModel() {
        return this.refinerequests;
    }

    public MandelListTableModel getRequestsModel() {
        return this.requests;
    }

    public ColormapListModel getColormapListModel() {
        return this.colormaps;
    }

    public ColormapListModel getAreaColormapListModel() {
        return this.areacolormaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRasterSeen(AbstractFile f) {
        boolean b;
        this.startUpdate();
        try {
            b = super.handleRasterSeen(f);
            if (b && this.newrasters != null) {
                QualifiedMandelName name = QualifiedMandelName.create(f);
                System.out.println("remove from new rasters " + f);
                this.newrasters.setModifiable(true);
                this.newrasters.remove(name);
                this.newrasters.setModifiable(false);
            }
        }
        finally {
            this.finishUpdate();
        }
        return b;
    }

    @Override
    protected void seenModified() {
        super.seenModified();
        if (this.unseenrasters != null) {
            this.unseenrasters.fireTableDataChanged();
        }
    }

    @Override
    protected void unseenRefinementsModified() {
        super.unseenRefinementsModified();
        if (this.unseenrefinements != null) {
            if (debug) {
                System.out.println("unseen refinements modified");
            }
            this.unseenrefinements.fireTableDataChanged();
        }
    }

    public ListModel getMandelWindowsModel() {
        return this.frames;
    }

    private void setupFrame(JFrame frame) {
        new FrameListener(frame);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        this.incrementWindowCount();
    }

    public synchronized void createControlFrame() {
        if (this.control == null) {
            this.control = new InitialStartupFrame(this);
            this.setupFrame(this.control);
        }
    }

    public synchronized void createMandelImageFrame(String n) throws IOException {
        QualifiedMandelName name;
        File f = new File(n);
        if (f.getName().equals(n)) {
            try {
                QualifiedMandelName name2 = QualifiedMandelName.create(f);
                this.createMandelImageFrame(name2);
                return;
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(n + " is no mandel name.");
            }
        }
        String base = f.getName();
        try {
            name = QualifiedMandelName.create(f);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException(n + " is no mandel name.");
        }
        MandelData md = new MandelData(f);
        MandelImage img = this.getFactory().getImage(md);
        if (img == null) {
            throw new IOException(n + ": no image.");
        }
        this.setupFrame(new MandelImageFrame(this, new MandelAreaImage(name, img)));
    }

    public synchronized void createMandelImageFrame(MandelName mn) throws IOException {
        this.createMandelImageFrame(this.getMandelImage(mn));
    }

    public synchronized void createMandelImageFrame(MandelAreaImage img) throws IOException {
        this.setupFrame(new MandelImageFrame(this, img));
    }

    public synchronized void createMandelImageFrame(MandelAreaImage img, int maxx) throws IOException {
        this.setupFrame(new MandelImageFrame(this, img, maxx));
    }

    public synchronized void createMandelImageFrame(QualifiedMandelName mn) throws IOException {
        MandelAreaImage img = this.getMandelImage(mn);
        if (img != null) {
            this.createMandelImageFrame(img);
        }
    }

    public synchronized void createMandelImageFrame(QualifiedMandelName mn, ColormapModel cm) throws IOException {
        MandelAreaImage img = this.getMandelImage(mn, cm);
        if (img != null) {
            this.createMandelImageFrame(img);
        }
    }

    public synchronized void createMandelImageFrame(QualifiedMandelName mn, int maxx) throws IOException {
        MandelAreaImage img = this.getMandelImage(mn);
        if (img != null) {
            this.createMandelImageFrame(img, maxx);
        }
    }

    public synchronized void createMandelImageFrame(QualifiedMandelName mn, ColormapModel cm, int maxx) throws IOException {
        MandelAreaImage img = this.getMandelImage(mn, cm);
        if (img != null) {
            this.createMandelImageFrame(img, maxx);
        }
    }

    public synchronized void createMandelImageFrame(File f) throws IOException {
        MandelImage img = this.getFactory().getImage(f);
        if (img != null) {
            QualifiedMandelName name = QualifiedMandelName.create(f);
            if (name == null) {
                name = QualifiedMandelName.create("unknown-unknown");
            }
            this.createMandelImageFrame(new MandelAreaImage(name, img));
        }
    }

    public synchronized void incrementWindowCount() {
        ++this.windowcnt;
    }

    public synchronized void decrementWindowCount() {
        --this.windowcnt;
        if (this.windowcnt <= 0 && this.doexit) {
            System.exit(0);
        }
    }

    public synchronized void startup() {
        this.doexit = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashScreen sp = SplashScreen.getSplashScreen();
                if (sp != null) {
                    sp.close();
                }
                if (ToolEnvironment.this.getInitialFile() != null) {
                    try {
                        ToolEnvironment.this.createMandelImageFrame(ToolEnvironment.this.getInitialFile());
                    }
                    catch (IOException io) {
                        System.err.println("cannot load file " + ToolEnvironment.this.getInitialFile() + ": " + io);
                        System.exit(1);
                    }
                } else if (ToolEnvironment.this.getImageDataScanner().getMandelHandle(ToolEnvironment.this.getInitialName()) != null) {
                    try {
                        ToolEnvironment.this.createMandelImageFrame(ToolEnvironment.this.getInitialName());
                    }
                    catch (IOException ex) {
                        ToolEnvironment.this.createControlFrame();
                    }
                } else {
                    ToolEnvironment.this.createControlFrame();
                }
            }
        });
    }

    public MandelListFolderTreeModel getMandelListFolderTreeModel(MandelListFolderTree l) {
        return new GeneralFolderTreeModel(l, !this.isReadonly());
    }

    public MandelListTableModel getMandelListModel(String path) {
        String[] comps;
        MandelListFolderTreeModel fm = this.getMandelListFolderTreeModel();
        MandelListFolder f = fm.getRoot();
        for (String comp : comps = path.split("/")) {
            if (debug) {
                System.out.println("lookup " + comp);
            }
            if (!comp.isEmpty() && (f = f.getSubFolder(comp)) == null) break;
        }
        if (f == null) {
            return null;
        }
        MandelListTableModel model = fm.getMandelListModel(f);
        return model;
    }

    public void refresh(MandelListTableModel m, boolean soft) {
        if (!this.isInUpdate()) {
            m.refresh(soft);
        } else {
            Boolean v = this.refresh_pending.get(m);
            if (v == null) {
                this.refresh_pending.put(m, soft);
                this.refresh_order.add(m);
            } else if (v.booleanValue() && !soft) {
                this.refresh_pending.put(m, soft);
            }
        }
    }

    @Override
    protected void handleUpdate() {
        super.handleUpdate();
        while (!this.refresh_order.isEmpty()) {
            MandelListTableModel m = this.refresh_order.get(0);
            m.refresh(this.refresh_pending.get(m));
            this.refresh_order.remove(0);
            this.refresh_pending.remove(m);
        }
        this.imagebase_model.handleUpdate();
    }

    public synchronized void addEnvironmentListener(Listener l) {
        if (this.listenerActive) {
            this.listeners = new HashSet<Listener>(this.listeners);
        }
        this.listeners.add(l);
    }

    public synchronized void removeEnvironmentListener(Listener l) {
        if (this.listenerActive) {
            this.listeners = new HashSet<Listener>(this.listeners);
        }
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireMandelListDeleted(MandelList list) {
        try {
            this.listenerActive = true;
            for (Listener l : this.listeners) {
                l.mandelListDeleted(list);
            }
        }
        finally {
            this.listenerActive = false;
        }
    }

    private class ToolControlAction
    extends WindowControlAction {
        public ToolControlAction() {
            super((Window)null, "Tool Control", new Creator());
        }
    }

    private class AreasModel
    extends DefaultMandelListTableModel {
        public AreasModel() {
            super(ToolEnvironment.this.getAreas(), ToolEnvironment.this.getImageDataScanner());
            this.setModifiable(!ToolEnvironment.this.isReadonly());
        }
    }

    private class GeneralFolderTreeModel
    extends DefaultMandelListFolderTreeModel {
        public GeneralFolderTreeModel(MandelListFolderTree tree, boolean mod2) {
            super(tree, ToolEnvironment.this.getAllScanner());
            this.setModifiable(mod2);
        }
    }

    private class NewRasterModel
    extends AutoRefreshMandelListTableModel {
        public NewRasterModel() {
            super(ToolEnvironment.this.getNewRasters(), ToolEnvironment.this.getNewRasterScanner());
        }
    }

    private class UnseenRasterModel
    extends AutoRefreshMandelListTableModel {
        public UnseenRasterModel() {
            super(ToolEnvironment.this.getUnseenRasters(), ToolEnvironment.this.getImageDataScanner());
            this.addAction(new SyncNewAction());
        }

        private class SyncNewAction
        extends AbstractAction {
            public SyncNewAction() {
                super("Sync New");
                this.putValue("ShortDescription", "Synchoronize with new images");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MandelList unseen = UnseenRasterModel.this.getList();
                MandelList n = ToolEnvironment.this.getNewRasters();
                n.refresh(false);
                ToolEnvironment.this.refresh(unseen);
                unseen.retainAll(n);
                try {
                    unseen.save();
                }
                catch (IOException ex) {
                    System.err.println("cannot write seen: " + ex);
                }
                UnseenRasterModel.this.fireTableDataChanged();
            }
        }
    }

    private class VariantsModel
    extends AutoRefreshMandelListTableModel {
        public VariantsModel() {
            super(ToolEnvironment.this.getVariants(), ToolEnvironment.this.getImageDataScanner());
        }
    }

    private class LeafModel
    extends AutoRefreshMandelListTableModel {
        public LeafModel() {
            super(ToolEnvironment.this.getLeafs(), ToolEnvironment.this.getImageDataScanner(), ToolEnvironment.this.getAllScanner());
        }
    }

    private class PendingModel
    extends AutoRefreshMandelListTableModel {
        public PendingModel() {
            super(ToolEnvironment.this.getPending(), ToolEnvironment.this.getImageDataScanner(), ToolEnvironment.this.getAllScanner());
        }
    }

    private class RefinementRequestsModel
    extends AutoRefreshMandelListTableModel {
        public RefinementRequestsModel() {
            super(ToolEnvironment.this.getRefinementRequests(), ToolEnvironment.this.getInfoScanner());
        }
    }

    private class UnseenRefinementModel
    extends AutoRefreshMandelListTableModel {
        public UnseenRefinementModel() {
            super(ToolEnvironment.this.getUnseenRefinements(), ToolEnvironment.this.getImageDataScanner());
        }
    }

    private class RequestsModel
    extends AutoRefreshMandelListTableModel {
        public RequestsModel() {
            super(ToolEnvironment.this.getRequests(), ToolEnvironment.this.getInfoScanner(), ToolEnvironment.this.getAllScanner());
        }
    }

    private class FrameListener
    extends WindowAdapter {
        private JFrame frame;

        public FrameListener(JFrame frame) {
            this.frame = frame;
            if (frame instanceof MandelImageFrame) {
                ToolEnvironment.this.frames.addElement(frame);
            }
            frame.addWindowListener(this);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            ToolEnvironment.this.decrementWindowCount();
            if (ToolEnvironment.this.control == e.getSource()) {
                ToolEnvironment.this.control = null;
            }
            this.frame.removeWindowListener(this);
            ToolEnvironment.this.frames.removeElement(e.getSource());
        }
    }

    public static interface Listener {
        public void mandelListDeleted(MandelList var1);
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void mandelListDeleted(MandelList list) {
        }
    }

    public class AutoRefreshMandelListTableModel
    extends DefaultMandelListTableModel {
        private MandelScanner refresh;

        public AutoRefreshMandelListTableModel(MandelList list, MandelScanner scanner) {
            this(list, scanner, scanner);
        }

        public AutoRefreshMandelListTableModel(MandelList list, MandelScanner listscanner, MandelScanner refreshscanner) {
            super(list, listscanner);
            this.refresh = refreshscanner;
            if (this.refresh != null) {
                this.refresh.addMandelScannerListener(new Listener());
            }
        }

        private class Listener
        extends MandelScannerListenerAdapter {
            private Listener() {
            }

            @Override
            public void addMandelFile(MandelScanner s, MandelHandle h) {
                this.handleEnvironmentChange();
            }

            @Override
            public void removeMandelFile(MandelScanner s, MandelHandle h) {
                this.handleEnvironmentChange();
            }

            @Override
            public void scannerChanged(MandelScanner s) {
                this.handleEnvironmentChange();
            }

            private void handleEnvironmentChange() {
                if (!AutoRefreshMandelListTableModel.this.isInUpdate()) {
                    if (AbstractMandelListTableModel.debug) {
                        System.out.println("soft refresh for scanner refresh: " + AutoRefreshMandelListTableModel.this);
                    }
                    ToolEnvironment.this.refresh(AutoRefreshMandelListTableModel.this, true);
                }
            }
        }
    }

    private class Creator
    implements WindowControlAction.WindowCreator {
        private Creator() {
        }

        public Window createWindow(Window owner) {
            return new ToolControlFrame(ToolEnvironment.this);
        }
    }
}

