/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.cm;

import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.cm.Colormaps;
import com.mandelsoft.mand.cm.InterpolationPoint;
import com.mandelsoft.mand.cm.InterpolationPointEvent;
import com.mandelsoft.mand.cm.InterpolationPointEventListener;
import com.mandelsoft.mand.tool.DefaultPositionSelectionModel;
import com.mandelsoft.mand.tool.PositionSelectionModel;
import com.mandelsoft.mand.tool.cm.ColorChooser;
import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.swing.ScaleEvent;
import com.mandelsoft.swing.ScaleEventListener;
import com.mandelsoft.swing.colorchooser.ColorImageModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColormapComponent
extends BufferedComponent {
    public static boolean debug = false;
    public static final int PIX_X = 1;
    public static final int PIX_Y = 1;
    public static final int COL_X = 3;
    public static final int COL_Y = 44;
    public static final int IP_H = 6;
    private Colormap colormap;
    private Graphics2D g;
    private Map<InterpolationPoint, IPUI> ipuis;
    private Window owner;
    private ColormapModel model;
    private int highlight = -1;
    private ColorImageModel cim;
    private ChangeListener cl = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            ColormapModel m = (ColormapModel)e.getSource();
            if (debug) {
                System.out.println("colormap model change event");
            }
            if (ColormapComponent.this.colormap != m.getColormap()) {
                if (debug) {
                    System.out.println("--> setting new colormap");
                }
                ColormapComponent.this.setColormap(m.getColormap());
            } else {
                ColormapComponent.this.redraw();
            }
        }
    };
    private InterpolationPointEventListener ipl = new InterpolationPointEventListener(){

        @Override
        public void stateChanged(InterpolationPointEvent e) {
            InterpolationPoint ip = e.getSource();
            if (e.getId() == 1 && ColormapComponent.this.ipuis != null && ColormapComponent.this.ipuis.get(ip) == null) {
                IPUI ui = new IPUI(ip);
                ColormapComponent.this.ipuis.put(ip, ui);
                ColormapComponent.this.repaint();
            }
        }
    };
    private static int cnt = 0;
    static Cursor move_cursor = Cursor.getPredefinedCursor(10);
    static Cursor cross_cursor = Cursor.getPredefinedCursor(1);
    static Cursor def_cursor = Cursor.getDefaultCursor();

    public ColormapComponent(Window owner) {
        this(owner, null);
    }

    public ColormapComponent(Window owner, ColormapModel model) {
        this.owner = owner;
        this.setBorder(new BevelBorder(1));
        this.setColormapModel(model == null ? new ColormapModel() : model);
        this.cim = new ColorImageModel();
        ML ml = new ML();
        this.addPaintHandler(new IndexHandler());
        this.getContentPane().addMouseListener(ml);
        this.getContentPane().addMouseMotionListener(ml);
        this.addScaleEventListener(new ScaleEventListener(){

            @Override
            public void componentScaled(ScaleEvent e) {
                if (debug) {
                    System.out.println("REPACK " + ++cnt);
                }
                ColormapComponent.this.repack();
            }

            @Override
            public boolean succeedScale(ScaleEvent e) {
                return (double)ColormapComponent.this.getImage().getWidth() * e.getScaleX() > 200.0 || e.getScaleX() >= e.getOldX();
            }
        });
        this.setScaleMode(1);
        if (debug) {
            System.out.println("scale colormap component");
        }
        this.setScaleX(3.0);
        this.setScaleY(44.0);
    }

    public boolean isModifiable() {
        return this.model.isModifiable();
    }

    public ColormapModel getColormapModel() {
        return this.model;
    }

    public void setColormapModel(ColormapModel m) {
        if (this.model != null) {
            this.model.removeChangeListener(this.cl);
            this.model.removeInterpolationPointEventListener(this.ipl);
        }
        this.model = m;
        this.model.addChangeListener(this.cl);
        this.model.addInterpolationPointEventListener(this.ipl);
        this.setColormap(m.getColormap());
    }

    private void setColormap(Colormap map) {
        if (this.colormap == map) {
            return;
        }
        if (map == null) {
            if (debug) {
                System.out.println("clear colormap in dialog");
            }
        } else if (debug) {
            System.out.println("set colormap in dialog " + map.getSize());
        }
        if (this.ipuis != null) {
            for (IPUI ipui : this.ipuis.values()) {
                ipui.cleanup();
            }
        }
        this.colormap = map;
        this.highlight = -1;
        if (this.colormap != null) {
            this.setImage(new BufferedImage(map.getSize() * 1, 1, 1));
            this.ipuis = new HashMap<InterpolationPoint, IPUI>();
            for (InterpolationPoint ip : this.model.getInterpolationPoints()) {
                if (debug) {
                    System.out.println("found ip " + ip.getIndex() + ": " + ip.getColor());
                }
                this.ipuis.put(ip, new IPUI(ip));
            }
        }
        this.g = this.createGraphics();
        this.repack();
    }

    private void repack() {
        this.redraw();
        this.revalidate();
        Container c = this;
        while (!(c instanceof Window) && c.getParent() != null) {
            c = c.getParent();
        }
        if (c != null && c instanceof Window) {
            Window w = (Window)c;
            w.pack();
            w.repaint();
        }
    }

    public void redraw() {
        if (this.colormap != null) {
            for (int i = 0; i < this.colormap.getSize(); ++i) {
                this.g.setColor(this.colormap.getColor(i));
                this.g.fillRect(i * 1, 0, 1, 1);
            }
            this.repaint();
        }
    }

    public void highLight(int ix) {
        if (this.highlight != ix) {
            this.repaint();
        }
        this.highlight = ix;
    }

    private InterpolationPoint getInterpolationPoint(int index, int x) {
        Iterator<InterpolationPoint> i = this.model.interpolationPoints();
        while (i.hasNext()) {
            InterpolationPoint ip = i.next();
            IPUI ipui = this.ipuis.get(ip);
            if (!ipui.match(x)) continue;
            return ip;
        }
        return this.model.getInterpolationPoint(index);
    }

    private InterpolationPoint getInterpolationPoint(MouseEvent e) {
        int index = this.translateC(e);
        if (!this.valid(index)) {
            return null;
        }
        return this.getInterpolationPoint(index, e.getX());
    }

    private int middleX(int c) {
        int x = this.translateColorToComponent(c) + (int)this.getScaleX() / 2;
        return x;
    }

    private int translateC(Point2D p) {
        return this.translateX(ColormapComponent.toInt(p.getX()) / 1);
    }

    private int translateC(MouseEvent e) {
        return this.translateC(e.getPoint());
    }

    private int translateColorToComponent(double c) {
        return this.translateToComponentX(ColormapComponent.toInt(c * 1.0));
    }

    private boolean valid(int index) {
        if (!this.isModifiable()) {
            return false;
        }
        return index >= 1 && index < this.colormap.getSize();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestFrame frame = new TestFrame();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    public class ML
    extends MouseAdapter {
        private InterpolationPoint current = null;

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = ColormapComponent.this.translateC(e);
            if (!ColormapComponent.this.valid(index)) {
                return;
            }
            InterpolationPoint ip = ColormapComponent.this.getInterpolationPoint(index, e.getX());
            if (debug) {
                System.out.println("clicked " + index + ": " + e);
            }
            if (e.getButton() == 1 && e.getClickCount() == 1) {
                if (!e.isControlDown()) {
                    if (ip == null) {
                        if (debug) {
                            System.out.println("  create " + index);
                        }
                        ColormapComponent.this.model.createInterpolationPoint(index);
                        ColormapComponent.this.setCursor(cross_cursor);
                    } else {
                        IPUI ui = (IPUI)ColormapComponent.this.ipuis.get(ip);
                        if (debug) {
                            System.out.println("  found " + ip.toString());
                        }
                        ui.showChooser();
                    }
                } else if (ip != null) {
                    ip.delete();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int index = ColormapComponent.this.translateC(e);
            if (!ColormapComponent.this.valid(index)) {
                return;
            }
            if (this.current != null && !this.current.isFixed()) {
                if (index <= this.current.getPrev().getIndex()) {
                    index = this.current.getPrev().getIndex() + 1;
                }
                if (index >= this.current.getNext().getIndex()) {
                    index = this.current.getNext().getIndex() - 1;
                }
                this.current.setIndex(index, true);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            InterpolationPoint ip = ColormapComponent.this.getInterpolationPoint(e);
            if (e.getButton() == 1 && ip != null) {
                if (debug) {
                    System.out.println("select " + ip.getIndex());
                }
                ColormapComponent.this.setCursor(move_cursor);
                this.current = ip;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            InterpolationPoint ip = ColormapComponent.this.getInterpolationPoint(e);
            if (e.getButton() == 1 && this.current != null) {
                if (debug) {
                    System.out.println("reset cursor2");
                }
                ColormapComponent.this.setCursor(def_cursor);
                this.current = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            InterpolationPoint ip = ColormapComponent.this.getInterpolationPoint(e);
            if (ip == null) {
                ColormapComponent.this.setCursor(def_cursor);
            } else {
                ColormapComponent.this.setCursor(cross_cursor);
            }
        }
    }

    private class IndexHandler
    implements BufferedComponent.PaintHandler {
        private BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);

        private IndexHandler() {
        }

        @Override
        public void paintComponent(Graphics g) {
            for (IPUI ui : ColormapComponent.this.ipuis.values()) {
                ui.paintComponent(g);
            }
            if (ColormapComponent.this.highlight >= 0) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.RED);
                g2.setStroke(this.stroke);
                g2.drawLine(ColormapComponent.this.middleX(ColormapComponent.this.highlight), 0, ColormapComponent.this.middleX(ColormapComponent.this.highlight), 44);
            }
        }
    }

    public class IPUI
    implements InterpolationPointEventListener {
        private InterpolationPoint ip;
        private ColorChooser chooser;
        private SliderSample slider;
        private ChangeListener colorListener;
        private ChangeListener positionListener;
        private int last_index;

        private IPUI(InterpolationPoint ip) {
            this.ip = ip;
            ip.addInterpolationPointEventListener(this);
            this.colorListener = new ChangeListener(){
                final /* synthetic */ IPUI this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    ColorSelectionModel m = (ColorSelectionModel)e.getSource();
                    if (debug) {
                        System.out.println("color from dialog: " + m.getSelectedColor());
                    }
                    this.this$1.ip.setColor(m.getSelectedColor());
                }
            };
            this.positionListener = new ChangeListener(){
                final /* synthetic */ IPUI this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    PositionSelectionModel m = (PositionSelectionModel)e.getSource();
                    if (debug) {
                        System.out.println("position from dialog: " + m.getSelectedPosition());
                    }
                    this.this$1.ip.setRelativePosition(m.getSelectedPosition());
                }
            };
        }

        private void cleanup() {
            this.ip.removeInterpolationPointEventListener(this);
            this.disposeChooser();
        }

        private void setupChooser() {
            if (this.chooser == null) {
                this.chooser = new ColorChooser(ColormapComponent.this.owner);
                this.chooser.setColorImageModel(ColormapComponent.this.cim);
                this.chooser.setModal(false);
                this.chooser.setDefaultCloseOperation(1);
                this.chooser.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent we) {
                        if (debug) {
                            System.out.println("closing color edit for " + IPUI.this.ip.getIndex());
                        }
                    }
                });
                this.chooser.getSelectionModel().addChangeListener(this.colorListener);
                if (!this.ip.isFixed()) {
                    this.slider = new SliderSample(200, 20);
                    this.chooser.setSampleComponent(this.slider);
                    this.slider.getPositionSelectionModel().setSelectedPosition(this.ip.getRelativePosition());
                    this.slider.getPositionSelectionModel().addChangeListener(this.positionListener);
                }
            }
        }

        public void showChooser() {
            this.setupChooser();
            this.chooser.setColor(this.ip.getColor());
            this.chooser.getSelectionModel().addChangeListener(this.colorListener);
            this.chooser.setVisible(true);
        }

        private void disposeChooser() {
            if (this.chooser != null) {
                this.chooser.getSelectionModel().removeChangeListener(this.colorListener);
                this.chooser.dispose();
                this.chooser = null;
            }
        }

        private void paintComponent(Graphics g) {
            this.last_index = this.ip.getIndex();
            int x = ColormapComponent.this.middleX(this.last_index) - 1;
            g.setColor(Color.WHITE);
            g.fillRect(x, 0, 3, 6);
            g.setColor(Color.BLACK);
            g.fillRect(x, 38, 3, 6);
        }

        public boolean match(int x) {
            int l = ColormapComponent.this.middleX(this.last_index) - 1;
            return l <= x && x < l + 3;
        }

        @Override
        public void stateChanged(InterpolationPointEvent ipe) {
            if (ipe.getId() == 5) {
                if (this.slider != null) {
                    this.slider.getPositionSelectionModel().setSelectedPosition(this.ip.getRelativePosition());
                }
            } else {
                if (ipe.getId() == 2) {
                    ColormapComponent.this.ipuis.remove(this.ip);
                    this.cleanup();
                }
                ColormapComponent.this.repaint();
            }
        }
    }

    static class TestFrame
    extends JFrame {
        ColormapComponent cc;
        ColormapModel model;

        TestFrame() {
            this.setup();
        }

        void setup() {
            this.cc = new ColormapComponent(this);
            this.model = new ColormapModel();
            this.model.setColormap(new Colormaps.Simple(256, Color.BLUE, Color.WHITE));
            this.model.setModifiable(true);
            this.add(this.cc);
            this.cc.setColormapModel(this.model);
            this.pack();
            this.setResizable(false);
        }
    }

    public class SliderSample
    extends ColorChooser.ColorSample {
        public static final int W = 2;
        private Insets insets;
        private ChangeListener adjustHandler;
        private PositionSelectionModel position;

        public SliderSample(int width, int height) {
            super(width, height);
            this.adjustHandler = new AdjustHandler();
            this.insets = new Insets(0, 0, 0, 0);
            SliderHandler h = new SliderHandler();
            this.adjustHandler = new AdjustHandler();
            this.addMouseListener(h);
            this.addMouseMotionListener(h);
            this.getInsets(this.insets);
            this.setPositionSelectionModel(new DefaultPositionSelectionModel());
        }

        public void setPositionSelectionModel(PositionSelectionModel p) {
            if (this.position != null) {
                this.position.removeChangeListener(this.adjustHandler);
            }
            this.position = p;
            p.addChangeListener(this.adjustHandler);
        }

        public PositionSelectionModel getPositionSelectionModel() {
            return this.position;
        }

        protected int getPosition() {
            int max = this.getWidth() - this.insets.right - 4 - 1 - (this.insets.left + 2);
            int x = (int)(this.position.getSelectedPosition() * (double)max);
            return x + this.insets.left + 2;
        }

        protected void setPosition(int p) {
            int x = p - this.insets.left - 2;
            int max = this.getWidth() - this.insets.right - 4 - 1 - (this.insets.left + 2);
            this.getPositionSelectionModel().setSelectedPosition((double)x / (double)max);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.getInsets(this.insets);
            super.paintComponent(g);
            this.drawSlider(g);
        }

        private void drawSlider(Graphics g) {
            int i;
            int pos = this.getPosition();
            g.setColor(Color.BLACK);
            for (i = 1; i <= 2; ++i) {
                g.drawLine(pos - i, this.insets.top, pos - i, this.getHeight() - this.insets.bottom - 1);
                g.drawLine(pos + 2 + i - 1, this.insets.top, pos + 2 + i - 1, this.getHeight() - this.insets.bottom - 1);
            }
            g.setColor(Color.WHITE);
            for (i = 0; i < 2; ++i) {
                g.drawLine(pos + i, this.insets.top, pos + i, this.getHeight() - this.insets.bottom - 1);
            }
        }

        private class AdjustHandler
        implements ChangeListener {
            private AdjustHandler() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderSample.this.repaint();
            }
        }

        private class SliderHandler
        extends MouseAdapter {
            private boolean active;
            private int offset;

            private boolean isValidPosition(int x) {
                return x >= ((SliderSample)SliderSample.this).insets.left + 2 && x < SliderSample.this.getWidth() - ((SliderSample)SliderSample.this).insets.right - 4;
            }

            private int adjustPosition(int x) {
                if (x < ((SliderSample)SliderSample.this).insets.left + 2) {
                    return ((SliderSample)SliderSample.this).insets.left + 2;
                }
                if (x >= SliderSample.this.getWidth() - ((SliderSample)SliderSample.this).insets.right - 4) {
                    return SliderSample.this.getWidth() - ((SliderSample)SliderSample.this).insets.right - 4 - 1;
                }
                return x;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.active) {
                    int x = this.adjustPosition(e.getX() - this.offset);
                    SliderSample.this.setPosition(x);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SliderSample.this.getInsets(SliderSample.this.insets);
                if (e.getButton() == 1) {
                    int x = e.getX();
                    int position = SliderSample.this.getPosition();
                    if (debug) {
                        System.out.println("button pressed at " + x + ": " + SliderSample.this.insets);
                    }
                    if (x >= position - 2 && x < position + 4) {
                        this.offset = e.getX() - position;
                        this.active = true;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    this.active = false;
                }
            }
        }
    }
}

