/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.lists;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.DefaultMandelListTableModel;
import com.mandelsoft.mand.tool.MandelListDialog;
import com.mandelsoft.mand.tool.MandelNameMapper;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.util.MandelContextAction;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.lists.MandelBasenameSource;
import com.mandelsoft.mand.util.lists.MandelListFactory;
import java.awt.event.ActionEvent;

public abstract class MandelListViewAction
extends MandelContextAction {
    private MandelScanner scanner;
    private ActionEvent event;
    private MandelNameMapper mapper;

    public MandelListViewAction(String name) {
        super(name);
    }

    public MandelListViewAction(String name, MandelScanner scanner) {
        this(name);
        this.scanner = scanner;
    }

    public MandelListViewAction(String name, MandelScanner scanner, MandelNameMapper mapper) {
        this(name);
        this.scanner = scanner;
        this.mapper = mapper;
    }

    protected MandelWindowAccess getMandelWindowAccess() {
        return MandelListViewAction.getMandelWindowAccess(this.event);
    }

    protected ToolEnvironment getEnvironment() {
        return this.getMandelWindowAccess().getEnvironment();
    }

    protected MandelScanner getMandelScanner(ToolEnvironment env) {
        return env.getAllScanner();
    }

    protected MandelScanner getMandelScanner() {
        ToolEnvironment env;
        MandelWindowAccess acc2;
        if (this.scanner == null && this.event != null && (acc2 = MandelListViewAction.getMandelWindowAccess(this.event)) != null && (env = acc2.getEnvironment()) != null) {
            this.scanner = this.getMandelScanner(env);
        }
        return this.scanner;
    }

    protected ActionEvent getEvent() {
        return this.event;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        QualifiedMandelName n = this.getSelectedItem(e);
        if (n != null) {
            this.event = e;
            MandelListFactory factory = this.createFactory(n);
            Model model = new Model(this.getMandelScanner(), factory);
            MandelListDialog dia = new MandelListDialog(MandelListViewAction.getMandelWindowAccess(e), factory.getTitle(), model);
            dia.setMandelNameMapper(this.mapper);
            if (factory instanceof MandelBasenameSource) {
                dia.setRootName(((MandelBasenameSource)((Object)factory)).getBasename());
            }
            this.event = null;
        }
    }

    protected abstract MandelListFactory createFactory(QualifiedMandelName var1);

    protected static class Model
    extends DefaultMandelListTableModel {
        private MandelListFactory factory;

        public Model(MandelScanner scanner, MandelListFactory factory) {
            super(factory.getList(), scanner);
            this.factory = factory;
            this.setModifiable(false);
        }

        @Override
        public void refresh() {
            MandelList list = this.factory.getList();
            if (!this.getList().equals(list)) {
                this.setList(list);
            }
        }

        @Override
        public void refresh(Environment env) {
            this.refresh();
        }
    }
}

