/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.mapper;

import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.tool.mapper.CyclicMapperCreator;
import com.mandelsoft.mand.tool.mapper.MapperCreator;
import com.mandelsoft.mand.tool.mapper.OptimalMapperCreator;
import com.mandelsoft.mand.tool.mapper.StatisticMapperCreator;
import com.mandelsoft.swing.ChangeListenerSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MapperModel
extends AbstractListModel
implements ComboBoxModel {
    public static boolean debug = false;
    private List<MapperCreator> mappers;
    private MapperCreator selected;
    private ChangeListenerSupport listeners = new ChangeListenerSupport();
    private MapperListener listener = new MapperListener();

    public MapperModel() {
        this.mappers = new ArrayList<MapperCreator>();
        this.setup();
    }

    private void setup() {
        this.addCreator(new CyclicMapperCreator());
        this.addCreator(new StatisticMapperCreator());
        this.addCreator(new OptimalMapperCreator());
    }

    public MapperCreator getCreator(int index) {
        return this.mappers.get(index);
    }

    @Override
    public int getSize() {
        return this.mappers.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.mappers.get(index).getName();
    }

    public MapperCreator getElement(Object item) {
        for (MapperCreator c : this.mappers) {
            if (!item.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.selected != null) {
            this.selected.removeChangeListener(this.listener);
        }
        if (anItem == null) {
            this.selected = null;
        } else if (debug) {
            System.out.println("current select: " + this.selected);
        }
        for (MapperCreator c : this.mappers) {
            if (!anItem.equals(c.getName())) continue;
            if (debug) {
                System.out.println("found select: " + c);
            }
            MapperCreator old = this.selected;
            this.selected = c;
            this.selected.addChangeListener(this.listener);
            if (this.selected == old) continue;
            if (debug) {
                System.out.println("fire change event: " + this.selected.getName());
            }
            this.fireChangeEvent();
        }
    }

    @Override
    public Object getSelectedItem() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.getName();
    }

    public Mapper getMapper() {
        return this.selected.createMapper();
    }

    public void addCreator(MapperCreator c) {
        if (!this.mappers.contains(c)) {
            this.mappers.add(c);
            c.setVisible(false);
            if (this.selected == null) {
                this.selected = c;
            }
            this.fireContentsChanged(this, this.mappers.size() - 1, this.mappers.size() - 1);
        }
    }

    public void removeCreator(MapperCreator c) {
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (this.mappers.get(i) != c) continue;
            this.mappers.remove(c);
            if (this.selected == c) {
                this.selected = null;
            }
            this.fireContentsChanged(this, i, this.mappers.size());
        }
    }

    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    private void fireChangeEvent() {
        this.listeners.fireChangeEvent();
    }

    private class MapperListener
    implements ChangeListener {
        private MapperListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (debug) {
                System.out.println("mapper data changed");
            }
            MapperModel.this.fireChangeEvent();
        }
    }
}

