/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.slideshow;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListSelector;
import com.mandelsoft.mand.tool.MandelNameSelector;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.slideshow.SlideShowModel;
import com.mandelsoft.mand.tool.slideshow.SlideShowSource;
import com.mandelsoft.mand.tool.slideshow.SlideShowSourceAdapter;
import com.mandelsoft.mand.tool.util.MandelContextAction;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import javax.swing.JComponent;

public class DefaultSlideShowSource
extends SlideShowSourceAdapter {
    protected JComponent menu;
    protected Component comp;

    public DefaultSlideShowSource(JComponent menu, Component comp) {
        this.menu = menu;
        this.comp = comp;
    }

    @Override
    public SlideShowSource.ListMode getListMode(SlideShowModel model) {
        MandelListSelector ml = MandelContextAction.getEnvironmentObject(this.menu, MandelListSelector.class);
        if (ml == null) {
            ml = MandelContextAction.getEnvironmentObject(this.comp, MandelListSelector.class);
        }
        if (ml != null) {
            return new DefaultListMode(ml);
        }
        return null;
    }

    @Override
    public SlideShowSource.OneMode getOneMode(SlideShowModel model) {
        MandelNameSelector mn = this.getMandelNameSelector();
        if (mn != null) {
            return new DefaultOneMode(mn);
        }
        return null;
    }

    @Override
    public SlideShowSource.TwoMode getTwoMode(SlideShowModel model) {
        MandelNameSelector mn;
        MandelImagePanel mp = null;
        QualifiedMandelName s = model.getCurrentQualifiedMandelName();
        if (s == null) {
            MandelWindowAccess acc2 = MandelWindowAccess.Access.getMandelWindowAccess(this.comp);
            if (acc2 != null) {
                mp = acc2.getMandelImagePane();
            }
            if (mp == null) {
                return null;
            }
        }
        if ((mn = this.getMandelNameSelector()) != null) {
            return new DefaultTwoMode(mn);
        }
        return null;
    }

    protected MandelNameSelector getMandelNameSelector() {
        MandelNameSelector mn = MandelContextAction.getEnvironmentObject(this.menu, MandelNameSelector.class);
        if (mn == null) {
            mn = MandelContextAction.getEnvironmentObject(this.comp, MandelNameSelector.class);
        }
        return mn;
    }

    protected class DefaultListMode
    extends SlideShowSourceAdapter.ListModeAdapter {
        protected MandelListSelector selector;

        public DefaultListMode(MandelListSelector selector) {
            this.selector = selector;
        }

        @Override
        public MandelList getMandelList(SlideShowModel model) {
            return this.selector.getSelectedMandelList();
        }
    }

    protected class DefaultOneMode
    extends SlideShowSourceAdapter.OneModeAdapter {
        protected MandelNameSelector selector;

        public DefaultOneMode(MandelNameSelector selector) {
            this.selector = selector;
        }

        @Override
        public QualifiedMandelName getSingleName(SlideShowModel model) {
            return this.selector.getSelectedMandelName();
        }
    }

    protected class DefaultTwoMode
    extends SlideShowSourceAdapter.TwoModeAdapter {
        protected MandelNameSelector selector;

        public DefaultTwoMode(MandelNameSelector selector) {
            this.selector = selector;
        }

        @Override
        public QualifiedMandelName getFirstName(SlideShowModel model) {
            MandelImagePanel mp = null;
            QualifiedMandelName s = model.getCurrentQualifiedMandelName();
            if (s == null) {
                MandelWindowAccess acc2 = MandelWindowAccess.Access.getMandelWindowAccess(DefaultSlideShowSource.this.comp);
                if (acc2 != null) {
                    mp = acc2.getMandelImagePane();
                }
                if (mp != null) {
                    s = mp.getQualifiedMandelName();
                }
            }
            return s;
        }

        @Override
        public QualifiedMandelName getSecondName(SlideShowModel model) {
            QualifiedMandelName s = this.getFirstName(model);
            QualifiedMandelName n = this.selector.getSelectedMandelName();
            if (s == null || n == null) {
                return null;
            }
            if (Utils.equals(s.getMandelName(), n.getMandelName())) {
                return null;
            }
            return n;
        }
    }
}

