/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.slideshow;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.slideshow.AbstractSlideShow;
import com.mandelsoft.mand.tool.slideshow.SlideShowActionBase;
import com.mandelsoft.mand.tool.slideshow.SlideShowSource;
import com.mandelsoft.mand.util.MandelList;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class Journey
extends AbstractSlideShow {
    private List<QualifiedMandelName> list;
    private QualifiedMandelName start;
    private QualifiedMandelName end;
    private MandelName top;
    private QualifiedMandelName current;
    private MandelName next;
    private boolean up;
    private boolean highlight;

    Journey() {
        super("Journey", 5000);
        this.addAction(new JourneyAction());
        this.addAction(new ZoomInAction());
        this.addAction(new ZoomOutAction());
        this.addAction(new TripAction());
    }

    @Override
    public void startShow(MandelList list) {
        if (list.size() >= 2) {
            this.list = new ArrayList<QualifiedMandelName>(list);
            QualifiedMandelName start = this.list.get(0);
            this.list.remove(0);
            this.startShow(start, start);
        }
    }

    @Override
    public void startShow(QualifiedMandelName start, QualifiedMandelName end) {
        this.model.setActive(this);
        this._startShow(start, end);
        if (this.initiateNext()) {
            this.start();
        } else {
            this.cancel();
        }
    }

    private void _startShow(QualifiedMandelName start, QualifiedMandelName end) {
        System.out.println("start journey from " + start + " to " + end);
        this.up = true;
        this.highlight = false;
        this.start = start;
        this.end = end;
        this.top = start.getMandelName();
        while (!this.top.isAbove(end.getMandelName())) {
            this.top = this.top.getParentName();
        }
        System.out.println("top is " + this.top);
        if (!this.model.getCurrentQualifiedMandelName().equals(start)) {
            this.model.show(start);
        }
        this.current = start;
    }

    private boolean initiateNext() {
        if (this.current.equals(this.end)) {
            System.out.println("journey destination reached");
            if (this.list == null || this.list.size() == 0) {
                return false;
            }
            QualifiedMandelName n = this.list.get(0);
            this.list.remove(0);
            this._startShow(this.end, n);
            return this.initiateNext();
        }
        if (this.current.getMandelName().equals(this.top)) {
            System.out.println("journey top reached");
            this.up = false;
        }
        if (this.up) {
            this.next = this.current.getMandelName().getParentName();
            System.out.println("next up " + this.next);
        } else {
            this.next = this.current.getMandelName().sub(this.end.getMandelName());
            this.setInitialDelay(5000);
            System.out.println("next down " + this.next);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean cont = true;
        if (this.up) {
            System.out.println("handle up");
            if (!this.highlight) {
                QualifiedMandelName old = this.current;
                this.highlight = true;
                if (this.end.getMandelName().equals(this.next)) {
                    this.model.show(this.end);
                    this.current = this.end;
                } else {
                    this.model.show(this.next);
                    this.current = this.model.getCurrentQualifiedMandelName();
                }
                this.model.setHighLight(old);
            } else {
                this.highlight = false;
                cont = this.initiateNext();
            }
        } else {
            System.out.println("handle down " + this.highlight);
            QualifiedMandelName n = this.next.getName().equals(this.end.getMandelName()) ? this.end : new QualifiedMandelName(this.next);
            if (!this.highlight) {
                this.highlight = true;
                this.model.setHighLight(n);
            } else {
                this.highlight = false;
                this.model.show(n);
                this.current = this.model.getCurrentQualifiedMandelName();
                cont = this.initiateNext();
            }
        }
        if (cont) {
            System.out.println("start timer");
            this.start();
        } else {
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.list != null) {
            this.list.clear();
        }
    }

    private class JourneyAction
    extends SlideShowActionBase {
        protected JourneyAction(String name, int mode) {
            super(name, mode);
        }

        public JourneyAction() {
            this("Journey", 2);
        }

        protected QualifiedMandelName getStartName(ActionEvent e) {
            SlideShowSource.TwoMode m = Journey.this.model.getSource(e).getTwoMode(Journey.this.model);
            return m == null ? null : m.getFirstName(Journey.this.model);
        }

        protected QualifiedMandelName getEndName(ActionEvent e) {
            SlideShowSource.TwoMode m = Journey.this.model.getSource(e).getTwoMode(Journey.this.model);
            return m == null ? null : m.getSecondName(Journey.this.model);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                QualifiedMandelName start = this.getStartName(e);
                QualifiedMandelName end = this.getEndName(e);
                if (start != null && end != null) {
                    Journey.this.startShow(start, end);
                }
            }
        }
    }

    private class ZoomInAction
    extends ZoomAction {
        public ZoomInAction() {
            super("Zoom In");
        }

        @Override
        protected QualifiedMandelName getStartName(ActionEvent e) {
            return QualifiedMandelName.ROOT;
        }

        @Override
        protected QualifiedMandelName getEndName(ActionEvent e) {
            return this.getSingleName(e);
        }
    }

    private class ZoomOutAction
    extends ZoomAction {
        public ZoomOutAction() {
            super("Zoom Out");
        }

        @Override
        protected QualifiedMandelName getStartName(ActionEvent e) {
            return this.getSingleName(e);
        }

        @Override
        protected QualifiedMandelName getEndName(ActionEvent e) {
            return QualifiedMandelName.ROOT;
        }
    }

    private class TripAction
    extends SlideShowActionBase {
        public TripAction() {
            super("Trip", 4);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MandelList start;
            if (this.isEnabled() && (start = this.getMandelList(e)) != null) {
                Journey.this.startShow(start);
            }
        }

        protected MandelList getMandelList(ActionEvent e) {
            Object l = null;
            SlideShowSource.ListMode m = Journey.this.model.getSource(e).getListMode(Journey.this.model);
            return m == null ? null : m.getMandelList(Journey.this.model);
        }
    }

    private abstract class ZoomAction
    extends JourneyAction {
        public ZoomAction(String name) {
            super(name, 1);
        }

        protected QualifiedMandelName getSingleName(ActionEvent e) {
            SlideShowSource.OneMode m = Journey.this.model.getSource(e).getOneMode(Journey.this.model);
            return m == null ? null : m.getSingleName(Journey.this.model);
        }
    }
}

