/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.thumb;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapSourceFactory;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.thumb.AbstractThumbnailFactory;
import com.mandelsoft.mand.tool.thumb.ImageChangeListener;
import com.mandelsoft.mand.tool.thumb.ImageSource;
import com.mandelsoft.mand.tool.thumb.MandelImageRequestQueue;
import com.mandelsoft.mand.tool.thumb.ThumbnailFactory;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class AsyncThumbnailFactory
extends AbstractThumbnailFactory {
    private MandelImageRequestQueue queue;
    private Listener listener = new Listener();

    public AsyncThumbnailFactory(ThumbnailFactory.Client client) {
        super(client);
        this.queue = new MandelImageRequestQueue(){

            @Override
            public MandelScanner getMandelScanner() {
                return AsyncThumbnailFactory.this.client.getMandelScanner();
            }
        };
    }

    public AsyncThumbnailFactory(ThumbnailFactory.Client client, int max) {
        this(client);
        this.maxcache = max;
    }

    public void setColormapSourceFactory(ColormapSourceFactory colmapfac) {
        this.queue.setColormapSourceFactory(colmapfac);
    }

    public ColormapSourceFactory getColormapSourceFactory() {
        return this.queue.getColormapSourceFactory();
    }

    @Override
    public void setFactory(MandelImage.Factory factory) {
        this.queue.setFactory(factory);
    }

    @Override
    public MandelImage.Factory getFactory() {
        return this.queue.getFactory();
    }

    @Override
    public BufferedImage getThumbnail(QualifiedMandelName n, Dimension max) {
        BufferedImage image = this.requestThumbnail(n, max).getImage();
        if (image != null) {
            this.lifo.remove(n);
            this.lifo.add(n);
            if (this.lifo.size() > this.maxcache) {
                this.remove((QualifiedMandelName)this.lifo.get(0));
            }
        }
        return image;
    }

    public ImageSource<QualifiedMandelName> requestThumbnail(QualifiedMandelName n, Dimension max) {
        ImageSource<QualifiedMandelName> src;
        n = n.getBaseName();
        if (this.queue.getMaxSize() == null || !max.equals(this.queue.getMaxSize())) {
            this.thumbnails.clear();
            this.queue.clear();
            this.lifo.clear();
            this.queue.setMaxSize(max);
        }
        if ((src = (ImageSource<QualifiedMandelName>)this.thumbnails.get(n)) == null) {
            src = this.queue.requestImage(n);
            src.addImageChangeListener(this.listener);
            this.thumbnails.put(n, src);
        } else {
            this.queue.reschedule(src);
        }
        return src;
    }

    private class Listener
    implements ImageChangeListener<QualifiedMandelName> {
        private Listener() {
        }

        @Override
        public void imageChanged(ImageSource<QualifiedMandelName> c) {
            AsyncThumbnailFactory.this.fireImageChanged(c);
        }
    }
}

