/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.thumb;

import com.mandelsoft.mand.tool.thumb.ImageChangeListener;
import com.mandelsoft.mand.tool.thumb.ImageSource;
import java.util.ArrayList;
import java.util.List;

public class ImageChangeListenerSupport<S> {
    private List<ImageChangeListener<S>> list;

    public void fireImageChanged(ImageSource<S> src) {
        if (this.list != null) {
            for (ImageChangeListener<S> l : this.list) {
                l.imageChanged(src);
            }
        }
    }

    public void addImageChangeListener(ImageChangeListener<S> l) {
        if (this.list == null) {
            this.list = new ArrayList<ImageChangeListener<S>>();
        } else if (this.list.contains(l)) {
            return;
        }
        this.list.add(l);
    }

    public void removeImageChangeListener(ImageChangeListener<S> l) {
        if (this.list != null) {
            this.list.remove(l);
            if (this.list.isEmpty()) {
                this.list = null;
            }
        }
    }
}

