/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.util;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;

public class RasterCleaner {
    private MandelInfo info;
    private MandelRaster raster;
    private int limit;
    private int rx;
    private int ry;

    public RasterCleaner(MandelData data) {
        this.info = data.getInfo();
        this.raster = data.getRaster();
        this.limit = data.getInfo().getLimitIt();
        this.rx = this.info.getRX();
        this.ry = this.info.getRY();
    }

    public void clean(int max, int r) {
        for (int y = 0; y < this.ry; ++y) {
            for (int x = 0; x < this.rx; ++x) {
                int c;
                if (this.raster.getData(x, y) != 0 || (c = this.countBlack(x, y, r)) >= max) continue;
                this.raster.setData(x, y, this.limit - 1);
            }
        }
    }

    private int countBlack(int x, int y, int r) {
        int c = 0;
        int n = 0;
        for (int j = y - r; j <= y + r; ++j) {
            if (j < 0 || j >= this.ry) continue;
            for (int i = x - r; i <= x + r; ++i) {
                if (i < 0 || i >= this.rx) continue;
                ++n;
                if (this.raster.getData(i, j) != 0) continue;
                ++c;
            }
        }
        return c * 100 / n;
    }
}

