/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.FilteredMandelScanner;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tools.Cmd;
import com.mandelsoft.mand.tools.Command;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Cleanup
extends Cmd {
    List<String> log = new ArrayList<String>();
    Environment env;

    public Cleanup(Environment env) {
        this.env = env;
    }

    void log(String msg) {
        this.log.add(msg);
        System.out.println("*** " + msg);
    }

    void print() {
        System.out.println("");
        System.out.println("*** Action summary ***");
        for (String msg : this.log) {
            System.out.println("  " + msg);
        }
    }

    void doit(boolean doit) {
        QualifiedMandelName n;
        MandelScanner scanner = this.env.getInfoScanner();
        MandelScanner ref = this.env.getImageDataScanner();
        Set<QualifiedMandelName> refset = ref.getQualifiedMandelNames();
        for (MandelHandle h : scanner.getMandelHandles()) {
            n = (QualifiedMandelName)h.getName();
            if (!refset.contains(n)) continue;
            boolean found = false;
            try {
                MandelData info = h.getInfo();
                Set<MandelHandle> set = ref.getMandelHandles(n);
                for (MandelHandle i : set) {
                    try {
                        MandelData data = i.getInfo();
                        if (!data.getInfo().isSameSpec(info.getInfo())) continue;
                        this.log("found data for request " + h.getFile() + ": " + i.getFile());
                        found = true;
                    }
                    catch (IOException ex) {
                        System.out.println("cannot read " + i.getFile() + ": " + ex);
                    }
                }
            }
            catch (IOException ex) {
                System.out.println("cannot read " + h.getFile() + ": " + ex);
            }
            if (found) {
                this.log("obsolete request for " + h.getFile());
                if (!doit) continue;
                this.env.backupInfoFile(h.getFile());
                continue;
            }
            this.log("refinement request for " + h.getFile());
        }
        for (QualifiedMandelName n2 : refset) {
            MandelData best = null;
            Set<MandelHandle> set = ref.getMandelHandles(n2);
            if (set.size() > 1) {
                for (MandelHandle i : set) {
                    try {
                        MandelData data = i.getInfo();
                        this.log("found refinement: " + data.getInfo().getLimitIt() + ": " + i.getFile());
                        if (best == null) {
                            best = data;
                            continue;
                        }
                        if (data.getInfo().getLimitIt() <= best.getInfo().getLimitIt()) continue;
                        if (doit) {
                            File file = best.getFile().getFile();
                            MandelFolder folder = MandelFolder.getMandelFolder(file);
                            folder.remove(file);
                        }
                        best = data;
                    }
                    catch (IOException ex) {
                        System.out.println("cannot read " + i.getFile() + ": " + ex);
                    }
                }
            }
            if (best == null) continue;
            this.log("found refined replacement " + best.getFile());
        }
        scanner = new FilteredMandelScanner(this.env.getImageDataScanner(), MandelScanner.IS_RASTER);
        ref = this.env.getRasterImageScanner();
        refset = ref.getQualifiedMandelNames();
        for (MandelHandle h : scanner.getMandelHandles()) {
            n = (QualifiedMandelName)h.getName();
            if (!refset.contains(n)) continue;
            this.log("obsolete raster data" + h.getFile());
            if (!doit) continue;
            this.env.backupRasterFile(h.getFile());
        }
    }

    public static void main(String[] args) {
        boolean doit = false;
        String root = ".";
        if (args.length > 0) {
            root = args[0];
        }
        try {
            Environment env = new Environment("mandtool", null, new File(root));
            Cleanup c = new Cleanup(env);
            c.doit(doit);
            c.print();
        }
        catch (IllegalConfigurationException ex) {
            Command.Error("illegal config: " + ex);
        }
    }
}

