/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.tools.Command;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Info
extends Command {
    /*
     * Could not resolve type clashes
     */
    public static void main(String[] args) {
        boolean iflag = false;
        boolean cflag = false;
        boolean sflag = false;
        boolean fix = false;
        int depth = -1;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.startsWith("-")) {
                block13: for (char c : a.substring(1).toCharArray()) {
                    switch (c) {
                        case 'i': {
                            iflag = true;
                            continue block13;
                        }
                        case 's': {
                            sflag = true;
                            continue block13;
                        }
                        case 'c': {
                            if (cflag) {
                                fix = true;
                            }
                            cflag = true;
                            continue block13;
                        }
                        case 'd': {
                            if (i == args.length - 1) {
                                Info.Error("it missing for -d");
                            }
                            try {
                                depth = Integer.parseInt(args[++i]);
                            }
                            catch (NumberFormatException e) {
                                Info.Error("argument for -d must be an integer");
                            }
                            continue block13;
                        }
                        default: {
                            Info.Error("invalid option %s", Character.valueOf(c));
                        }
                    }
                }
                continue;
            }
            list.add(a);
        }
        for (String fn : list) {
            MandelFileName mfn = MandelFileName.create(new File(fn).getName());
            System.out.printf("%s\n", fn);
            try {
                MandelRaster r;
                int x;
                int y;
                MandelRaster raster;
                MandelData md = new MandelData(iflag, new File(fn));
                MandelInfo info = md.getInfo();
                MandelHeader h = md.getHeader();
                System.out.printf("version: %d\n", info.getVersion());
                System.out.printf("type:    %s\n", h);
                System.out.printf("rx:      %d\n", info.getRX());
                System.out.printf("ry:      %d\n", info.getRY());
                System.out.printf("limit:   %d\n", info.getLimitIt());
                System.out.printf("minit:   %d\n", info.getMinIt());
                System.out.printf("maxit:   %d\n", info.getMaxIt());
                System.out.printf("black:   %d\n", info.getMCnt());
                if (h.hasImage()) {
                    System.out.println("has image");
                }
                if (h.hasRaster()) {
                    System.out.println("has raster");
                }
                if (h.hasColormap()) {
                    System.out.println("has colormap");
                }
                if (h.hasMapper()) {
                    System.out.println("has mapper");
                }
                if (h.hasMapping()) {
                    System.out.println("has mapping");
                }
                if (info.getKeywords() != null) {
                    System.out.println("keywords:");
                    for (Object e : info.getKeywords()) {
                        System.out.println(" - " + (String)e);
                    }
                }
                if (info.getProperties() != null) {
                    System.out.println("attributes:");
                    for (Object e : info.getProperties().entrySet()) {
                        System.out.println("  " + (String)e.getKey() + " = " + (String)e.getValue());
                    }
                }
                if (depth > 0) {
                    if (!h.hasRaster()) {
                        Info.Error("no raster data available");
                    }
                    raster = md.getRaster();
                    int cnt = 0;
                    for (y = 0; y < info.getRY(); ++y) {
                        for (x = 0; x < info.getRX(); ++x) {
                            if (raster.getData(x, y) <= depth) continue;
                            ++cnt;
                        }
                    }
                    System.out.printf("found %d points deeper than %d\n", cnt, depth);
                }
                if (cflag) {
                    if (iflag || sflag) {
                        Info.Error("-c only without -i and -s");
                    }
                    if (!h.hasRaster()) {
                        Info.Error("no raster data available");
                    }
                    raster = md.getRaster();
                    boolean incomplete = false;
                    block19: for (y = 0; y < info.getRY(); ++y) {
                        for (x = 0; x < info.getRX(); ++x) {
                            if (raster.getData(x, y) <= info.getLimitIt()) continue;
                            incomplete = true;
                            break block19;
                        }
                    }
                    if (incomplete) {
                        System.out.println("raster is incomplete");
                    } else {
                        System.out.println("raster is complete");
                    }
                    if (fix && (md.getHeader().isIncomplete() != incomplete || md.getInfo().getLimitIt() < depth)) {
                        if (md.getHeader().isIncomplete() != incomplete) {
                            System.out.println("fixing incomplete");
                            md.setIncomplete(incomplete);
                        }
                        if (md.getInfo().getLimitIt() < depth) {
                            System.out.println("fixing limit it");
                            md.getInfo().setLimitIt(depth);
                        }
                        md.write();
                    }
                }
                if (!sflag) continue;
                if (cflag) {
                    Info.Error("-s only without -i and -c");
                }
                String qual = String.format("%d-%d", info.getRX() / 2, info.getRY() / 2);
                File nf = new File(new File(fn).getParentFile(), new MandelFileName(mfn.getName(), qual, mfn.getSuffix()).toString());
                if (nf.exists()) {
                    Info.Error("file %s already exists", nf.toString());
                }
                if ((r = md.getRaster()) == null) {
                    Info.Error("no raster info for %s", fn);
                }
                MandelRaster n = new MandelRaster((info.getRX() + 1) / 2, (info.getRY() + 1) / 2);
                for (int y2 = 0; y2 < info.getRY(); y2 += 2) {
                    int ny = y2 / 2;
                    for (int x2 = 0; x2 < info.getRX(); x2 += 2) {
                        n.setData(x2 / 2, ny, r.getData(x2, y2));
                    }
                }
                info.setRX(n.getRX());
                info.setRY(n.getRY());
                md.setRaster(n);
                try {
                    md.write(nf, true);
                }
                catch (IOException ex) {
                    Info.Error("cannot write %s: %s", nf, ex);
                }
            }
            catch (IOException ex) {
                Info.Error("cannot load %s: %s", fn, ex);
            }
        }
    }
}

