/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.ArrayBaseList;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.PropertyBag;
import com.mandelsoft.util.IteratedIteratorSupport;
import com.mandelsoft.util.Utils;
import java.util.Collection;
import java.util.Iterator;

public abstract class ArrayMandelListFolder
extends ArrayBaseList<MandelListFolder>
implements MandelListFolder {
    private MandelListFolder parent;
    private String name;
    private QualifiedMandelName thumb;
    private MandelList list;
    private String identifier;
    private static int cnt = 0;
    private PropertyBag properties = new PropertyBag();

    public ArrayMandelListFolder(String name) {
        this.name = name;
        this.list = this.createMandelList();
        this.identifier = Utils.getObjectIdentifier(this, ++cnt);
    }

    @Override
    public boolean containsTransitively(MandelListFolder f) {
        if (f == this) {
            return true;
        }
        for (MandelListFolder sub : this) {
            if (!sub.containsTransitively(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTransitively(MandelList l) {
        if (this.getMandelList() == l) {
            return true;
        }
        for (MandelListFolder f : this) {
            if (!f.containsTransitively(l)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(MandelListFolder f) {
        boolean b = false;
        if (!this.contains(f) && (b = super.add(f))) {
            f.setParent(this);
        }
        return b;
    }

    @Override
    public void add(int index, MandelListFolder f) {
        if (!this.contains(f)) {
            super.add(index, f);
            f.setParent(this);
        }
    }

    @Override
    public boolean addAll(Collection<? extends MandelListFolder> c) {
        boolean add = false;
        for (MandelListFolder mandelListFolder : c) {
            add |= this.add(mandelListFolder);
        }
        return add;
    }

    @Override
    public boolean addAll(int index, Collection<? extends MandelListFolder> c) {
        boolean add = false;
        for (MandelListFolder mandelListFolder : c) {
            if (this.contains(mandelListFolder)) continue;
            this.add(index++, mandelListFolder);
            add = true;
        }
        return add;
    }

    public boolean isLocalFolder(MandelListFolder f) {
        MandelListFolder folder = this;
        while (folder.getParent() != null) {
            folder = folder.getParent();
        }
        while (f != null && f != folder) {
            f = f.getParent();
        }
        return f == folder;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = false;
        if (this.contains(o)) {
            b = super.remove(o);
            MandelListFolder f = (MandelListFolder)o;
            f.setParent(null);
        }
        return b;
    }

    @Override
    public MandelListFolder remove(int index) {
        MandelListFolder f = (MandelListFolder)super.remove(index);
        f.setParent(null);
        return f;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QualifiedMandelName getThumbnailName() {
        return this.thumb;
    }

    @Override
    public void setThumbnailName(QualifiedMandelName thumb) {
        this.thumb = thumb;
    }

    @Override
    public String getPath() {
        if (this.getParent() == null) {
            return this.getName();
        }
        StringBuffer sb = new StringBuffer();
        this.getPath(sb, this.getParent());
        sb.append("/");
        sb.append(this.getName());
        return sb.toString();
    }

    private void getPath(StringBuffer sb, MandelListFolder f) {
        if (f.getParent() != null) {
            this.getPath(sb, f.getParent());
            sb.append("/");
        }
        sb.append(f.getName());
    }

    @Override
    public MandelListFolder getSubFolder(String name) {
        for (MandelListFolder f : this) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public MandelListFolder getParent() {
        return this.parent;
    }

    protected abstract MandelList createMandelList();

    @Override
    public void setParent(MandelListFolder f) {
        if (this.parent != f) {
            if (this.parent != null) {
                this.parent.remove(this);
            }
            this.parent = f;
        }
    }

    @Override
    public MandelList getMandelList() {
        return this.list;
    }

    @Override
    public boolean hasMandelList() {
        return this.getMandelList() != null;
    }

    @Override
    public Iterable<QualifiedMandelName> allentries() {
        return new Iterable<QualifiedMandelName>(){

            @Override
            public Iterator<QualifiedMandelName> iterator() {
                return new AllIterator(new MandelListFolderIterator(ArrayMandelListFolder.this));
            }
        };
    }

    @Override
    public Iterable<MandelListFolder> allfolders() {
        return new Iterable<MandelListFolder>(){

            @Override
            public Iterator<MandelListFolder> iterator() {
                return new MandelListFolderIterator(ArrayMandelListFolder.this);
            }
        };
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public Iterable<String> propertyNames() {
        return this.properties.propertyNames();
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.identifier + "): " + Utils.getObjectIdentifier(this.getMandelListFolderTree());
    }

    private static class AllIterator
    extends IteratedIteratorSupport<QualifiedMandelName, MandelListFolder> {
        public AllIterator(Iterator<MandelListFolder> folders) {
            super(null, folders);
            this.setup();
        }

        @Override
        protected Iterator<QualifiedMandelName> _getIterator(MandelListFolder src) {
            if (src.getMandelList() == null) {
                return null;
            }
            return src.getMandelList().iterator();
        }
    }

    private static class MandelListFolderIterator
    extends IteratedIteratorSupport<MandelListFolder, MandelListFolder> {
        public MandelListFolderIterator(MandelListFolder folder) {
            super(folder, folder.iterator());
        }

        @Override
        protected Iterator<MandelListFolder> _getIterator(MandelListFolder src) {
            return src.allfolders().iterator();
        }
    }
}

