/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.NestedMandelListFolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultMandelListFolderTree
implements MandelListFolderTree {
    public static boolean debug;
    private MandelListFolder root;

    public DefaultMandelListFolderTree(String name) {
        this.root = this.createRootFolder(name);
    }

    protected DefaultMandelListFolderTree(MandelListFolder root) {
        this.root = root;
    }

    protected MandelListFolder createRootFolder(String name) {
        return new NestedMandelListFolder(this, name);
    }

    @Override
    public MandelListFolder getRoot() {
        return this.root;
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public void clear() {
        MandelListFolder f = this.getRoot();
        MandelList l = f.getMandelList();
        f.clear();
        if (l != null) {
            l.clear();
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void save() throws IOException {
        new UnsupportedOperationException("save of tree");
    }

    @Override
    public void save(File f) throws IOException {
        this.write(new FileOutputStream(f), f.getPath());
    }

    @Override
    public void read(InputStream is, String src) throws IOException {
        MandelListFolderTree.IO.read(this, is, src);
    }

    @Override
    public final void write(OutputStream os, String dst) throws IOException {
        this.write(os, null, dst);
    }

    public void write(OutputStream os, MandelListFolderTree.IO.Modifier m, String dst) throws IOException {
        MandelListFolderTree.IO.write(this, m, os, dst);
    }

    public static void print(String gap, MandelListFolder f) {
        System.out.println(gap + "-> " + f.getName());
        gap = gap + "  ";
        for (QualifiedMandelName n : f.getMandelList()) {
            System.out.println(gap + n);
        }
        for (MandelListFolder s : f) {
            DefaultMandelListFolderTree.print(gap, s);
        }
    }
}

